clear all;
% Script for importing data from the following text file:
%
%    C:\Users\subha\Downloads\Matlab_code_ppt\New folder\Final_demo_data.txt
%
% To extend the code to different selected data or a different text file,
% generate a function instead of a script.

% Auto-generated by MATLAB on 2022/05/03 18:27:03

%% Initialize variables.
filename = 'C:\Users\subha\Downloads\Matlab_code_ppt\New folder\Final_demo_data.txt';
delimiter = ' ';
startRow = 2;

%% Read columns of data as text:
% For more information, see the TEXTSCAN documentation.
formatSpec = '%s%s%s%s%s%s%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to the format.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'MultipleDelimsAsOne', true, 'TextType', 'string', 'HeaderLines' ,startRow-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');

%% Close the text file.
fclose(fileID);

%% Convert the contents of columns containing numeric text to numbers.
% Replace non-numeric text with NaN.
raw = repmat({''},length(dataArray{1}),length(dataArray)-1);
for col=1:length(dataArray)-1
    raw(1:length(dataArray{col}),col) = mat2cell(dataArray{col}, ones(length(dataArray{col}), 1));
end
numericData = NaN(size(dataArray{1},1),size(dataArray,2));

for col=[1,2,3,4,5,6]
    % Converts text in the input cell array to numbers. Replaced non-numeric
    % text with NaN.
    rawData = dataArray{col};
    for row=1:size(rawData, 1)
        % Create a regular expression to detect and remove non-numeric prefixes and
        % suffixes.
        regexstr = '(?<prefix>.*?)(?<numbers>([-]*(\d+[\,]*)+[\.]{0,1}\d*[eEdD]{0,1}[-+]*\d*[i]{0,1})|([-]*(\d+[\,]*)*[\.]{1,1}\d+[eEdD]{0,1}[-+]*\d*[i]{0,1}))(?<suffix>.*)';
        try
            result = regexp(rawData(row), regexstr, 'names');
            numbers = result.numbers;
            
            % Detected commas in non-thousand locations.
            invalidThousandsSeparator = false;
            if numbers.contains(',')
                thousandsRegExp = '^\d+?(\,\d{3})*\.{0,1}\d*$';
                if isempty(regexp(numbers, thousandsRegExp, 'once'))
                    numbers = NaN;
                    invalidThousandsSeparator = true;
                end
            end
            % Convert numeric text to numbers.
            if ~invalidThousandsSeparator
                numbers = textscan(char(strrep(numbers, ',', '')), '%f');
                numericData(row, col) = numbers{1};
                raw{row, col} = numbers{1};
            end
        catch
            raw{row, col} = rawData{row};
        end
    end
end


%% Replace non-numeric cells with NaN
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN}; % Replace non-numeric cells

%% Create output variable
Finaldemodata = cell2mat(raw);
%% Clear temporary variables
clearvars filename delimiter startRow formatSpec fileID dataArray ans raw col numericData rawData row regexstr result numbers invalidThousandsSeparator thousandsRegExp R;
for i=1:500
Va(i)=Finaldemodata(i);
Vb(i)=Finaldemodata(i+500);
Vc(i)=Finaldemodata(i+1000);
Ia(i)=Finaldemodata(i+1500);
Ib(i)=Finaldemodata(i+2000);
Ic(i)=Finaldemodata(i+2500);
V_d(i)=Finaldemodata(i+3000);
V_q(i)=Finaldemodata(i+3500);
I_d(i)=Finaldemodata(i+4000);
I_q(i)=Finaldemodata(i+4500);
THETA(i)=Finaldemodata(i+5000);
Vdc(i)=Finaldemodata(i+5500);
time(i)=i*0.0004;
end

figure(1)
plot(time,Va,'r','linewidth',1); hold on; grid on;plot(time,Vb,'c','linewidth',1);plot(time,Vc,'b','linewidth',1);legend('Va','Vb','Vc');xlabel('Time','fontsize',10);ylabel('Voltages(V)','fontsize',10);title('Voltages (abc)','fontsize',12);
 figure(2)
 plot(time,Ia,'r'); hold on; grid on;plot(time,Ib,'y');plot(time,Ic,'b');
figure(3)
plot(time,V_d,'r','linewidth',1); hold on; grid on;plot(time,V_q,'c','linewidth',1);legend('Vd','Vq');xlabel('Time','fontsize',10);ylabel('Voltages(V)','fontsize',10);title('Voltages (d-q frame)','fontsize',12);
figure(4)
plot(I_d,'r'); hold on; grid on;plot(I_q,'y');
figure(5)
plot(time,THETA,'r','linewidth',1); hold on; grid on;legend('Theta');xlabel('Time','fontsize',10);ylabel('Angle(rad)','fontsize',10);title('Theta (rad)','fontsize',12);
figure(6)
plot(time,57*cos(THETA),'b'); hold on; grid on;plot(time,Va,'r');legend('Pll output','Va');xlabel('Time','fontsize',10);ylabel('Voltages(V)','fontsize',10);title('PLL Output','fontsize',12);
figure(7)
plot(time,Vdc,'b');grid on; ylim([0,150]);legend('Vdc');xlabel('Time','fontsize',10);ylabel('Voltage(V)','fontsize',10);title('DC link Voltages','fontsize',12);
