//*****************************************************************************
//
// images.c - Data for the images used by the application.
//
// Copyright (c) 2012-2017 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.1.4.178 of the EK-TM4C123GXL Firmware Package.
//
//*****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include "grlib/grlib.h"

//*****************************************************************************
//
// The image of the TI symbol.
//
//*****************************************************************************
const uint8_t g_pui8Logo[] =
{
    IMAGE_FMT_4BPP_COMP,
    50, 0,
    50, 0,

    15,
    0x00, 0x00, 0x00,
    0x03, 0x02, 0x13,
    0x07, 0x05, 0x2a,
    0x0a, 0x08, 0x41,
    0x0d, 0x0a, 0x55,
    0x10, 0x0c, 0x68,
    0x12, 0x0e, 0x74,
    0x15, 0x10, 0x88,
    0x17, 0x12, 0x97,
    0x19, 0x14, 0xa7,
    0x1c, 0x16, 0xb8,
    0x1e, 0x18, 0xc8,
    0x20, 0x19, 0xd6,
    0x22, 0x1b, 0xe1,
    0x24, 0x1c, 0xe9,
    0x24, 0x1c, 0xed,

    0xf0, 0x07, 0x07, 0x07, 0x02, 0x04, 0xba, 0xaa, 0xaa, 0x18, 0xaa, 0xac,
    0x30, 0x07, 0x07, 0x05, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0x40, 0x3f,
    0x3f, 0x3f, 0x3f, 0xc7, 0x3f, 0x3d, 0x48, 0x78, 0x50, 0x3f, 0x3f, 0x3a,
    0x1c, 0xbf, 0xff, 0x70, 0x3f, 0x3f, 0x39, 0x01, 0xdf, 0xe0, 0x12, 0x3f,
    0x3f, 0x00, 0x04, 0xff, 0xff, 0x20, 0xe1, 0x3f, 0x3f, 0x39, 0x03, 0x97,
    0x87, 0x10, 0x3f, 0xf8, 0x3f, 0x39, 0x5f, 0x3f, 0x3b, 0x96, 0x82, 0x06,
    0x00, 0x87, 0x84, 0x04, 0x87, 0x77, 0x77, 0x78, 0x30, 0xc0, 0x3f, 0x3b,
    0xff, 0xd1, 0x0d, 0xff, 0xf5, 0x09, 0xb0, 0xaa, 0x60, 0x3f, 0x3c, 0xa0,
    0x2f, 0xff, 0xf2, 0x60, 0x0c, 0x3f, 0x3f, 0xff, 0xff, 0x80, 0x4f, 0xff,
    0x30, 0xc0, 0x1e, 0x3f, 0x3f, 0xff, 0xff, 0x50, 0x7f, 0x18, 0xff, 0x90,
    0x4f, 0x3f, 0x3f, 0xfd, 0xef, 0x20, 0x06, 0xaf, 0xff, 0x70, 0x7f, 0xdd,
    0x3f, 0x3e, 0xb2, 0x01, 0x12, 0x01, 0xcf, 0xff, 0x50, 0x12, 0x07, 0x3f,
    0x80, 0x3e, 0x80, 0x00, 0x03, 0xff, 0xff, 0x30, 0x00, 0x5a, 0x08, 0x39,
    0x70, 0x3f, 0x3a, 0x60, 0x01, 0xfc, 0x10, 0x10, 0x00, 0x1b, 0x39, 0xb0,
    0x00, 0x00, 0x8c, 0x02, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xab, 0x3a, 0x40,
    0x01, 0x00, 0x07, 0xff, 0xfa, 0x00, 0x00, 0x2f, 0x39, 0x0c, 0xf6, 0x00,
    0x00, 0x7f, 0x6a, 0x4a, 0xff, 0xfd, 0x00, 0x20, 0x00, 0x0a, 0xff, 0xf7,
    0x00, 0x00, 0x4f, 0x84, 0x39, 0xfe, 0x40, 0x00, 0x29, 0x3f, 0xfe, 0xab,
    0x01, 0xa0, 0x1c, 0xff, 0xf4, 0x08, 0xca, 0xcf, 0x72, 0x08, 0xf7, 0x00,
    0x02, 0xdf, 0x37, 0xff, 0xb0, 0x2f, 0x10, 0xff, 0xf2, 0x0c, 0x8c, 0xf7,
    0x00, 0x00, 0x3f, 0x81, 0x3f, 0xff, 0x80, 0x4f, 0xff, 0xc0, 0x2e, 0x3f,
    0x20, 0x02, 0xcf, 0x37, 0x50, 0x8f, 0xff, 0xa0, 0x4f, 0x90, 0x3f, 0x00,
    0x2c, 0x3f, 0x30, 0xaf, 0xff, 0x70, 0x48, 0x7f, 0x3f, 0x00, 0x02, 0x3e,
    0xfd, 0x10, 0xcf, 0x11, 0xff, 0x40, 0x9f, 0x3f, 0x00, 0x00, 0x8f, 0x35,
    0x02, 0xfa, 0x02, 0xff, 0xfe, 0x20, 0xcf, 0x3f, 0x00, 0x20, 0x00, 0x2f,
    0x3d, 0xf8, 0x05, 0xff, 0xfd, 0x00, 0xd0, 0x3f, 0x31, 0x09, 0x3d, 0xf5,
    0x03, 0x54, 0x53, 0x12, 0x00, 0x34, 0x6e, 0x3f, 0x00, 0x04, 0x39, 0xfa,
    0x09, 0x9c, 0xff, 0xff, 0xf3, 0x9a, 0x00, 0x3f, 0x3a, 0x20, 0xa6, 0x31,
    0xa3, 0xaf, 0xff, 0xfe, 0x30, 0x01, 0x10, 0xbf, 0xff, 0xd1, 0x3b, 0x7f,
    0xff, 0xff, 0xfd, 0x40, 0x72, 0x4b, 0x00, 0x00, 0x2c, 0xff, 0xe3, 0x00,
    0x08, 0x00, 0x2d, 0xff, 0xe1, 0x3b, 0x9f, 0xff, 0xfe, 0x40, 0x71, 0x45,
    0x00, 0x01, 0x68, 0x20, 0x00, 0x00, 0x11, 0x06, 0xff, 0xf6, 0xa3, 0xbf,
    0xff, 0xb2, 0x46, 0x80, 0x15, 0xbf, 0xff, 0x94, 0x33, 0x22, 0x22, 0x23,
    0x30, 0xef, 0xf8, 0x47, 0x05, 0x6f, 0xff, 0xff, 0xfe, 0x06, 0xee, 0xee,
    0xee, 0xff, 0x70, 0x3f, 0x05, 0x1c, 0x16, 0xff, 0xff, 0xff, 0xe9, 0xf9,
    0x47, 0x06, 0x07, 0xb2, 0x3c, 0xc1, 0x3f, 0x06, 0x02, 0xdf, 0x33, 0x50,
    0xd3, 0x3f, 0x07, 0x7f, 0x3a, 0xfc, 0x10, 0x3f, 0x07, 0x59, 0x2d, 0x3a,
    0xf9, 0x47, 0x07, 0x00, 0x05, 0x3a, 0x62, 0xf7, 0x3f, 0x07, 0x00, 0x00,
    0x9f, 0x31, 0xf8, 0xc5, 0x3f, 0x07, 0x00, 0x00, 0x0a, 0x39, 0xf9, 0x3f,
    0xc1, 0x07, 0x01, 0x9f, 0xff, 0xff, 0xfc, 0x10, 0x37, 0x80, 0x07, 0x00,
    0x00, 0x06, 0xdf, 0xff, 0xff, 0x50, 0xe1, 0x3f, 0x07, 0x01, 0x15, 0x78,
    0x86, 0x20, 0x3f, 0xff, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x00, 0x00,
};

//*****************************************************************************
//
// This is the image of a red LED that is turned off.
//
//*****************************************************************************
const uint8_t g_pui8LightOff[] =
{
    IMAGE_FMT_4BPP_COMP,
    20, 0,
    20, 0,

    15,
    0x00, 0x00, 0x00,
    0x00, 0x00, 0x09,
    0x00, 0x00, 0x19,
    0x00, 0x00, 0x2a,
    0x00, 0x00, 0x30,
    0x00, 0x00, 0x34,
    0x00, 0x00, 0x37,
    0x00, 0x00, 0x3a,
    0x00, 0x00, 0x3d,
    0x00, 0x00, 0x3f,
    0x00, 0x00, 0x40,
    0x00, 0x00, 0x42,
    0x00, 0x00, 0x45,
    0x00, 0x00, 0x4a,
    0x00, 0x00, 0x50,
    0x00, 0x00, 0x56,

    0x84, 0x01, 0x13, 0xaf, 0xe8, 0x31, 0x03, 0x1b, 0xff, 0x08, 0xff, 0xee,
    0xed, 0x71, 0x01, 0x02, 0xff, 0xff, 0x00, 0xfe, 0xed, 0xdd, 0xcc, 0x20,
    0x00, 0x00, 0x2f, 0x00, 0xff, 0xfe, 0xee, 0xdd, 0xcc, 0xcb, 0xa2, 0x00,
    0x40, 0x01, 0x21, 0xdd, 0xdc, 0xcc, 0xbb, 0xa8, 0x10, 0x00, 0x09, 0xff,
    0xfe, 0xdd, 0xdc, 0xcb, 0xbb, 0xba, 0x00, 0x98, 0x30, 0x1e, 0xfe, 0xed,
    0xdc, 0xcb, 0xaa, 0x00, 0xaa, 0xaa, 0x98, 0x61, 0x3e, 0xfe, 0xdd, 0xcc,
    0x00, 0xba, 0x99, 0x9a, 0xaa, 0x98, 0x62, 0x7d, 0xee, 0x00, 0xdc, 0xcb,
    0xa9, 0x99, 0x99, 0x99, 0x88, 0x73, 0x08, 0xcd, 0xed, 0xdc, 0xba, 0xb9,
    0x99, 0x88, 0x64, 0x20, 0xcc, 0xdd, 0x6b, 0x99, 0x87, 0x63, 0x6c, 0xcc,
    0x40, 0xba, 0x1a, 0x98, 0x76, 0x42, 0x2b, 0xba, 0xaa, 0x88, 0x1b, 0x65,
    0x42, 0x1a, 0x2a, 0x99, 0x98, 0x87, 0x00, 0x64, 0x30, 0x04, 0x78, 0x88,
    0x88, 0x89, 0x99, 0x00, 0x88, 0x76, 0x54, 0x20, 0x01, 0x67, 0x77, 0x88,
    0x00, 0x88, 0x88, 0x87, 0x65, 0x43, 0x00, 0x00, 0x25, 0x00, 0x67, 0x77,
    0x77, 0x77, 0x65, 0x44, 0x31, 0x00, 0x00, 0x00, 0x01, 0x45, 0x66, 0x66,
    0x65, 0x54, 0x43, 0x00, 0x10, 0x00, 0x00, 0x00, 0x13, 0x44, 0x45, 0x44,
    0x20, 0x33, 0x20, 0xb9, 0x00, 0x00, 0x12, 0x23, 0x32, 0x80, 0x72,
};

//*****************************************************************************
//
// This is the image of a red LED that is turned on.
//
//*****************************************************************************
const uint8_t g_pui8LightOn[] =
{
    IMAGE_FMT_4BPP_COMP,
    20, 0,
    20, 0,

    15,
    0x00, 0x00, 0x00,
    0x00, 0x00, 0x16,
    0x00, 0x00, 0x40,
    0x00, 0x00, 0x76,
    0x00, 0x00, 0x9b,
    0x00, 0x00, 0xac,
    0x00, 0x00, 0xb6,
    0x00, 0x00, 0xbc,
    0x00, 0x00, 0xbe,
    0x00, 0x00, 0xbf,
    0x00, 0x00, 0xc1,
    0x00, 0x00, 0xc5,
    0x00, 0x00, 0xcd,
    0x00, 0x00, 0xdb,
    0x00, 0x00, 0xef,
    0x00, 0x00, 0xfc,

    0x84, 0x01, 0x13, 0xaf, 0xe7, 0x31, 0x03, 0x1b, 0xff, 0x09, 0xff, 0xee,
    0xee, 0x51, 0x01, 0x02, 0xff, 0xb1, 0x02, 0xdd, 0xcc, 0x20, 0x00, 0x00,
    0x2f, 0xbb, 0xcc, 0x10, 0x92, 0x00, 0x01, 0x72, 0xdc, 0xcc, 0xcb, 0x96,
    0x00, 0x10, 0x07, 0xff, 0xfe, 0xed, 0xdc, 0xcc, 0xbb, 0x08, 0xba, 0x96,
    0x30, 0x1e, 0x22, 0xba, 0xaa, 0xaa, 0x10, 0x86, 0x51, 0x3e, 0x69, 0xba,
    0x99, 0x99, 0x99, 0x01, 0x76, 0x52, 0x5d, 0xee, 0xdd, 0xcb, 0xa9, 0xb2,
    0x20, 0x53, 0xcd, 0x6c, 0x98, 0x76, 0x54, 0xcc, 0xdd, 0x40, 0xcc, 0x6a,
    0x97, 0x66, 0x43, 0x5c, 0xcc, 0xba, 0x40, 0x98, 0x19, 0x87, 0x65, 0x43,
    0x3c, 0xcb, 0xa9, 0x20, 0x98, 0x89, 0x1a, 0x42, 0x1a, 0x88, 0x98, 0x77,
    0x40, 0x88, 0x69, 0x44, 0x31, 0x04, 0x67, 0x77, 0x77, 0x00, 0x78, 0x88,
    0x76, 0x55, 0x44, 0x20, 0x01, 0x55, 0x00, 0x66, 0x66, 0x77, 0x77, 0x65,
    0x54, 0x43, 0x10, 0x00, 0x00, 0x24, 0x55, 0x55, 0x66, 0x65, 0x54, 0x44,
    0x00, 0x31, 0x00, 0x00, 0x02, 0x44, 0x45, 0x55, 0x54, 0x00, 0x44, 0x33,
    0x10, 0x00, 0x00, 0x00, 0x13, 0x44, 0x08, 0x44, 0x44, 0x33, 0x21, 0xb9,
    0x00, 0x00, 0x12, 0x10, 0x33, 0x32, 0x20, 0xba,
};

//*****************************************************************************
//
// This is the image of the blue push button background.
//
//*****************************************************************************
const uint8_t g_pui8Blue50x50[] =
{
    IMAGE_FMT_4BPP_COMP,
    50, 0,
    50, 0,

    15,
    0x00, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x63, 0x00, 0x00,
    0x6f, 0x00, 0x00,
    0x78, 0x00, 0x00,
    0x7c, 0x00, 0x00,
    0x7d, 0x00, 0x00,
    0x7f, 0x00, 0x00,
    0x81, 0x00, 0x00,
    0x85, 0x00, 0x00,
    0x89, 0x00, 0x00,
    0x8d, 0x00, 0x00,
    0x93, 0x00, 0x00,
    0x9b, 0x00, 0x00,
    0xa9, 0x00, 0x00,

    0x81, 0x03, 0x13, 0x9e, 0xfe, 0xff, 0xff, 0xff, 0xe9, 0x8a, 0xd1, 0xfe,
    0xd7, 0x31, 0x07, 0x2e, 0x51, 0xee, 0x35, 0xee, 0xee, 0xe9, 0xd4, 0xa2,
    0x35, 0x1e, 0x41, 0x41, 0xfe, 0x3f, 0xee, 0xee, 0xdd, 0xcc, 0x91, 0x33,
    0x40, 0x03, 0x41, 0xee, 0xee, 0xed, 0xdd, 0xdd, 0xdd, 0xc1, 0xe9, 0xd1,
    0xdc, 0xcd, 0xcc, 0xaa, 0x20, 0x32, 0x41, 0x3f, 0x41, 0xed, 0xdc, 0xcc,
    0xcc, 0xcc, 0xe9, 0x81, 0xd1, 0xbb, 0xbb, 0xcc, 0xcb, 0xba, 0x52, 0x39,
    0x40, 0x03, 0x42, 0xcc, 0xba, 0xaa, 0x99, 0x99, 0x99, 0xc0, 0xe9, 0xd1,
    0xaa, 0xaa, 0xab, 0xa9, 0x95, 0x20, 0x04, 0x00, 0x00, 0x1f, 0xff, 0xfe,
    0x41, 0x99, 0x98, 0x1c, 0x88, 0x88, 0x88, 0xe9, 0xd1, 0x29, 0x99, 0x98,
    0x00, 0x41, 0x00, 0x00, 0xef, 0xff, 0xee, 0xdc, 0xba, 0x60, 0x99, 0x4f,
    0x01, 0x89, 0x99, 0x99, 0x98, 0x53, 0x01, 0x00, 0x02, 0xff, 0xfe, 0xed,
    0xcb, 0xa9, 0x47, 0x80, 0x35, 0x98, 0x64, 0x10, 0x0d, 0xef, 0xee, 0xdc,
    0x30, 0xba, 0x98, 0x3f, 0x04, 0x99, 0x88, 0x54, 0x30, 0x06, 0x1e, 0xfe,
    0xed, 0xcb, 0xa9, 0x47, 0x06, 0x86, 0x01, 0x55, 0x41, 0x3e, 0xfe, 0xed,
    0xba, 0x98, 0x3f, 0x81, 0x3f, 0x65, 0x41, 0x5e, 0xee, 0xdc, 0xb9, 0x47,
    0x80, 0x07, 0x88, 0x65, 0x42, 0xbd, 0xee, 0xdb, 0xa9, 0xe1, 0x3f, 0x3f,
    0x39, 0xcc, 0xed, 0xcb, 0x98, 0x3f, 0x81, 0x3f, 0x88, 0x65, 0x43, 0xcc,
    0xdd, 0xca, 0x3f, 0xc3, 0x3f, 0x39, 0x42, 0xcb, 0xdc, 0xba, 0x3f, 0x3f,
    0xb0, 0x3c, 0xb9, 0x47, 0x07, 0x88, 0x88, 0x75, 0x32, 0x18, 0xcb, 0xdc,
    0xa9, 0x3f, 0x07, 0x88, 0x88, 0x65, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0xf8, 0x3f, 0x3f, 0x3f, 0x07, 0x01, 0x64, 0x32, 0xcb,
    0x73, 0xcc, 0x3f, 0x3f, 0x3b, 0x9b, 0xcb, 0x3f, 0x07, 0x00, 0x88, 0x88,
    0x87, 0x54, 0x32, 0x4a, 0xba, 0x99, 0x60, 0x98, 0x37, 0x07, 0x86, 0x54,
    0x32, 0x2a, 0xaa, 0x60, 0xa9, 0x47, 0x07, 0x88, 0x75, 0x43, 0x21, 0x19,
    0x30, 0x8a, 0x99, 0x3f, 0x07, 0x88, 0x65, 0x43, 0x21, 0x0c, 0x04, 0x49,
    0x98, 0x98, 0x37, 0x06, 0x86, 0x54, 0x06, 0x33, 0x20, 0x02, 0x46, 0x68,
    0x47, 0x07, 0x76, 0x01, 0x54, 0x32, 0x10, 0x00, 0x44, 0x66, 0x66, 0x2f,
    0x80, 0x05, 0x87, 0x65, 0x43, 0x32, 0x00, 0x00, 0x13, 0x18, 0x45, 0x55,
    0x66, 0x3f, 0x04, 0x66, 0x54, 0x33, 0x00, 0x21, 0x00, 0x00, 0x01, 0x34,
    0x45, 0x56, 0x66, 0x60, 0x78, 0x2f, 0x01, 0x76, 0x54, 0x43, 0x32, 0x10,
    0x01, 0x00, 0x00, 0x00, 0x12, 0x44, 0x45, 0x55, 0x37, 0x82, 0x01, 0x66,
    0x55, 0x44, 0x33, 0x21, 0x41, 0x00, 0x00, 0x01, 0x23, 0x44, 0x44, 0x55,
    0x56, 0x66, 0x66, 0x60, 0x66, 0xe9, 0xd1, 0x65, 0x54, 0x44, 0x33, 0x22,
    0x40, 0x10, 0x3a, 0x00, 0x12, 0x33, 0x34, 0x44, 0x44, 0x61, 0x44, 0xe9,
    0xd4, 0x43, 0x33, 0x22, 0x21, 0x43, 0x86, 0x31, 0x23, 0x33, 0x33, 0x33,
    0xe9, 0xd4, 0x32, 0x80, 0x47, 0x00, 0x00, 0x01, 0x12, 0x22, 0x22, 0x22,
    0xc8, 0xe9, 0xd3, 0x21, 0x10, 0x43,
};

//*****************************************************************************
//
// This is the image of the blue push button background, used when the buttons
// are pressed.
//
//*****************************************************************************
const uint8_t g_pui8Blue50x50Press[] =
{
    IMAGE_FMT_4BPP_COMP,
    50, 0,
    50, 0,

    15,
    0x00, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x63, 0x00, 0x00,
    0x6f, 0x00, 0x00,
    0x78, 0x00, 0x00,
    0x7c, 0x00, 0x00,
    0x7d, 0x00, 0x00,
    0x7f, 0x00, 0x00,
    0x81, 0x00, 0x00,
    0x85, 0x00, 0x00,
    0x89, 0x00, 0x00,
    0x8d, 0x00, 0x00,
    0x93, 0x00, 0x00,
    0x9b, 0x00, 0x00,
    0xa9, 0x00, 0x00,

    0x83, 0x03, 0x01, 0x12, 0x22, 0x22, 0x22, 0xe9, 0xd3, 0x20, 0x21, 0x10,
    0x07, 0x12, 0x22, 0x23, 0x33, 0x33, 0x64, 0x33, 0xe9, 0xd4, 0x32, 0x21,
    0x47, 0x33, 0x34, 0x19, 0x44, 0x44, 0x44, 0xe9, 0xd4, 0x43, 0x33, 0x34,
    0x00, 0x01, 0x22, 0x33, 0x44, 0x45, 0x56, 0x66, 0x66, 0x60, 0x66, 0xe9,
    0xd1, 0x65, 0x55, 0x44, 0x44, 0x32, 0x40, 0x10, 0x32, 0x12, 0x33, 0x44,
    0x55, 0x66, 0x88, 0x30, 0x88, 0x88, 0xe9, 0xd2, 0x87, 0x66, 0x55, 0x54,
    0x20, 0x44, 0x21, 0x39, 0x01, 0x23, 0x34, 0x45, 0x67, 0xc0, 0x47, 0x33,
    0x65, 0x54, 0x43, 0x10, 0x00, 0x00, 0x0c, 0x12, 0x33, 0x45, 0x66, 0x47,
    0x04, 0x66, 0x55, 0x00, 0x54, 0x31, 0x00, 0x00, 0x23, 0x34, 0x56, 0x78,
    0xc0, 0x3f, 0x04, 0x86, 0x66, 0x66, 0x44, 0x00, 0x01, 0x18, 0x23, 0x45,
    0x67, 0x47, 0x2f, 0x86, 0x64, 0x20, 0x0c, 0x02, 0x33, 0x45, 0x68, 0x3f,
    0x06, 0x89, 0x89, 0x06, 0x94, 0x40, 0x12, 0x34, 0x56, 0x47, 0x07, 0x88,
    0x03, 0x99, 0xa8, 0x91, 0x12, 0x34, 0x57, 0x3f, 0x07, 0x01, 0x88, 0x9a,
    0xaa, 0xa2, 0x23, 0x45, 0x68, 0x3f, 0x80, 0x07, 0x89, 0x99, 0xab, 0xa4,
    0x23, 0x45, 0x78, 0xc0, 0x3f, 0x07, 0x88, 0x9a, 0xbc, 0xb9, 0x23, 0x46,
    0xe7, 0x47, 0x3f, 0x39, 0xcc, 0xbc, 0x3f, 0x3f, 0x3b, 0x0f, 0xcd, 0xbc,
    0x23, 0x56, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0xb0, 0x39, 0x57, 0x3f, 0x07, 0x88, 0x88, 0x9b, 0xcd,
    0x18, 0xbc, 0x24, 0x56, 0x3f, 0x07, 0x88, 0x89, 0xab, 0xe1, 0x3f, 0x3f,
    0x3c, 0xac, 0xdd, 0xcc, 0x34, 0x3f, 0xc3, 0x3f, 0x39, 0xbc, 0xde, 0xcc,
    0x24, 0x3f, 0x07, 0x03, 0x88, 0x88, 0x9a, 0xbd, 0xee, 0xdb, 0x3f, 0x07,
    0x80, 0x01, 0x9b, 0xcd, 0xee, 0xe5, 0x14, 0x56, 0x68, 0xc0, 0x37, 0x06,
    0x89, 0xab, 0xde, 0xef, 0xe3, 0x14, 0x60, 0x55, 0x3f, 0x07, 0x9a, 0xbc,
    0xde, 0xef, 0xe1, 0x0c, 0x03, 0x45, 0x88, 0x99, 0x37, 0x04, 0x89, 0xab,
    0x00, 0xcd, 0xee, 0xfe, 0xd0, 0x01, 0x46, 0x89, 0x99, 0x60, 0x98, 0x37,
    0x03, 0x9a, 0xbc, 0xde, 0xef, 0xff, 0x06, 0x20, 0x00, 0x35, 0x89, 0x99,
    0x37, 0x03, 0x99, 0x00, 0xab, 0xcd, 0xee, 0xff, 0xfe, 0x00, 0x00, 0x14,
    0x04, 0x89, 0x99, 0xaa, 0x99, 0x99, 0x37, 0x89, 0x99, 0x00, 0xab, 0xcc,
    0xde, 0xef, 0xff, 0xf1, 0x00, 0x00, 0x05, 0x02, 0x59, 0x9a, 0xba, 0xaa,
    0x29, 0x99, 0xe9, 0xa0, 0xd1, 0xaa, 0x41, 0xee, 0xff, 0xff, 0x30, 0x00,
    0x00, 0x00, 0x00, 0x25, 0xab, 0xbc, 0xcc, 0xbb, 0xbb, 0x1a, 0xcc, 0xcc,
    0xcc, 0xe9, 0xd1, 0xcd, 0x42, 0xf3, 0x80, 0x41, 0x00, 0x02, 0xaa, 0xcc,
    0xdc, 0xcd, 0xdd, 0x32, 0xdd, 0xdd, 0xe9, 0xd1, 0xde, 0xee, 0x41, 0xff,
    0x40, 0x30, 0x3a, 0x00, 0x19, 0xcc, 0xdd, 0xee, 0xee, 0x6a, 0xee, 0xe9,
    0xd3, 0xef, 0x41, 0xe1, 0x43, 0x00, 0x3a, 0x00, 0x2a, 0x47, 0x01, 0x41,
    0xe2, 0x45, 0x00, 0x0e, 0x00, 0x13, 0x7d, 0xef, 0x81, 0x69, 0x51, 0xef,
    0x20, 0xe9, 0x31, 0x43,
};

//*****************************************************************************
//
// Vertical "Temperature" image used in the slider widget example.
//
//*****************************************************************************
const uint8_t g_pui8GettingHotter28x148[] =
{
    IMAGE_FMT_8BPP_COMP,
    28, 0,
    148, 0,

    63,
    0x00, 0x10, 0x42,
    0x00, 0x29, 0x46,
    0x00, 0x13, 0x72,
    0x00, 0x3c, 0x3c,
    0x00, 0x38, 0x6c,
    0x00, 0x0d, 0xc7,
    0x00, 0x22, 0x9e,
    0x00, 0x06, 0xe5,
    0x00, 0x03, 0xfe,
    0x00, 0x10, 0xf0,
    0x00, 0x45, 0x8a,
    0x00, 0x0b, 0xfe,
    0x00, 0x57, 0x69,
    0x00, 0x1e, 0xe2,
    0x00, 0x2e, 0xc7,
    0x00, 0x13, 0xfd,
    0x00, 0x1c, 0xf6,
    0x00, 0x1d, 0xfc,
    0x00, 0x34, 0xd7,
    0x00, 0x2c, 0xed,
    0x00, 0x44, 0xc3,
    0x00, 0x29, 0xfb,
    0x00, 0x65, 0x8d,
    0x00, 0x3f, 0xe3,
    0x00, 0x58, 0xb4,
    0x00, 0x37, 0xf9,
    0x00, 0x80, 0x7e,
    0x00, 0x46, 0xf8,
    0x00, 0x56, 0xe0,
    0x00, 0x6b, 0xc3,
    0x00, 0x54, 0xf6,
    0x00, 0x7d, 0xb6,
    0x00, 0x68, 0xe1,
    0x00, 0x61, 0xf5,
    0x00, 0x77, 0xd8,
    0x00, 0x6b, 0xf4,
    0x00, 0x9a, 0x9d,
    0x00, 0x74, 0xf3,
    0x00, 0xa7, 0x97,
    0x00, 0x94, 0xbd,
    0x00, 0x7b, 0xf2,
    0x00, 0x88, 0xdf,
    0x00, 0x90, 0xd6,
    0x00, 0x83, 0xf1,
    0x00, 0x8b, 0xf0,
    0x00, 0xab, 0xb9,
    0x00, 0x91, 0xf0,
    0x00, 0x9a, 0xee,
    0x00, 0xa8, 0xdc,
    0x00, 0xa5, 0xed,
    0x00, 0xc4, 0xc6,
    0x00, 0xb2, 0xec,
    0x00, 0xbc, 0xeb,
    0x00, 0xc3, 0xea,
    0x00, 0xd2, 0xda,
    0x00, 0xcc, 0xe9,
    0x00, 0xd4, 0xe9,
    0x00, 0xe1, 0xd8,
    0x00, 0xdb, 0xe8,
    0x00, 0xe0, 0xe7,
    0x00, 0xe6, 0xe7,
    0x00, 0xec, 0xe6,
    0x00, 0xf3, 0xe5,
    0x00, 0xfa, 0xe4,

    0x1f, 0x08, 0x08, 0x08, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xfc, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x08, 0x19, 0x03, 0x28, 0x34, 0x34, 0x19, 0x15,
    0x15, 0x07, 0x07, 0x00, 0x08, 0x0f, 0x34, 0x3f, 0x3f, 0x3f, 0x3f, 0x0a,
    0x1c, 0x20, 0x3d, 0x20, 0x1f, 0x07, 0x2b, 0x3f, 0x04, 0x0d, 0x22, 0x3f,
    0x3f, 0x18, 0x1f, 0x05, 0x1e, 0x2b, 0x01, 0x3f, 0x04, 0x2a, 0x3f, 0x3f,
    0x39, 0x05, 0x1f, 0xa8, 0x04, 0x2c, 0x61, 0x16, 0x21, 0x29, 0x3f, 0x3f,
    0x30, 0x3f, 0x02, 0x27, 0x04, 0x34, 0x3f, 0x3f, 0x16, 0x4a, 0x00, 0x21,
    0x05, 0x36, 0xd9, 0x07, 0x1d, 0x0b, 0x29, 0x0b, 0x0b, 0xe9, 0x0b, 0x21,
    0x04, 0x05, 0x22, 0xe1, 0xbb, 0x5d, 0x25, 0x31, 0x3f, 0x3f, 0x2d, 0x22,
    0x30, 0x12, 0x3f, 0x27, 0x07, 0x28, 0x3e, 0x3e, 0x3e, 0x09, 0x36, 0x3e,
    0x3e, 0x32, 0xc9, 0x3e, 0x00, 0x27, 0x98, 0x04, 0x11, 0x3c, 0x52, 0x32,
    0x3e, 0x24, 0x00, 0xd1, 0x2f, 0x05, 0x1e, 0x26, 0x32, 0x00, 0x02, 0x27,
    0x90, 0x06, 0x0e, 0x2d, 0x12, 0x39, 0x16, 0x00, 0x02, 0x44, 0x09, 0x26,
    0x0f, 0x0f, 0x0f, 0xe9, 0x0f, 0x15, 0x00, 0x1b, 0x0f, 0x05, 0x02, 0x04,
    0x04, 0x04, 0x00, 0x18, 0x00, 0x05, 0x09, 0x6d, 0x35, 0x0f, 0x0f, 0x2f,
    0x00, 0x3d, 0x36, 0x28, 0x0f, 0x09, 0x05, 0x05, 0x05, 0xc0, 0x3f, 0x07,
    0x0f, 0x33, 0x3d, 0x3d, 0x32, 0x06, 0xe0, 0x47, 0x07, 0x03, 0x28, 0x3d,
    0x3d, 0x36, 0x02, 0xe8, 0x27, 0x07, 0x04, 0x1d, 0x19, 0x28, 0x1e, 0x1e,
    0x70, 0x1e, 0xe9, 0x07, 0x05, 0x28, 0x3d, 0x3d, 0x3d, 0xd1, 0xe9, 0xd3,
    0x05, 0x1e, 0x11, 0x11, 0x11, 0xe9, 0x06, 0x11, 0x28, 0x3c, 0x3c, 0x3c,
    0xe9, 0xd3, 0x00, 0xf8, 0x65, 0x2d, 0x27, 0x27, 0x07, 0x11, 0x11, 0x23,
    0x0f, 0x30, 0x2d, 0x2d, 0x2d, 0xe9, 0xd2, 0x27, 0x06, 0x0f, 0x05, 0x02,
    0x02, 0x02, 0xe9, 0xd3, 0x27, 0x07, 0xe1, 0x77, 0x2f, 0x05, 0x19, 0x1e,
    0x1e, 0x1e, 0xe9, 0xe1, 0xd3, 0x07, 0x05, 0x28, 0x3b, 0x3b, 0x3b, 0xe9,
    0xa2, 0xd3, 0x05, 0x1e, 0x15, 0x15, 0x15, 0xe9, 0x15, 0x0d, 0x28, 0x3a,
    0x3a, 0x3a, 0xe9, 0xd3, 0x00, 0x65, 0xf0, 0x2d, 0x27, 0x27, 0x07, 0x15,
    0x15, 0x23, 0x30, 0x00, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x36, 0x3a, 0x3a,
    0x30, 0x27, 0x16, 0x27, 0x06, 0x06, 0x02, 0x02, 0x02, 0x83, 0xe9, 0x1f,
    0x3a, 0x3a, 0x0a, 0x06, 0x27, 0x07, 0x83, 0x73, 0x1e, 0x38, 0x38, 0x32,
    0x0e, 0x27, 0x04, 0x08, 0x1b, 0x1e, 0x1e, 0x1e, 0xe9, 0x21, 0x33, 0x38,
    0x1b, 0x38, 0x38, 0x0a, 0x27, 0x04, 0x28, 0x61, 0x49, 0x9d, 0xd3, 0x04,
    0x0e, 0x27, 0x27, 0x0e, 0x00, 0x26, 0x10, 0x19, 0x19, 0x19, 0xe9, 0x19,
    0x28, 0x37, 0x37, 0x63, 0x37, 0xe9, 0xd2, 0x16, 0x00, 0x13, 0x5d, 0x25,
    0x04, 0x25, 0x30, 0x27, 0x27, 0x27, 0xe9, 0x27, 0x16, 0x18, 0x04, 0x00,
    0x06, 0x2f, 0x05, 0x06, 0x02, 0x02, 0x43, 0x02, 0xe9, 0x02, 0x02, 0x06,
    0x0e, 0x2f, 0x05, 0x0e, 0x1b, 0x21, 0x21, 0x1e, 0xb6, 0x27, 0x05, 0x28,
    0x08, 0x35, 0x35, 0x2f, 0x12, 0x1a, 0x33, 0x35, 0x35, 0x64, 0x0e, 0x27,
    0x27, 0x27, 0x02, 0x22, 0x31, 0x35, 0x37, 0x35, 0x04, 0x47, 0x43, 0x35,
    0xe9, 0xd4, 0xa1, 0x23, 0x04, 0x0e, 0x1f, 0x19, 0x1b, 0x30, 0x27, 0x27,
    0x80, 0x3c, 0x1b, 0x1b, 0x1b, 0x25, 0x34, 0x34, 0x34, 0xc3, 0xe9, 0xd4,
    0x34, 0x30, 0x00, 0x12, 0x5a, 0x3a, 0xa0, 0x1a, 0x30, 0x1f, 0x34, 0x33,
    0x1f, 0x01, 0x00, 0xc0, 0x2f, 0x03, 0x02, 0x16, 0x34, 0x34, 0x27, 0x00,
    0x23, 0x00, 0x00, 0xe9, 0x00, 0x02, 0x17, 0x27, 0x04, 0x07, 0x21, 0x1d,
    0x16, 0x0a, 0x02, 0x67, 0x1f, 0x04, 0x01, 0x14, 0x06, 0x14, 0x18, 0x23,
    0x23, 0x23, 0xe9, 0x60, 0x2b, 0x07, 0x06, 0x21, 0x31, 0x33, 0x33, 0x33,
    0xda, 0xe9, 0xd1, 0x06, 0x1f, 0x04, 0x1e, 0x37, 0x33, 0x24, 0x33, 0x00,
    0x5f, 0x1e, 0x1e, 0xe9, 0x1e, 0x28, 0xf0, 0x27, 0x21, 0x65, 0x2d, 0x1e,
    0x2e, 0x33, 0x33, 0x00, 0x30, 0x2a, 0x33, 0x30, 0x1f, 0x30, 0x33, 0x30,
    0x60, 0x0a, 0x27, 0x27, 0x33, 0x0a, 0x04, 0x33, 0x33, 0x03, 0x00, 0x04,
    0x1f, 0x33, 0x16, 0x14, 0x27, 0x25, 0x00, 0x31, 0x31, 0x04, 0x14, 0x2f,
    0x31, 0x0a, 0x1e, 0x0c, 0x23, 0x31, 0x30, 0x0a, 0x27, 0x27, 0x1f, 0x14,
    0x43, 0x2b, 0xe1, 0x25, 0x31, 0x31, 0x04, 0x27, 0x04, 0x00, 0x2b, 0x31,
    0x31, 0x31, 0x18, 0x28, 0x31, 0x31, 0x4d, 0x2a, 0xc1, 0x04, 0x14, 0x1f,
    0x03, 0x25, 0x62, 0x71, 0x18, 0x39, 0x27, 0x01, 0x21, 0x21, 0x21, 0xe9,
    0x14, 0x21, 0x21, 0x29, 0x62, 0x2f, 0x1a, 0x2a, 0x00, 0x68, 0x14, 0x5e,
    0x1e, 0x18, 0x61, 0x23, 0x2a, 0x2f, 0x0c, 0x2f, 0x2a, 0x04, 0x01, 0x2f,
    0x06, 0x1c, 0x0a, 0x81, 0x61, 0x1c, 0x0a, 0x04, 0x00, 0x01, 0x1c, 0x27,
    0x93, 0x04, 0x23, 0x25, 0x7d, 0x14, 0x14, 0x37, 0x06, 0x0c, 0x2b, 0x2f,
    0x2e, 0x28, 0x5f, 0x16, 0x23, 0x23, 0x40, 0x23, 0xe9, 0x23, 0x2c, 0x2f,
    0x2f, 0x22, 0x0a, 0xe0, 0xa5, 0x6d, 0x97, 0x28, 0x2e, 0x2e, 0x29, 0x04,
    0xe8, 0x27, 0x07, 0x04, 0x1d, 0x19, 0x28, 0x25, 0x25, 0x70, 0x25, 0xe9,
    0x07, 0x05, 0x28, 0x2e, 0x2e, 0x2e, 0xd8, 0xe9, 0xd3, 0x18, 0x27, 0x25,
    0x2c, 0x2c, 0x2c, 0xd1, 0xe9, 0xd3, 0x00, 0x26, 0x25, 0x25, 0x25, 0xe9,
    0x78, 0x25, 0x27, 0x22, 0x65, 0x2d, 0x25, 0x28, 0x22, 0x1e, 0x1d, 0x1d,
    0x1d, 0xe9, 0xd2, 0x27, 0x06, 0x18, 0x1c, 0x04, 0x04, 0x04, 0xe9, 0xd3,
    0x26, 0x28, 0x28, 0x67, 0x28, 0xe9, 0xd4, 0x2b, 0x2b, 0x97, 0x4f, 0x3d,
    0x01, 0x2b, 0x2b, 0x2b, 0x0a, 0x22, 0x2b, 0x22, 0x2f, 0xc0, 0x2f, 0x2b,
    0x2b, 0x04, 0x22, 0x2b, 0x2b, 0x1d, 0xe0, 0x1f, 0x07, 0x73, 0x04, 0x22,
    0x28, 0x28, 0x22, 0x45, 0x18, 0x1e, 0x2b, 0x2b, 0x2b, 0xe9, 0x2b, 0x01,
    0x27, 0x25, 0x0a, 0x24, 0x28, 0x04, 0x65, 0x2d, 0x22, 0x25, 0x0a, 0x01,
    0x21, 0x1d, 0x25, 0x21, 0x22, 0x27, 0x85, 0x24, 0x25, 0x25, 0x04, 0x18,
    0xe1, 0x1d, 0xba, 0x65, 0x1d, 0x27, 0x26, 0x18, 0x1d, 0x22, 0x25, 0x27,
    0x04, 0x2b, 0x2b, 0x2c, 0x2c, 0x2c, 0xe9, 0x2c, 0x2b, 0x88, 0x61, 0x20,
    0x25, 0x25, 0x2a, 0x25, 0x01, 0x1d, 0xcc, 0x5d, 0x25, 0x2c, 0x23, 0x52,
    0x32, 0x25, 0x18, 0x61, 0x01, 0x2f, 0x05, 0x2b, 0x23, 0x23, 0x23, 0xe9,
    0x04, 0x23, 0x23, 0x1d, 0x01, 0x0a, 0x26, 0x2e, 0x2e, 0x64, 0x2e, 0xe9,
    0xd1, 0x1d, 0x18, 0x12, 0x20, 0x0a, 0x18, 0x01, 0x04, 0x29, 0x67, 0x1f,
    0x22, 0x0a, 0x04, 0x07, 0x04, 0x04, 0x01, 0x01, 0x16, 0x2f, 0x07, 0x02,
    0x0c, 0x29, 0x1f, 0x1f, 0x22, 0x3f, 0x01, 0x2f, 0x2f, 0x60, 0x2f, 0xe9,
    0xd2, 0x2b, 0x28, 0x25, 0x25, 0x25, 0x30, 0x2b, 0x2c, 0x7f, 0x37, 0x2f,
    0x2c, 0x23, 0x21, 0x23, 0x21, 0x21, 0xe9, 0x21, 0x20, 0x2e, 0x17, 0x05,
    0x6d, 0x2e, 0x35, 0x01, 0x18, 0x1f, 0x05, 0x28, 0x27, 0x18, 0x21, 0x21,
    0x16, 0x27, 0x04, 0x23, 0x21, 0x21, 0x02, 0x1c, 0x0a, 0x04, 0x04, 0x04,
    0x14, 0x01, 0x04, 0x88, 0x26, 0x31, 0x31, 0x31, 0xe9, 0x31, 0x25, 0x1e,
    0x00, 0x1e, 0x0a, 0x01, 0x16, 0x1f, 0x1f, 0x1f, 0x1c, 0x0d, 0x1e, 0x1e,
    0x04, 0x1f, 0x5d, 0x25, 0x2c, 0x21, 0x83, 0x6b, 0x21, 0x1e, 0x1c, 0x01,
    0x2a, 0x27, 0x04, 0x00, 0x20, 0x1e, 0x1c, 0x1d, 0x2e, 0x2e, 0x2c, 0x23,
    0x01, 0x1e, 0x1e, 0x0a, 0x0a, 0x2e, 0x2e, 0x2e, 0x17, 0x87, 0x01, 0x2b,
    0x1e, 0x1e, 0x1e, 0xe9, 0xd4, 0xa1, 0x39, 0x22, 0x2f, 0x27, 0x27, 0x06,
    0x04, 0x1f, 0x27, 0xd1, 0x27, 0x27, 0x27, 0x21, 0x33, 0x33, 0x33, 0xe9,
    0x03, 0x33, 0x2b, 0x1c, 0x14, 0x14, 0x14, 0xe9, 0xd4, 0x0c, 0x14, 0x14,
    0x04, 0x27, 0x3d, 0x02, 0x1f, 0x0c, 0x3e, 0x0c, 0x0c, 0xe9, 0xd4, 0xa1,
    0x27, 0x03, 0x2f, 0x3c, 0x2f, 0x2f, 0xe9, 0xd1, 0x57, 0x0e, 0x2c, 0x1e,
    0x1b, 0x1b, 0x1b, 0x1b, 0xe9, 0xd1, 0x27, 0x1f, 0x04, 0x44, 0x2f, 0x37,
    0x1b, 0x1b, 0x01, 0x26, 0x34, 0x34, 0x4f, 0x34, 0xe9, 0x34, 0x23, 0x27,
    0x21, 0x65, 0x2d, 0x21, 0x34, 0x21, 0x21, 0x17, 0x14, 0x14, 0x14, 0xe9,
    0x68, 0x14, 0x27, 0x05, 0x25, 0x29, 0x01, 0x03, 0x0c, 0x2c, 0x0c, 0x0c,
    0xe9, 0x0c, 0x27, 0x04, 0x2f, 0x19, 0x0e, 0x19, 0x12, 0x03, 0x33, 0x5f,
    0x17, 0x03, 0x22, 0x02, 0x19, 0x19, 0x14, 0x2f, 0x2f, 0x2f, 0xe9, 0x2f,
    0x88, 0x07, 0x35, 0x35, 0x35, 0xe9, 0x35, 0x35, 0x2b, 0x1b, 0x19, 0x19,
    0x19, 0xe9, 0xd2, 0x27, 0x66, 0x25, 0x46, 0x2e, 0x2f, 0x19, 0x19, 0x03,
    0x27, 0x04, 0x21, 0xe8, 0x27, 0x27, 0x07, 0x1e, 0x21, 0x12, 0x0e, 0x0e,
    0x51, 0x0e, 0xe9, 0x0e, 0x27, 0x37, 0x37, 0x37, 0xe9, 0x20, 0x37, 0x23,
    0x29, 0x01, 0x03, 0x0c, 0x0c, 0x0c, 0xb0, 0xe9, 0x0c, 0x65, 0x2d, 0x37,
    0x31, 0x15, 0x15, 0x1c, 0x12, 0x03, 0x35, 0x5f, 0x17, 0x03, 0x22, 0x15,
    0x05, 0x15, 0x14, 0x31, 0x31, 0x31, 0xe9, 0x31, 0x07, 0x86, 0x05, 0x2b,
    0x15, 0x15, 0x15, 0xe9, 0xd3, 0x2d, 0x8b, 0x1e, 0x38, 0x38, 0x38, 0xe9,
    0x38, 0x27, 0x01, 0x7c, 0x03, 0x65, 0x2d, 0x27, 0x27, 0x07, 0x38, 0x38,
    0x07, 0x2c, 0x17, 0x0e, 0x0e, 0x0e, 0xe9, 0xd2, 0x27, 0x87, 0x06, 0x24,
    0x0c, 0x0c, 0x0c, 0xe9, 0xd3, 0x27, 0xe3, 0x07, 0x77, 0x2f, 0x3a, 0x3a,
    0x3a, 0xe9, 0xd2, 0x01, 0x33, 0x2b, 0x1e, 0x1e, 0x33, 0x35, 0x35, 0x7f,
    0x80, 0x37, 0x3a, 0x37, 0x1e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x0a, 0x22,
    0x15, 0x29, 0x1f, 0x07, 0x2b, 0x11, 0x04, 0x04, 0x20, 0x11, 0x11, 0x1d,
    0x1f, 0x3b, 0x3b, 0x48, 0x3b, 0xe9, 0x3b, 0x2f, 0x2b, 0x11, 0x04, 0x1c,
    0x0c, 0x11, 0x11, 0x0d, 0x2d, 0x65, 0x2d, 0x3b, 0x25, 0x09, 0x11, 0x11,
    0x10, 0x06, 0x21, 0x20, 0x11, 0xd9, 0xc1, 0x27, 0x04, 0x1e, 0x11, 0x11,
    0x06, 0x03, 0x21, 0x28, 0x2d, 0x13, 0x21, 0x32, 0x1d, 0x3c, 0x3c, 0x3c,
    0x81, 0xe9, 0x3c, 0x1e, 0x0f, 0x0f, 0x04, 0x24, 0xe1, 0x58, 0x2d, 0xba,
    0x2d, 0x5d, 0x25, 0x21, 0x0f, 0x0f, 0x26, 0x0e, 0x2d, 0x01, 0x27, 0x0f,
    0x27, 0x07, 0x2b, 0xb3, 0x61, 0x0d, 0xe9, 0x29, 0x0f, 0x03, 0x27, 0x04,
    0x31, 0x3a, 0x10, 0x52, 0x32, 0x0f, 0x06, 0x03, 0x2e, 0x11, 0x3d, 0x3d,
    0x3d, 0xe9, 0x3d, 0x3d, 0x2f, 0x26, 0x18, 0x0d, 0x03, 0x1a, 0x66, 0x26,
    0x3d, 0x27, 0x0e, 0x82, 0x12, 0x09, 0x06, 0x03, 0x0c, 0x39, 0x27, 0x3d,
    0x30, 0x3d, 0x1b, 0x59, 0x01, 0x32, 0x16, 0x04, 0x04, 0x0c, 0x04, 0x03,
    0x03, 0x24, 0x2f, 0x23, 0x0b, 0x0b, 0x21, 0x0b, 0x03, 0x7a, 0x39, 0x32,
    0x32, 0x32, 0x3f, 0xf1, 0x27, 0x24, 0x47, 0x05, 0x3e, 0x3e, 0x3e, 0x23,
    0xf8, 0xc1, 0xa9, 0xd4, 0xa7, 0x24, 0x06, 0x2b, 0x2b, 0x7f, 0x2b, 0xe9,
    0xd3, 0x27, 0x25, 0x09, 0xd4, 0xa1, 0x63, 0x24, 0x27, 0x21, 0x08, 0x08,
    0x08, 0xe9, 0xd4, 0xbf, 0xa1, 0x03, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
    0x84, 0x27, 0x3e, 0x3f, 0x3f, 0x3f, 0x22, 0x03, 0x03, 0x6f, 0x03, 0xe9,
    0xd4, 0x03, 0x61, 0x49, 0xd3, 0x23, 0xff, 0x87, 0x3f, 0x27, 0x27, 0x27,
    0x27, 0x27, 0x07, 0x87, 0x05, 0x2f, 0x14, 0x06, 0x06, 0x27, 0x07, 0x05,
    0x0f, 0x26, 0x26, 0x26, 0x26, 0x27, 0x07, 0x77, 0x2f, 0xf8, 0x07, 0x07,
    0x07, 0x07, 0x02,
};

//*****************************************************************************
//
// Background version of vertical "Temperature" image.
//
//*****************************************************************************
const uint8_t g_pui8GettingHotter28x148Mono[] =
{
    IMAGE_FMT_4BPP_COMP,
    28, 0,
    148, 0,

    15,
    0x00, 0x00, 0x00,
    0x0e, 0x0d, 0x00,
    0x1c, 0x1a, 0x01,
    0x2a, 0x28, 0x01,
    0x38, 0x35, 0x01,
    0x46, 0x42, 0x01,
    0x54, 0x4f, 0x02,
    0x62, 0x5c, 0x02,
    0x70, 0x6a, 0x02,
    0x7e, 0x77, 0x02,
    0x8c, 0x84, 0x03,
    0x9a, 0x91, 0x03,
    0xa8, 0x9e, 0x03,
    0xb6, 0xac, 0x03,
    0xc4, 0xb9, 0x04,
    0xd2, 0xc6, 0x04,

    0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00, 0x37, 0x10, 0xbb, 0x32,
    0x20, 0x07, 0x1b, 0xff, 0xff, 0x46, 0x40, 0xe6, 0x07, 0xbf, 0xff, 0xff,
    0x47, 0xff, 0x50, 0x80, 0x1d, 0x05, 0xff, 0xff, 0xff, 0x49, 0xff, 0xd0,
    0x80, 0x1d, 0x08, 0xff, 0xe6, 0xff, 0x48, 0xff, 0xf2, 0x80, 0x25, 0x0b,
    0xff, 0x60, 0xff, 0x40, 0xdf, 0xf4, 0x84, 0x97, 0x40, 0xff, 0x40, 0xbf,
    0x96, 0x0a, 0xff, 0x08, 0xa0, 0xff, 0x43, 0xff, 0x26, 0x07, 0xff, 0xfd,
    0x08, 0xff, 0xcf, 0xff, 0xf0, 0x25, 0x01, 0xef, 0xff, 0x09, 0xff, 0xff,
    0xff, 0x90, 0x25, 0x00, 0x5f, 0x91, 0x20, 0xfc, 0x10, 0x96, 0x03, 0xaf,
    0xff, 0xfe, 0x71, 0x82, 0x2e, 0x02, 0x40, 0x01, 0x44, 0x30, 0x36, 0x00,
    0x10, 0x09, 0xfd, 0x70, 0xa7, 0x00, 0x00, 0x0b, 0xff, 0x41, 0xc0, 0x97,
    0x00, 0x00, 0x07, 0xff, 0xd1, 0x27, 0x81, 0x01, 0x7f, 0xfd, 0x74, 0x44,
    0x44, 0x40, 0x27, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x97, 0x97, 0x27,
    0x80, 0x26, 0x06, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0xf8, 0x25, 0x5d,
    0x97, 0x4f, 0x01, 0x02, 0x44, 0x44, 0x08, 0x44, 0x44, 0x44, 0x40, 0x05,
    0x07, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x97, 0x97, 0x27, 0x26,
    0x01, 0x06, 0xbb, 0xbb, 0xbb, 0xef, 0xfa, 0x70, 0x25, 0x88, 0x02, 0x09,
    0xff, 0x40, 0x97, 0x00, 0x00, 0x04, 0x20, 0xff, 0xd0, 0x25, 0x02, 0x44,
    0x44, 0x44, 0x5c, 0x20, 0xff, 0xf4, 0x25, 0x07, 0xff, 0xff, 0xff, 0xff,
    0xda, 0x97, 0x94, 0xf1, 0x27, 0x1a, 0x60, 0x25, 0x06, 0x07, 0xbb, 0xbb,
    0xbb, 0xbb, 0x84, 0x2d, 0x65, 0x96, 0x14, 0x02, 0x44, 0x30, 0xd9, 0x40,
    0x1d, 0x07, 0xff, 0x06, 0xb0, 0x00, 0x00, 0xdf, 0xf0, 0x97, 0x91, 0xcf,
    0x4a, 0xf4, 0x35, 0xff, 0xff, 0xe9, 0xff, 0x94, 0x01, 0x52, 0xdf, 0x8c,
    0xf3, 0x23, 0x00, 0x6f, 0x1c, 0xd0, 0xa4, 0x94, 0x0c, 0x23, 0xea, 0x20,
    0x24, 0x00, 0x07, 0x31, 0xff, 0xb0, 0xb5, 0x0a, 0x04, 0x77, 0x60, 0x97,
    0x82, 0x02, 0x24, 0x44, 0x44, 0x44, 0x80, 0x06, 0x3d, 0x04, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x05, 0x02, 0xef, 0xd8, 0x97, 0x01, 0x07, 0x2a, 0x27,
    0x0a, 0xff, 0xed, 0x08, 0xfe, 0xbe, 0xfe, 0x50, 0x25, 0x0b, 0xff, 0x53,
    0x08, 0xff, 0x01, 0xbf, 0x70, 0x97, 0x40, 0xdf, 0x50, 0x20, 0x5f, 0xe0,
    0x27, 0xa1, 0x9f, 0xa0, 0x5f, 0xf3, 0x80, 0x25, 0x08, 0xff, 0xf7, 0x7f,
    0xfc, 0xef, 0xf4, 0x81, 0x25, 0x05, 0xff, 0xf4, 0x3f, 0xff, 0xff, 0x26,
    0x01, 0x00, 0xcf, 0xf4, 0x0d, 0xff, 0xff, 0xd0, 0x96, 0x03, 0x17, 0xd0,
    0x03, 0xdf, 0xfd, 0x30, 0x26, 0x01, 0x2c, 0x04, 0x40, 0x2e, 0x02, 0xb7,
    0x0a, 0x09, 0xfd, 0x41, 0x70, 0x8f, 0x00, 0x00, 0x0b, 0xff, 0xc0, 0x1f,
    0x06, 0x00, 0x00, 0x07, 0xff, 0xd1, 0x27, 0x01, 0x7f, 0x04, 0xfd, 0x74,
    0x44, 0x44, 0x40, 0x27, 0xff, 0xff, 0x1e, 0xff, 0xff, 0xf0, 0x97, 0x97,
    0x27, 0x26, 0x06, 0x03, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0x25, 0x5d,
    0x84, 0x97, 0x37, 0xbb, 0x32, 0x20, 0x2f, 0x1b, 0xff, 0x10, 0xff, 0x46,
    0xe6, 0x07, 0xbf, 0xff, 0xff, 0x47, 0x20, 0xff, 0x50, 0x1d, 0x05, 0xff,
    0xff, 0xff, 0x49, 0x20, 0xff, 0xd0, 0x1d, 0x08, 0xff, 0xe6, 0xff, 0x48,
    0x20, 0xff, 0xf2, 0x25, 0x0b, 0xff, 0x60, 0xff, 0x40, 0x21, 0xdf, 0xf4,
    0x97, 0x40, 0xff, 0x40, 0xbf, 0x96, 0x02, 0x0a, 0xff, 0xa0, 0xff, 0x43,
    0xff, 0x26, 0x07, 0x02, 0xff, 0xfd, 0xff, 0xcf, 0xff, 0xf0, 0x25, 0x01,
    0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0x90, 0x25, 0x00, 0x48, 0x5f, 0x91,
    0xfc, 0x10, 0x96, 0x03, 0xaf, 0xff, 0x20, 0xfe, 0x71, 0x2e, 0x00, 0x00,
    0x01, 0x44, 0x30, 0xe2, 0x9f, 0x57, 0x0d, 0x58, 0xbb, 0xb7, 0x1f, 0x00,
    0x02, 0x3d, 0xff, 0xff, 0xff, 0xfa, 0x10, 0x05, 0x02, 0x4a, 0xef, 0x91,
    0xff, 0x80, 0x1d, 0x09, 0x9a, 0xff, 0x40, 0xf1, 0x25, 0x0b, 0xff, 0xe8,
    0x44, 0x5a, 0xff, 0x40, 0xf4, 0x25, 0x0a, 0xff, 0x60, 0x00, 0x00, 0xcf,
    0x52, 0xf3, 0x25, 0x05, 0x92, 0xdf, 0xd0, 0x25, 0x00, 0x00, 0x9f, 0xe7,
    0x44, 0x5b, 0xff, 0x74, 0x44, 0x41, 0x84, 0x13, 0x07, 0xff, 0xff, 0xff,
    0xe9, 0xff, 0xf4, 0xf0, 0x97, 0x97, 0x27, 0x24, 0x06, 0xbb, 0xbb, 0xbb,
    0x9c, 0xe9, 0xbb, 0xb3, 0x23, 0x6b, 0xb7, 0x00, 0x00, 0x04, 0x34, 0x44,
    0x44, 0x44, 0x40, 0x36, 0x6e, 0xff, 0x0b, 0xff, 0xff, 0xff, 0xf0, 0x05,
    0x04, 0x9a, 0x97, 0x60, 0x0a, 0x97, 0x0a, 0x0b, 0xff, 0xfe, 0xbb, 0xbb,
    0x23, 0xbb, 0xb0, 0x25, 0x09, 0xff, 0xd1, 0x45, 0x0a, 0x18, 0x04, 0xff,
    0xc0, 0x97, 0x01, 0x6f, 0xfa, 0x44, 0x10, 0x44, 0x44, 0x40, 0x06, 0x7e,
    0xff, 0xff, 0xff, 0x2d, 0xff, 0xf0, 0x05, 0x05, 0x9a, 0x97, 0x0a, 0x97,
    0x80, 0x0a, 0x0b, 0xff, 0xfd, 0xbb, 0xbb, 0xbb, 0xb0, 0x8c, 0x25, 0x09,
    0xff, 0xd1, 0x45, 0x0a, 0x04, 0xff, 0x60, 0xc0, 0x97, 0x01, 0x6f, 0xfa,
    0x44, 0x44, 0x44, 0x40, 0x40, 0x05, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x78, 0xf0, 0x97, 0x97, 0x27, 0x26, 0x06, 0xbb, 0xbb, 0x0f, 0xbb, 0xbb,
    0xbb, 0xb0, 0x25, 0x5d, 0x97, 0x4f, 0x84, 0x03, 0x37, 0xbb, 0x32, 0x20,
    0x07, 0x1b, 0xff, 0x10, 0xff, 0x46, 0xe6, 0x07, 0xbf, 0xff, 0xff, 0x47,
    0x20, 0xff, 0x50, 0x1d, 0x05, 0xff, 0xff, 0xff, 0x49, 0x20, 0xff, 0xd0,
    0x1d, 0x08, 0xff, 0xe6, 0xff, 0x48, 0x20, 0xff, 0xf2, 0x25, 0x0b, 0xff,
    0x60, 0xff, 0x40, 0x21, 0xdf, 0xf4, 0x97, 0x40, 0xff, 0x40, 0xbf, 0x96,
    0x02, 0x0a, 0xff, 0xa0, 0xff, 0x43, 0xff, 0x26, 0x07, 0x02, 0xff, 0xfd,
    0xff, 0xcf, 0xff, 0xf0, 0x25, 0x01, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff,
    0x90, 0x25, 0x00, 0x48, 0x5f, 0x91, 0xfc, 0x10, 0x96, 0x03, 0xaf, 0xff,
    0x20, 0xfe, 0x71, 0x2c, 0x0b, 0xff, 0xf0, 0x00, 0x01, 0x3f, 0x44, 0x30,
    0x35, 0x92, 0xad, 0x97, 0x97, 0x27, 0x80, 0x24, 0xf7, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x70, 0x93, 0x25, 0xff, 0xff, 0xe9, 0xff, 0xf0, 0x97, 0x97,
    0xff, 0x27, 0x27, 0x27, 0x22, 0x54, 0x2b, 0x97, 0x97, 0xe3, 0x27, 0x27,
    0x05, 0x06, 0x77, 0x70, 0x27, 0x4f, 0xf0, 0x77, 0x2f, 0x07, 0x07,
};

//*****************************************************************************
//
// Green horizontal slider image.
//
//*****************************************************************************
const uint8_t g_pui8GreenSlider195x37[] =
{
    IMAGE_FMT_8BPP_COMP,
    195, 0,
    37, 0,

    63,
    0x04, 0x04, 0x04,
    0x16, 0x16, 0x16,
    0x01, 0x29, 0x01,
    0x20, 0x21, 0x20,
    0x01, 0x3a, 0x01,
    0x17, 0x35, 0x17,
    0x2d, 0x2e, 0x2d,
    0x01, 0x50, 0x01,
    0x23, 0x43, 0x23,
    0x3a, 0x3a, 0x3a,
    0x01, 0x67, 0x01,
    0x2e, 0x4c, 0x2e,
    0x1a, 0x63, 0x1a,
    0x4b, 0x4b, 0x4b,
    0x02, 0x7e, 0x02,
    0x2f, 0x65, 0x2f,
    0x19, 0x76, 0x19,
    0x46, 0x59, 0x46,
    0x02, 0x8b, 0x02,
    0x02, 0x97, 0x02,
    0x5a, 0x5a, 0x5a,
    0x17, 0x90, 0x17,
    0x50, 0x6c, 0x50,
    0x02, 0xa3, 0x02,
    0x05, 0xa4, 0x05,
    0x0a, 0xa6, 0x0a,
    0x68, 0x68, 0x68,
    0x0f, 0xa8, 0x0f,
    0x13, 0xa9, 0x13,
    0x1f, 0xad, 0x1f,
    0x38, 0x9c, 0x38,
    0x73, 0x73, 0x73,
    0x6b, 0x7c, 0x6b,
    0x2a, 0xb1, 0x2a,
    0x7c, 0x7e, 0x7c,
    0x33, 0xb5, 0x33,
    0x4d, 0xa5, 0x4d,
    0x6d, 0x93, 0x6d,
    0x56, 0xa4, 0x56,
    0x63, 0xa0, 0x63,
    0x42, 0xba, 0x42,
    0x89, 0x89, 0x89,
    0x56, 0xb7, 0x56,
    0x4e, 0xbf, 0x4e,
    0x91, 0x91, 0x91,
    0x8f, 0x95, 0x8f,
    0x59, 0xc3, 0x59,
    0x71, 0xb9, 0x71,
    0x9e, 0x9e, 0x9e,
    0x64, 0xc7, 0x64,
    0x87, 0xb4, 0x87,
    0x6c, 0xca, 0x6c,
    0xa8, 0xa8, 0xa8,
    0x75, 0xcd, 0x75,
    0x7b, 0xcf, 0x7b,
    0x82, 0xd2, 0x82,
    0x8d, 0xcf, 0x8d,
    0x8b, 0xd5, 0x8b,
    0x98, 0xce, 0x98,
    0x92, 0xd7, 0x92,
    0x95, 0xd8, 0x95,
    0x9c, 0xdb, 0x9c,
    0xa3, 0xdc, 0xa3,
    0xa9, 0xe0, 0xa9,

    0x80, 0x07, 0x06, 0x20, 0x32, 0x3a, 0x3d, 0x3d, 0x3c, 0x0f, 0x3c, 0x3b,
    0x3b, 0x3b, 0xe9, 0xd4, 0xa7, 0x5f, 0xff, 0x17, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xfc, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x39, 0x39,
    0x00, 0x39, 0x37, 0x2f, 0x27, 0x16, 0x0b, 0x03, 0x00, 0x38, 0x00, 0x00,
    0xe9, 0xd4, 0xa7, 0x0b, 0x32, 0x3e, 0x00, 0x3f, 0x3e, 0x3d, 0x3d, 0x3c,
    0x3b, 0x3b, 0x39, 0x3f, 0x39, 0x39, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07,
    0x07, 0x07, 0x37, 0x37, 0x37, 0x36, 0x00, 0x35, 0x33, 0x31, 0x24, 0x0f,
    0x05, 0x01, 0x00, 0x38, 0x00, 0x00, 0xe9, 0xd4, 0xa3, 0x25, 0x3e, 0x3f,
    0x00, 0x3f, 0x3e, 0x3d, 0x3c, 0x3b, 0x39, 0x39, 0x37, 0x3f, 0x37, 0x37,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x07, 0x37, 0x36, 0x36, 0x35,
    0x00, 0x35, 0x33, 0x31, 0x2e, 0x2b, 0x28, 0x1e, 0x0f, 0x06, 0x01, 0x01,
    0x00, 0x00, 0x00, 0xe9, 0xd4, 0x00, 0x00, 0x03, 0x32, 0x3f, 0x3f, 0x3f,
    0x3e, 0x3d, 0x3b, 0x00, 0x39, 0x37, 0x37, 0x36, 0x36, 0x35, 0x35, 0x35,
    0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x35, 0x33, 0x33,
    0x33, 0x31, 0x2e, 0x00, 0x2e, 0x2b, 0x28, 0x23, 0x21, 0x10, 0x05, 0x01,
    0x0c, 0x01, 0x00, 0x00, 0x00, 0xe9, 0xd2, 0x03, 0x32, 0x00, 0x3f, 0x3f,
    0x3e, 0x3d, 0x3c, 0x39, 0x37, 0x36, 0x03, 0x35, 0x33, 0x33, 0x31, 0x31,
    0x31, 0xe9, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x80, 0x02, 0x2e,
    0x2e, 0x2e, 0x2b, 0x28, 0x23, 0x21, 0x00, 0x1d, 0x1c, 0x10, 0x06, 0x03,
    0x01, 0x00, 0x00, 0x60, 0x00, 0xe9, 0xd1, 0x32, 0x3e, 0x3e, 0x3e, 0x3d,
    0x08, 0x3b, 0x37, 0x36, 0x33, 0x01, 0x2b, 0x2b, 0x2b, 0xff, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xe0, 0x07, 0x07, 0x05, 0x28, 0x28, 0x28, 0x23, 0x21,
    0x00, 0x1c, 0x19, 0x17, 0x10, 0x06, 0x03, 0x01, 0x00, 0x20, 0x00, 0x00,
    0xe9, 0x00, 0x25, 0x3d, 0x3d, 0x3d, 0x04, 0x3c, 0x39, 0x37, 0x33, 0x31,
    0x12, 0x23, 0x23, 0x7f, 0x23, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07,
    0x07, 0x07, 0x23, 0x21, 0x1d, 0x1b, 0x00, 0x17, 0x13, 0x13, 0x0f, 0x06,
    0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x38, 0x3c, 0x3b,
    0x02, 0x3b, 0x37, 0x36, 0x31, 0x2b, 0x28, 0x31, 0x1d, 0x1f, 0x1c, 0x1c,
    0x1c, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xfc, 0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x1d, 0x1d,
    0x40, 0x1d, 0xe9, 0x1c, 0x18, 0x17, 0x13, 0x12, 0x10, 0x00, 0x0b, 0x06,
    0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x39, 0x39, 0x39, 0x37,
    0x35, 0x31, 0x2b, 0x00, 0x23, 0x21, 0x1c, 0x1b, 0x19, 0x18, 0x18, 0x17,
    0x3f, 0x17, 0x17, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x07, 0x17,
    0x17, 0x18, 0x18, 0x00, 0x19, 0x19, 0x1b, 0x1c, 0x1c, 0x1c, 0x19, 0x17,
    0x00, 0x13, 0x12, 0x12, 0x0e, 0x0f, 0x09, 0x06, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x36, 0x37, 0x36, 0x36, 0x00, 0x33, 0x31, 0x2b, 0x23, 0x1d,
    0x1c, 0x19, 0x18, 0x0f, 0x18, 0x17, 0x17, 0x17, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x05, 0x18, 0x00, 0x18, 0x19, 0x19, 0x19, 0x17,
    0x13, 0x13, 0x12, 0x00, 0x0e, 0x0e, 0x10, 0x11, 0x09, 0x03, 0x01, 0x00,
    0x00, 0x00, 0x16, 0x35, 0x35, 0x35, 0x33, 0x31, 0x2b, 0x00, 0x23, 0x1d,
    0x1c, 0x19, 0x18, 0x17, 0x17, 0x17, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xe0, 0x07, 0x07, 0x07, 0x17, 0x17, 0x18, 0x18, 0x18, 0x00, 0x17, 0x13,
    0x12, 0x0e, 0x0e, 0x0a, 0x0a, 0x16, 0x00, 0x0d, 0x06, 0x01, 0x00, 0x00,
    0x26, 0x33, 0x31, 0x00, 0x31, 0x2e, 0x2b, 0x28, 0x21, 0x1c, 0x19, 0x18,
    0xff, 0x03, 0xdb, 0xb7, 0x6f, 0x27, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x07, 0x13,
    0x12, 0x0e, 0x0a, 0x00, 0x0a, 0x0a, 0x0f, 0x14, 0x09, 0x03, 0x01, 0x00,
    0x00, 0x2a, 0x2e, 0x2e, 0x2e, 0x2b, 0x28, 0x23, 0x1d, 0x3f, 0x1b, 0x18,
    0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x17, 0x13, 0x12,
    0x00, 0x0e, 0x0e, 0x0a, 0x0a, 0x07, 0x0c, 0x1a, 0x0d, 0x00, 0x06, 0x01,
    0x00, 0x2b, 0x2b, 0x2b, 0x2b, 0x28, 0x07, 0x23, 0x21, 0x1c, 0x19, 0x18,
    0x07, 0xbf, 0x77, 0xff, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x17, 0x13,
    0x12, 0x0e, 0x0a, 0x0a, 0x07, 0x07, 0x00, 0x07, 0x1f, 0x14, 0x09, 0x03,
    0x00, 0x28, 0x28, 0x01, 0x28, 0x28, 0x28, 0x23, 0x1d, 0x1c, 0x18, 0x07,
    0xff, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x17, 0x17, 0x13,
    0x12, 0x0e, 0x0a, 0x00, 0x0a, 0x07, 0x07, 0x04, 0x22, 0x14, 0x09, 0x03,
    0x00, 0x01, 0x23, 0x23, 0x23, 0x23, 0x23, 0x21, 0x1d, 0x3f, 0x1b, 0x18,
    0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x17, 0x17, 0x13,
    0x00, 0x12, 0x0e, 0x0a, 0x07, 0x07, 0x04, 0x04, 0x29, 0x00, 0x1a, 0x09,
    0x03, 0x01, 0x21, 0x21, 0x21, 0x21, 0x0f, 0x21, 0x1d, 0x1c, 0x19, 0x07,
    0xbf, 0x77, 0x2f, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x01, 0x00, 0x13, 0x0e,
    0x0a, 0x0a, 0x07, 0x04, 0x04, 0x05, 0x00, 0x29, 0x1a, 0x0d, 0x06, 0x01,
    0x1d, 0x1d, 0x1d, 0x07, 0x1d, 0x1d, 0x1c, 0x1c, 0x19, 0x07, 0xbf, 0x77,
    0xff, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x17, 0x17, 0x13, 0x12, 0x0e,
    0x0a, 0x07, 0x04, 0x00, 0x04, 0x02, 0x0b, 0x29, 0x1a, 0x0d, 0x06, 0x01,
    0x00, 0x15, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x19, 0x18, 0xff, 0x07, 0xbf,
    0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xe0, 0x07, 0x07, 0x07, 0x17, 0x13, 0x13, 0x0e, 0x0a,
    0x00, 0x07, 0x07, 0x04, 0x02, 0x02, 0x11, 0x29, 0x1a, 0x0f, 0x0d, 0x06,
    0x01, 0x10, 0x07, 0xbf, 0x77, 0x2f, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05,
    0x00, 0x13, 0x13, 0x12, 0x0e, 0x0a, 0x07, 0x04, 0x02, 0x00, 0x02, 0x02,
    0x20, 0x29, 0x1a, 0x0d, 0x06, 0x01, 0x09, 0x08, 0x13, 0x13, 0x13, 0xe9,
    0x13, 0x13, 0x05, 0xff, 0xcd, 0x97, 0x4f, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07,
    0x17, 0x17, 0x13, 0x13, 0x12, 0x0e, 0x00, 0x0a, 0x07, 0x04, 0x02, 0x02,
    0x02, 0x08, 0x2d, 0x00, 0x29, 0x1a, 0x09, 0x03, 0x01, 0x03, 0x10, 0x12,
    0x23, 0x12, 0x12, 0xe9, 0x13, 0x13, 0x13, 0x02, 0xe2, 0xff, 0xc6, 0x87,
    0x3f, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xc0, 0x07, 0x03, 0x13, 0x13, 0x12, 0x12, 0x0e, 0x0a,
    0x00, 0x07, 0x04, 0x02, 0x02, 0x02, 0x02, 0x16, 0x30, 0x00, 0x22, 0x14,
    0x09, 0x03, 0x01, 0x03, 0x0b, 0x0e, 0x20, 0x0e, 0x0e, 0xe9, 0x0e, 0x12,
    0x12, 0x12, 0x13, 0x3f, 0x13, 0x13, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07,
    0x07, 0x07, 0x05, 0x12, 0x12, 0x0e, 0x00, 0x0e, 0x0a, 0x0a, 0x07, 0x04,
    0x02, 0x02, 0x02, 0x00, 0x02, 0x08, 0x2d, 0x2c, 0x1f, 0x14, 0x09, 0x03,
    0x0a, 0x00, 0x01, 0x06, 0x0c, 0x61, 0x0a, 0xe9, 0x0e, 0x3f, 0x0e, 0x0e,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0e, 0x0a, 0x0a,
    0x00, 0x0a, 0x07, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x00, 0x02, 0x20,
    0x30, 0x29, 0x1a, 0x0d, 0x06, 0x01, 0x07, 0x00, 0x01, 0x06, 0x0d, 0x0c,
    0x49, 0x31, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x05,
    0x07, 0x07, 0x07, 0x04, 0x02, 0x02, 0x40, 0x02, 0xe9, 0x16, 0x34, 0x2c,
    0x22, 0x14, 0x09, 0x00, 0x03, 0x01, 0x00, 0x01, 0x03, 0x09, 0x11, 0x0c,
    0xff, 0x41, 0x29, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x03,
    0x04, 0x04, 0x04, 0x10, 0x02, 0x02, 0x02, 0xe9, 0x02, 0x16, 0x30, 0x30,
    0x00, 0x29, 0x1a, 0x0d, 0x06, 0x01, 0x00, 0x00, 0x00, 0x07, 0x01, 0x06,
    0x09, 0x11, 0x0c, 0x23, 0x09, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x83, 0x07, 0x04, 0x04, 0x02, 0x02, 0x02, 0xe9, 0xd1, 0x00, 0x16, 0x30,
    0x30, 0x29, 0x1f, 0x14, 0x09, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x06, 0x0d, 0x3f, 0x1a, 0x0f, 0x17, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfc, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x05, 0x08, 0x20, 0x00, 0x34, 0x30, 0x2c, 0x1f, 0x14,
    0x09, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x09,
    0x0f, 0x0d, 0x1a, 0x16, 0x08, 0x07, 0xbf, 0x77, 0x2f, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x08, 0x00, 0x16, 0x2d, 0x34, 0x30, 0x29, 0x1f, 0x14, 0x0d,
    0x02, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0xe9, 0x01, 0x00, 0x03, 0x09,
    0x0d, 0x1a, 0x22, 0x20, 0x11, 0x08, 0x7f, 0x05, 0x02, 0xe2, 0xc6, 0x87,
    0x3f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xf8, 0x07, 0x07, 0x07, 0x07, 0x01, 0x05, 0x0b, 0x16, 0x00, 0x22, 0x30,
    0x34, 0x30, 0x2c, 0x29, 0x1f, 0x14, 0x01, 0x0d, 0x06, 0x03, 0x01, 0x00,
    0x00, 0x00, 0xe9, 0x00, 0x00, 0x00, 0x01, 0x03, 0x09, 0x0d, 0x14, 0x1f,
    0x01, 0x22, 0x2c, 0x30, 0x30, 0x34, 0x34, 0x34, 0xe9, 0xff, 0xd4, 0xa7,
    0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x30, 0x30, 0x2c, 0x29, 0x22, 0x1a,
    0x00, 0x14, 0x09, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0xc0, 0xe9, 0xd2,
    0x01, 0x03, 0x06, 0x09, 0x0d, 0x1a, 0x01, 0x1f, 0x22, 0x29, 0x29, 0x2c,
    0x2c, 0x2c, 0xe9, 0xff, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x05,
    0x29, 0x29, 0x22, 0x1f, 0x1a, 0x14, 0x00, 0x0d, 0x09, 0x06, 0x03, 0x01,
    0x00, 0x00, 0x00, 0xc0, 0xe9, 0xd4, 0x01, 0x01, 0x06, 0x09, 0x0d, 0x0d,
    0x03, 0x14, 0x1a, 0x1a, 0x1f, 0x1f, 0x1f, 0xe9, 0xd4, 0xff, 0xa7, 0x5f,
    0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x80, 0x05, 0x1a, 0x1a, 0x14, 0x14, 0x0d, 0x09, 0x06,
    0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0xe9, 0xd4, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x03, 0x06, 0x06, 0x09, 0x0f, 0x09, 0x0d, 0x0d, 0x0d, 0xe9,
    0xd4, 0xa7, 0x5f, 0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x09, 0x00, 0x09, 0x09,
    0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0xe9, 0xd4, 0xa4, 0x01,
    0x01, 0x01, 0x03, 0x0f, 0x03, 0x06, 0x06, 0x06, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x01, 0x03, 0x03, 0x01, 0x01, 0x00,
    0x00, 0x00, 0xe9, 0xc1, 0xd4, 0xa7, 0x00, 0x00, 0x01, 0x01, 0x01, 0xe9,
    0xff, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe3, 0x07, 0x07, 0x02, 0x00, 0x00,
    0x00, 0xe9, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfc, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x06,
};

//*****************************************************************************
//
// Red horizontal slider image.
//
//*****************************************************************************
const uint8_t g_pui8RedSlider195x37[] =
{
    IMAGE_FMT_8BPP_COMP,
    195, 0,
    37, 0,

    63,
    0x04, 0x04, 0x04,
    0x00, 0x00, 0x40,
    0x16, 0x16, 0x16,
    0x00, 0x00, 0x5b,
    0x0c, 0x0c, 0x48,
    0x23, 0x23, 0x23,
    0x00, 0x00, 0x7c,
    0x20, 0x20, 0x35,
    0x15, 0x15, 0x52,
    0x00, 0x00, 0x93,
    0x2e, 0x2e, 0x2e,
    0x00, 0x00, 0xa1,
    0x00, 0x00, 0xb4,
    0x27, 0x27, 0x59,
    0x00, 0x00, 0xc7,
    0x14, 0x14, 0x9d,
    0x3d, 0x3d, 0x3e,
    0x25, 0x25, 0x79,
    0x00, 0x00, 0xd9,
    0x1f, 0x1f, 0xa3,
    0x00, 0x00, 0xec,
    0x13, 0x13, 0xc3,
    0x00, 0x00, 0xf3,
    0x00, 0x00, 0xfa,
    0x30, 0x30, 0x8a,
    0x4c, 0x4c, 0x4c,
    0x00, 0x00, 0xff,
    0x46, 0x46, 0x65,
    0x05, 0x05, 0xff,
    0x0b, 0x0b, 0xff,
    0x11, 0x11, 0xff,
    0x5a, 0x5a, 0x5a,
    0x50, 0x50, 0x7e,
    0x21, 0x21, 0xff,
    0x36, 0x36, 0xd5,
    0x68, 0x68, 0x68,
    0x32, 0x32, 0xff,
    0x73, 0x73, 0x73,
    0x6b, 0x6b, 0x88,
    0x51, 0x51, 0xd4,
    0x67, 0x67, 0xb6,
    0x4c, 0x4c, 0xff,
    0x55, 0x55, 0xef,
    0x85, 0x85, 0x85,
    0x5a, 0x5a, 0xff,
    0x8e, 0x8e, 0x96,
    0x91, 0x91, 0x91,
    0x63, 0x63, 0xff,
    0x70, 0x70, 0xe3,
    0x93, 0x93, 0x9e,
    0x6b, 0x6b, 0xff,
    0x9b, 0x9b, 0x9b,
    0x86, 0x86, 0xcd,
    0x74, 0x74, 0xff,
    0xa0, 0xa0, 0xa2,
    0x7a, 0x7a, 0xfe,
    0x81, 0x81, 0xff,
    0xa8, 0xa8, 0xa8,
    0x8c, 0x8c, 0xf6,
    0x8a, 0x8a, 0xff,
    0x97, 0x97, 0xee,
    0x91, 0x91, 0xff,
    0x9a, 0x9a, 0xff,
    0xa5, 0xa5, 0xfe,

    0x80, 0x07, 0x07, 0x26, 0x34, 0x3c, 0x3e, 0x3e, 0x3e, 0x1f, 0x3d, 0x3d,
    0x3d, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x3b, 0x3b, 0x3b,
    0x00, 0x38, 0x30, 0x28, 0x20, 0x0d, 0x02, 0x00, 0x00, 0x70, 0x00, 0xe9,
    0xd4, 0xa7, 0x10, 0x34, 0x3f, 0x3f, 0x00, 0x3f, 0x3e, 0x3e, 0x3d, 0x3d,
    0x3d, 0x3b, 0x3b, 0x7f, 0x3b, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe0, 0x07, 0x07,
    0x07, 0x38, 0x38, 0x38, 0x37, 0x35, 0x00, 0x32, 0x2f, 0x27, 0x18, 0x07,
    0x02, 0x00, 0x00, 0x70, 0x00, 0xe9, 0xd4, 0xa3, 0x28, 0x3f, 0x3f, 0x3f,
    0x00, 0x3f, 0x3e, 0x3e, 0x3d, 0x3b, 0x3b, 0x38, 0x38, 0x7f, 0x38, 0xe9,
    0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xe0, 0x07, 0x07, 0x07, 0x38, 0x37, 0x37, 0x35, 0x35,
    0x00, 0x32, 0x2f, 0x2c, 0x29, 0x29, 0x22, 0x11, 0x02, 0x0c, 0x02, 0x00,
    0x00, 0x00, 0xe9, 0xd4, 0x00, 0x07, 0x00, 0x34, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3e, 0x3d, 0x3b, 0x01, 0x38, 0x38, 0x37, 0x37, 0x35, 0x35, 0x35, 0xe9,
    0xff, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x80, 0x07, 0x35, 0x32, 0x32, 0x32,
    0x2f, 0x2c, 0x2c, 0x00, 0x29, 0x24, 0x24, 0x21, 0x13, 0x07, 0x02, 0x02,
    0x18, 0x00, 0x00, 0x00, 0xe9, 0xd2, 0x07, 0x34, 0x3f, 0x00, 0x3f, 0x3f,
    0x3e, 0x3e, 0x3b, 0x38, 0x37, 0x35, 0x07, 0x32, 0x32, 0x2f, 0x2f, 0x2f,
    0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x01, 0x00, 0x2c, 0x2c,
    0x2c, 0x2c, 0x29, 0x29, 0x24, 0x24, 0x00, 0x21, 0x1e, 0x13, 0x07, 0x02,
    0x02, 0x00, 0x00, 0x60, 0x00, 0xe9, 0xd1, 0x34, 0x3f, 0x3f, 0x3e, 0x3e,
    0x05, 0x3d, 0x38, 0x37, 0x32, 0x2f, 0x0a, 0x29, 0xe9, 0xff, 0xd4, 0xa7,
    0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x24, 0x24, 0x21, 0x1e, 0x1d, 0x1a,
    0x01, 0x13, 0x0a, 0x05, 0x02, 0x00, 0x00, 0x00, 0xe9, 0x00, 0x00, 0x28,
    0x3e, 0x3e, 0x3e, 0x3d, 0x3b, 0x38, 0x2f, 0x32, 0x2f, 0x1b, 0x24, 0xe9,
    0xd4, 0xa7, 0x5f, 0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x24, 0x00, 0x24, 0x21,
    0x21, 0x1e, 0x1a, 0x16, 0x14, 0x18, 0x00, 0x0a, 0x05, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0d, 0x3a, 0x3d, 0x3d, 0x3d, 0x38, 0x37, 0x2f,
    0x27, 0x29, 0x29, 0x32, 0x1e, 0x1e, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x05, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x1c, 0x16,
    0x00, 0x14, 0x12, 0x15, 0x1b, 0x0a, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x28, 0x3b, 0x3b, 0x3b, 0x38, 0x00, 0x35, 0x2f, 0x29, 0x24, 0x21,
    0x1e, 0x1e, 0x1d, 0x0f, 0x1c, 0x1a, 0x1a, 0x1a, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x02, 0x1c, 0x00, 0x1c, 0x1d, 0x1d, 0x1e, 0x1e,
    0x1e, 0x1c, 0x17, 0x00, 0x14, 0x12, 0x12, 0x0e, 0x18, 0x10, 0x0a, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x37, 0x38, 0x37, 0x37, 0x00, 0x32, 0x2f,
    0x29, 0x24, 0x21, 0x1e, 0x1d, 0x1c, 0x1f, 0x1a, 0x1a, 0x1a, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfc, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x1c, 0x1c, 0x00, 0x1c, 0x1d,
    0x1c, 0x1a, 0x16, 0x14, 0x12, 0x0e, 0x00, 0x0c, 0x0f, 0x1b, 0x10, 0x05,
    0x02, 0x00, 0x00, 0x00, 0x20, 0x35, 0x35, 0x35, 0x32, 0x2c, 0x29, 0x24,
    0x27, 0x21, 0x1e, 0x39, 0x1a, 0x1a, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x00, 0x1a, 0x1a, 0x1c, 0x1c, 0x1a, 0x17, 0x14, 0x12,
    0x00, 0x0e, 0x0c, 0x0c, 0x0b, 0x20, 0x19, 0x0a, 0x02, 0x00, 0x00, 0x00,
    0x27, 0x32, 0x2f, 0x2f, 0x2c, 0x29, 0x07, 0x24, 0x21, 0x1e, 0x1d, 0x1c,
    0x03, 0xdb, 0xb7, 0xff, 0x6f, 0x27, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x80, 0x06, 0x16,
    0x14, 0x12, 0x0e, 0x0c, 0x0b, 0x09, 0x00, 0x18, 0x1f, 0x10, 0x05, 0x02,
    0x00, 0x2a, 0x2c, 0x00, 0x2c, 0x2c, 0x29, 0x29, 0x24, 0x21, 0x1d, 0x1c,
    0xff, 0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe0, 0x07, 0x07, 0x07, 0x1a, 0x16,
    0x12, 0x0e, 0x0c, 0x00, 0x0b, 0x09, 0x09, 0x11, 0x23, 0x19, 0x0a, 0x02,
    0x00, 0x00, 0x29, 0x29, 0x29, 0x29, 0x29, 0x24, 0x21, 0x3f, 0x1e, 0x1c,
    0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1a, 0x1a, 0x16,
    0x00, 0x12, 0x0e, 0x0c, 0x0b, 0x09, 0x06, 0x06, 0x25, 0x00, 0x1f, 0x0a,
    0x02, 0x00, 0x29, 0x29, 0x29, 0x29, 0x07, 0x24, 0x24, 0x21, 0x1e, 0x1c,
    0x07, 0xbf, 0x77, 0xff, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x1a, 0x17,
    0x14, 0x12, 0x0e, 0x0b, 0x09, 0x06, 0x00, 0x06, 0x03, 0x2b, 0x1f, 0x10,
    0x05, 0x02, 0x24, 0x01, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x1d, 0x07,
    0xff, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x1a, 0x1a, 0x17,
    0x14, 0x0e, 0x0c, 0x00, 0x0b, 0x06, 0x06, 0x03, 0x03, 0x2b, 0x23, 0x10,
    0x00, 0x05, 0x02, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x1e, 0x1d,
    0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1a, 0x17, 0x16,
    0x00, 0x14, 0x0e, 0x0c, 0x09, 0x06, 0x03, 0x03, 0x08, 0x00, 0x2b, 0x23,
    0x19, 0x05, 0x02, 0x21, 0x21, 0x21, 0x07, 0x21, 0x21, 0x1e, 0x1e, 0x1c,
    0x07, 0xbf, 0x77, 0xff, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x1a, 0x17,
    0x14, 0x12, 0x0c, 0x0b, 0x06, 0x03, 0x00, 0x03, 0x01, 0x0d, 0x2e, 0x23,
    0x19, 0x0a, 0x02, 0x0b, 0x15, 0x1d, 0x1d, 0x1d, 0xe9, 0x1c, 0x07, 0xbf,
    0xff, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x80, 0x07, 0x17, 0x16, 0x14, 0x0e,
    0x0b, 0x09, 0x06, 0x00, 0x03, 0x01, 0x01, 0x1b, 0x2e, 0x23, 0x19, 0x0a,
    0x03, 0x02, 0x0f, 0x17, 0x17, 0x17, 0x17, 0x49, 0xda, 0xff, 0x02, 0xd4,
    0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x01, 0x17, 0x16, 0x14, 0x12,
    0x00, 0x0c, 0x09, 0x06, 0x03, 0x01, 0x01, 0x01, 0x26, 0x00, 0x2b, 0x23,
    0x19, 0x05, 0x02, 0x0d, 0x14, 0x14, 0x41, 0x14, 0xe9, 0x16, 0x16, 0x16,
    0x17, 0x17, 0x01, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe0, 0x07, 0x07,
    0x06, 0x17, 0x17, 0x16, 0x14, 0x12, 0x00, 0x0e, 0x0b, 0x06, 0x03, 0x01,
    0x01, 0x01, 0x0d, 0x00, 0x2d, 0x2b, 0x23, 0x10, 0x05, 0x02, 0x05, 0x15,
    0x10, 0x12, 0x12, 0x12, 0xe9, 0x14, 0x14, 0x16, 0x16, 0x07, 0x17, 0x17,
    0x1a, 0x1a, 0x1a, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02,
    0x00, 0x17, 0x17, 0x16, 0x14, 0x12, 0x12, 0x0c, 0x0b, 0x00, 0x06, 0x03,
    0x01, 0x01, 0x01, 0x01, 0x20, 0x33, 0x00, 0x2b, 0x1f, 0x10, 0x05, 0x02,
    0x05, 0x0d, 0x0e, 0x20, 0x0e, 0x0e, 0xe9, 0x0e, 0x12, 0x12, 0x12, 0x14,
    0x3f, 0x14, 0x14, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x05,
    0x12, 0x12, 0x0e, 0x00, 0x0e, 0x0c, 0x09, 0x06, 0x03, 0x01, 0x01, 0x01,
    0x00, 0x01, 0x0d, 0x2d, 0x2e, 0x25, 0x1f, 0x0a, 0x02, 0x01, 0x00, 0x02,
    0x0a, 0x13, 0x0c, 0x0c, 0x0c, 0xe9, 0x8f, 0xd1, 0x0e, 0x0e, 0x0e, 0xe9,
    0xd4, 0xa7, 0x5f, 0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x0c, 0x00, 0x0c, 0x0b,
    0x09, 0x06, 0x03, 0x03, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x26, 0x36,
    0x2b, 0x23, 0x19, 0x00, 0x0a, 0x02, 0x00, 0x02, 0x05, 0x10, 0x0f, 0x0b,
    0x00, 0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0b, 0x0b, 0x7f, 0x0b, 0xe9,
    0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x05, 0x09, 0x09, 0x06, 0x06,
    0x04, 0x06, 0x03, 0x01, 0x01, 0x01, 0xe9, 0x20, 0x39, 0x00, 0x2e, 0x25,
    0x1f, 0x10, 0x05, 0x02, 0x00, 0x02, 0x0f, 0x05, 0x0a, 0x1b, 0x0f, 0x3a,
    0x21, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x81, 0x02, 0x03,
    0x03, 0x03, 0x01, 0x01, 0x01, 0xe9, 0x00, 0x01, 0x1b, 0x36, 0x33, 0x2b,
    0x23, 0x19, 0x0a, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x05, 0x10, 0x1b,
    0x7f, 0x11, 0x23, 0x09, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x03, 0x03, 0x01, 0x30, 0x01, 0x01, 0xe9, 0xd1, 0x20, 0x36, 0x36, 0x2e,
    0x00, 0x25, 0x1f, 0x10, 0x05, 0x02, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02,
    0x0a, 0x19, 0x23, 0x11, 0x17, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xc0, 0x07, 0x05, 0x0d, 0x26, 0x39, 0x36, 0x2e, 0x25, 0x00, 0x1f, 0x10,
    0x0a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x0a, 0x19,
    0x23, 0x20, 0x0d, 0xff, 0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe0, 0x07, 0x07,
    0x07, 0x0d, 0x20, 0x31, 0x39, 0x33, 0x00, 0x2e, 0x25, 0x1f, 0x19, 0x0a,
    0x02, 0x02, 0x00, 0x20, 0x00, 0x00, 0xe9, 0x02, 0x05, 0x10, 0x19, 0x23,
    0x07, 0x25, 0x25, 0x1b, 0x0d, 0x04, 0x02, 0xe2, 0xc6, 0xff, 0x87, 0x3f,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x80, 0x01, 0x08, 0x0d, 0x20, 0x26, 0x36, 0x39, 0x36,
    0x00, 0x2e, 0x2b, 0x25, 0x1f, 0x19, 0x0a, 0x05, 0x02, 0x10, 0x00, 0x00,
    0x00, 0xe9, 0x00, 0x00, 0x02, 0x05, 0x00, 0x0a, 0x19, 0x1f, 0x25, 0x2b,
    0x2e, 0x33, 0x36, 0x0f, 0x36, 0x39, 0x39, 0x39, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x05, 0x36, 0x00, 0x36, 0x33, 0x2e, 0x2b, 0x25,
    0x23, 0x1f, 0x10, 0x03, 0x0a, 0x05, 0x02, 0x00, 0x00, 0x00, 0xe9, 0xd2,
    0x00, 0x02, 0x05, 0x0a, 0x10, 0x19, 0x23, 0x25, 0x25, 0x07, 0x2b, 0x2b,
    0x2e, 0x2e, 0x2e, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05,
    0x00, 0x2b, 0x2b, 0x2b, 0x25, 0x23, 0x1f, 0x19, 0x10, 0x03, 0x0a, 0x02,
    0x02, 0x00, 0x00, 0x00, 0xe9, 0xd4, 0x00, 0x02, 0x02, 0x05, 0x0a, 0x10,
    0x19, 0x1f, 0x23, 0x0f, 0x23, 0x25, 0x25, 0x25, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x05, 0x23, 0x00, 0x23, 0x1f, 0x1f, 0x19, 0x10,
    0x0a, 0x05, 0x02, 0x0c, 0x02, 0x00, 0x00, 0x00, 0xe9, 0xd4, 0x00, 0x00,
    0x00, 0x02, 0x02, 0x05, 0x05, 0x0a, 0x10, 0x10, 0x19, 0x3f, 0x19, 0x19,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x10, 0x10, 0x0a,
    0x01, 0x0a, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00, 0xe9, 0xc0, 0xd4, 0xa4,
    0x02, 0x02, 0x02, 0x05, 0x05, 0x0a, 0x3f, 0x0a, 0x0a, 0xe9, 0xd4, 0xa7,
    0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x02, 0x07, 0x02, 0x02,
    0x00, 0x00, 0x00, 0xe9, 0xd4, 0xa7, 0x3f, 0x00, 0x00, 0x31, 0x19, 0xd4,
    0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02, 0x00, 0x3f, 0x00, 0x00,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xc0, 0x07, 0x06,
};

const uint8_t g_dese_logo[] =
{
    IMAGE_FMT_4BPP_COMP,
    64, 1,
    66, 0,

    15,
    0x00, 0x00, 0x00,
    0x2d, 0x30, 0x2e,
    0x9b, 0x3e, 0x00,
    0xa2, 0x36, 0x0e,
    0x48, 0x4b, 0x49,
    0x9b, 0x53, 0x39,
    0x67, 0x69, 0x67,
    0x86, 0x89, 0x87,
    0xbc, 0x91, 0x85,
    0xa7, 0xaa, 0xa8,
    0xc9, 0xa9, 0xa7,
    0xca, 0xcb, 0xc9,
    0xe3, 0xe5, 0xe2,
    0xec, 0xfd, 0xfd,
    0xfc, 0xff, 0xfd,
    0xff, 0xff, 0xff,

    0x1f, 0xee, 0xee, 0xee, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0xee, 0xee, 0xec, 0xb9, 0x99, 0x9b,
    0x7f, 0xce, 0x07, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0xec, 0x99, 0x97,
    0xcc, 0xee, 0xdc, 0x19, 0xb7, 0x99, 0xce, 0x07, 0x07, 0xee, 0xef, 0x67,
    0xb7, 0x1d, 0xfe, 0x7f, 0x35, 0xef, 0xa7, 0xa7, 0x07, 0xff, 0x8f, 0x47,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x04, 0x08, 0xeb, 0x9b, 0xde, 0xe9, 0x01,
    0xcb, 0xed, 0xb9, 0x63, 0xbe, 0x07, 0x07, 0xcc, 0xcc, 0xcc, 0xe9, 0xd2,
    0x6b, 0xde, 0x7f, 0x67, 0xcc, 0x69, 0xed, 0x87, 0x84, 0x3f, 0xee, 0xec,
    0x7f, 0x7d, 0x5a, 0xc6, 0x87, 0x3f, 0xc6, 0x07, 0x07, 0xee, 0xec, 0xce,
    0x07, 0x01, 0xeb, 0x08, 0x99, 0xce, 0xee, 0xe9, 0x01, 0x9e, 0xee, 0xec,
    0x61, 0x79, 0x3f, 0x06, 0xc8, 0x22, 0x22, 0x22, 0xe9, 0x92, 0xd2, 0x58,
    0xbe, 0x1a, 0xea, 0x32, 0x77, 0x22, 0x2c, 0x22, 0x23, 0x69, 0xb5, 0x87,
    0x39, 0x5b, 0xee, 0x1b, 0xee, 0xee, 0x82, 0x7f, 0x31, 0x5c, 0x79, 0x61,
    0xfa, 0xd4, 0xa7, 0x5f, 0x17, 0x06, 0xcc, 0x02, 0xec, 0x60, 0xce, 0x07,
    0x01, 0xb9, 0xcc, 0x9b, 0xee, 0xec, 0x0e, 0xbe, 0xee, 0xed, 0x9e, 0xb3,
    0x37, 0x03, 0xec, 0x0c, 0x52, 0x22, 0x22, 0x22, 0xe9, 0xd3, 0x28, 0xce,
    0xb0, 0x11, 0xc2, 0x7f, 0x32, 0x5e, 0xee, 0xec, 0x32, 0xc3, 0x7f, 0x31,
    0x23, 0xce, 0xee, 0xeb, 0x07, 0x3a, 0x01, 0x28, 0xee, 0xee, 0xee, 0xc7,
    0x77, 0x9b, 0xd1, 0xec, 0xb9, 0xd4, 0xa2, 0xeb, 0x7f, 0x34, 0xec, 0xce,
    0xb0, 0x45, 0x7c, 0x97, 0x06, 0xe9, 0x9b, 0xb7, 0xc7, 0x00, 0x9b, 0xee,
    0x9e, 0xee, 0xeb, 0xce, 0xb9, 0x7c, 0x18, 0x7b, 0xb9, 0x9e, 0x37, 0x03,
    0xe8, 0x22, 0x22, 0x60, 0x22, 0xe9, 0xd4, 0x22, 0x5c, 0xee, 0xee, 0xef,
    0x63, 0xc2, 0x77, 0x2a, 0x2e, 0xee, 0xe8, 0x87, 0x3b, 0x18, 0x8e, 0xee,
    0xea, 0x7f, 0x32, 0x25, 0xfe, 0xee, 0x00, 0xee, 0xc9, 0xee, 0xc9, 0x7e,
    0xee, 0xee, 0xee, 0xec, 0xe9, 0xd4, 0xa1, 0xd7, 0x87, 0x3c, 0xeb, 0xbe,
    0x92, 0x04, 0xe7, 0xde, 0x02, 0xec, 0xce, 0x0f, 0xee, 0x00, 0xed, 0x7b,
    0xee, 0xc6, 0x9c, 0xec, 0x99, 0xbb, 0x00, 0xee, 0xc7, 0x99, 0xce, 0xc7,
    0x6c, 0xee, 0xb7, 0xc3, 0x37, 0x03, 0xe5, 0x22, 0x22, 0x22, 0xe9, 0xd4,
    0x03, 0x22, 0x28, 0xee, 0xee, 0xef, 0xc2, 0x77, 0x2a, 0x18, 0x2e, 0xee,
    0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0xc0, 0x7f, 0x32, 0x25, 0xfe, 0xee,
    0xee, 0xc9, 0xee, 0x00, 0xee, 0x9b, 0xee, 0xc9, 0x79, 0xce, 0xeb, 0xdb,
    0x20, 0x77, 0xbe, 0xc1, 0xd9, 0xee, 0x9c, 0x7b, 0x74, 0x00, 0x9b, 0xe9,
    0xd9, 0x79, 0xdc, 0x97, 0x9e, 0xee, 0x40, 0xd9, 0x49, 0xcb, 0x77, 0xce,
    0xc7, 0x69, 0xce, 0x00, 0xee, 0xee, 0xb7, 0x7b, 0xee, 0x94, 0x7b, 0xee,
    0x0e, 0xee, 0xee, 0xee, 0xec, 0x99, 0xc2, 0xa2, 0xc9, 0x00, 0xb9, 0xeb,
    0x99, 0xb7, 0xed, 0x9b, 0xb7, 0x9b, 0x00, 0x7b, 0xb9, 0xee, 0x7b, 0x99,
    0xce, 0x9b, 0x9c, 0xc3, 0x2f, 0x02, 0xe2, 0x22, 0x22, 0x22, 0xe9, 0xd4,
    0x03, 0x22, 0x22, 0xae, 0xee, 0xef, 0xc2, 0x77, 0x2a, 0x18, 0x2e, 0xee,
    0xe5, 0x87, 0x3b, 0x5e, 0xee, 0xea, 0xc0, 0x7f, 0x32, 0x25, 0xfe, 0xee,
    0xee, 0xc9, 0xee, 0x00, 0xee, 0xd7, 0xed, 0x7c, 0xec, 0x7c, 0xe9, 0x9b,
    0x00, 0xec, 0x7b, 0xec, 0x6c, 0xec, 0x96, 0xee, 0x69, 0x00, 0xce, 0xc7,
    0xde, 0xe7, 0xbd, 0xeb, 0x99, 0xde, 0x00, 0x99, 0xed, 0x7c, 0xed, 0x7c,
    0xe9, 0x9c, 0xec, 0x00, 0x6d, 0xeb, 0x9d, 0xee, 0xee, 0xe9, 0x9e, 0xeb,
    0x00, 0x9e, 0xe6, 0xce, 0xee, 0xee, 0xee, 0xee, 0xec, 0xc0, 0xd3, 0xb2,
    0xee, 0xeb, 0xbe, 0xe9, 0xbb, 0xee, 0x00, 0xd7, 0x99, 0xce, 0xee, 0xcb,
    0xee, 0xec, 0x9b, 0x06, 0x7d, 0xee, 0xbb, 0x9e, 0xeb, 0x27, 0x02, 0xe2,
    0x18, 0x22, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x22, 0x5d, 0x18, 0xee, 0xef,
    0xc2, 0x77, 0x2a, 0x2e, 0xee, 0xe5, 0xc6, 0x87, 0x3b, 0x5f, 0xee, 0xea,
    0x7f, 0x32, 0x25, 0x00, 0xfe, 0xee, 0xee, 0xc9, 0xee, 0xee, 0xe6, 0xeb,
    0x01, 0xbe, 0xee, 0xc7, 0xe9, 0xbe, 0xee, 0xd6, 0xe1, 0x00, 0xc1, 0xee,
    0x4e, 0xee, 0xd7, 0xee, 0xe7, 0xce, 0x2a, 0xee, 0x4c, 0x4b, 0xd7, 0x49,
    0x9b, 0x09, 0xee, 0x00, 0xc7, 0xee, 0xee, 0x7c, 0xe7, 0xee, 0xee, 0xee,
    0x0c, 0xee, 0xee, 0xec, 0xce, 0xcb, 0xa2, 0xd9, 0xee, 0x04, 0xc9, 0x69,
    0x9e, 0x9c, 0xde, 0x4b, 0xed, 0xb9, 0x06, 0xe9, 0x96, 0x9c, 0xee, 0x9e,
    0x27, 0x01, 0xe2, 0x18, 0x22, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x22, 0x2b,
    0x18, 0xee, 0xef, 0xc2, 0x77, 0x2a, 0x2e, 0xee, 0xe5, 0xc6, 0x87, 0x3b,
    0x5f, 0xee, 0xea, 0x7f, 0x32, 0x25, 0x00, 0xfe, 0xee, 0xee, 0xc9, 0xee,
    0xee, 0xe6, 0xe9, 0x00, 0x9b, 0xbb, 0xb7, 0xe9, 0xce, 0xee, 0xe7, 0xd7,
    0x00, 0xde, 0xee, 0xe6, 0xee, 0x7e, 0xee, 0xd7, 0xee, 0x34, 0xe7, 0xee,
    0xc9, 0x4a, 0xb6, 0x49, 0xbb, 0xeb, 0x01, 0xbe, 0xee, 0xee, 0xc9, 0xee,
    0xee, 0x9b, 0x51, 0x06, 0xee, 0xee, 0xee, 0xec, 0xce, 0xcb, 0xa2, 0x99,
    0x0c, 0xec, 0x79, 0xde, 0x99, 0x8a, 0x11, 0xee, 0xeb, 0x06, 0xb9, 0xed,
    0x77, 0xce, 0x99, 0x27, 0x01, 0xe2, 0x18, 0x22, 0x22, 0x22, 0xe9, 0xd4,
    0x22, 0x22, 0x2a, 0x18, 0xee, 0xef, 0xc2, 0x77, 0x2a, 0x2e, 0xee, 0xe5,
    0xc6, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0x7f, 0x32, 0x25, 0x00, 0xfe, 0xee,
    0xee, 0xc9, 0xee, 0xee, 0xc7, 0xe9, 0x00, 0xcd, 0xdd, 0xdd, 0xe9, 0xce,
    0xee, 0xe6, 0xe7, 0x00, 0xde, 0xee, 0xe4, 0xee, 0x7e, 0xee, 0xd7, 0xee,
    0x22, 0xe7, 0xee, 0xc9, 0xe7, 0xe9, 0xbd, 0x4b, 0xbb, 0x00, 0xeb, 0xbe,
    0xee, 0xee, 0xc9, 0xee, 0xee, 0x9b, 0x83, 0x51, 0xee, 0xee, 0xee, 0xec,
    0xce, 0xcb, 0xa1, 0x02, 0xe9, 0xc9, 0x9b, 0x9e, 0xec, 0x7c, 0x5a, 0x96,
    0x81, 0x32, 0xc7, 0xce, 0xd9, 0x99, 0x9c, 0x9e, 0x1e, 0x86, 0x01, 0xe2,
    0x22, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x06, 0x22, 0x28, 0xee, 0xef, 0xc2,
    0x77, 0x2a, 0x2e, 0x31, 0xee, 0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0x7f,
    0x80, 0x32, 0x25, 0xfe, 0xee, 0xee, 0xc9, 0xee, 0xee, 0x00, 0x7c, 0xeb,
    0x9e, 0xee, 0xc9, 0xe9, 0x9e, 0xee, 0x00, 0xc7, 0xe9, 0xbe, 0xee, 0xb1,
    0xee, 0x7e, 0xee, 0x0a, 0xd7, 0xee, 0xe7, 0xee, 0xc9, 0xe7, 0x4b, 0xce,
    0x20, 0xee, 0xbb, 0x09, 0xee, 0xd6, 0xee, 0xee, 0x6d, 0x83, 0x51, 0xee,
    0xee, 0xee, 0xec, 0xce, 0xcb, 0xa1, 0x02, 0xbc, 0xe9, 0xce, 0x9b, 0xc9,
    0xde, 0x5a, 0x94, 0x83, 0x3b, 0x9c, 0x9b, 0xec, 0xbe, 0xcb, 0x1e, 0x01,
    0x0c, 0xe2, 0x22, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x22, 0x0c, 0x28, 0xee,
    0xef, 0xc2, 0x77, 0x2a, 0x2e, 0xee, 0x63, 0xe5, 0x87, 0x3b, 0x5f, 0xee,
    0xea, 0x7f, 0x32, 0x00, 0x25, 0xfe, 0xee, 0xee, 0xc7, 0xbb, 0x96, 0xbe,
    0x00, 0xee, 0x79, 0xcb, 0x7c, 0xe9, 0xb9, 0xcb, 0x6c, 0x00, 0xed, 0x79,
    0xcb, 0xb6, 0xee, 0x7e, 0xee, 0xe6, 0x11, 0xbc, 0xe7, 0xee, 0xc9, 0xe7,
    0xee, 0x99, 0x49, 0x00, 0xce, 0xee, 0xbb, 0xec, 0x6b, 0xce, 0xee, 0xeb,
    0x10, 0x7b, 0xb7, 0xbe, 0x51, 0xee, 0xee, 0xee, 0xec, 0x60, 0xce, 0xcb,
    0xa1, 0x9e, 0xeb, 0xdc, 0x9c, 0x7b, 0x84, 0x62, 0xcc, 0xb9, 0xcc, 0xde,
    0x21, 0xb7, 0xc9, 0x18, 0xcd, 0xbe, 0xe9, 0x1e, 0x01, 0xe2, 0x22, 0x22,
    0x60, 0x22, 0xe9, 0xd4, 0x22, 0x22, 0x28, 0xee, 0xef, 0x63, 0xc2, 0x77,
    0x2a, 0x2e, 0xee, 0xe5, 0x87, 0x3b, 0x18, 0x5f, 0xee, 0xea, 0x7f, 0x32,
    0x25, 0xfe, 0xee, 0x00, 0xee, 0xdb, 0xbb, 0xce, 0xee, 0xee, 0xeb, 0xbb,
    0x00, 0xde, 0xe9, 0xcc, 0xbb, 0xde, 0xee, 0xeb, 0xbc, 0x06, 0xeb, 0xee,
    0xbe, 0xee, 0xed, 0xd1, 0xc9, 0xeb, 0x00, 0xee, 0xec, 0xbb, 0xde, 0xec,
    0xde, 0xee, 0xcc, 0x01, 0xee, 0xcb, 0xce, 0xee, 0xee, 0xcb, 0xbc, 0x79,
    0x06, 0xee, 0xee, 0xee, 0xee, 0xec, 0x99, 0xbc, 0x7d, 0x08, 0xe9, 0xc9,
    0xed, 0x9e, 0x62, 0x40, 0x00, 0x00, 0x40, 0xbe, 0x21, 0xe9, 0xee, 0x9c,
    0x9e, 0xc7, 0xde, 0xc3, 0x15, 0x41, 0xe5, 0x22, 0x22, 0x22, 0xe9, 0xd4,
    0x03, 0x22, 0x22, 0x28, 0xee, 0xef, 0xc2, 0x77, 0x2a, 0x18, 0x2e, 0xee,
    0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0xc1, 0x7f, 0x32, 0x25, 0xfe, 0xee,
    0xee, 0xee, 0xe9, 0x9f, 0xd2, 0xe9, 0xce, 0xa7, 0x5f, 0x77, 0x2f, 0x01,
    0x20, 0xec, 0xce, 0x05, 0xe9, 0xcb, 0xb6, 0x7e, 0xec, 0x44, 0xbe, 0x02,
    0xb0, 0x00, 0x07, 0x02, 0xeb, 0xce, 0x0c, 0xe7, 0x7b, 0xbc, 0x9e, 0x15,
    0x41, 0xe8, 0x22, 0x30, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x22, 0x28, 0xee,
    0x31, 0xee, 0xc2, 0x77, 0x2a, 0x2d, 0xee, 0xe5, 0x87, 0x8c, 0x3b, 0x8e,
    0xee, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0x19, 0xee, 0xee, 0xee, 0xe9, 0xd2,
    0xe9, 0xce, 0xa7, 0xf2, 0x5f, 0x77, 0x2f, 0x01, 0xec, 0xce, 0x05, 0xbc,
    0x04, 0xe7, 0xbc, 0x99, 0xe9, 0xde, 0x02, 0xeb, 0x00, 0x41, 0x7d, 0x33,
    0xbe, 0x99, 0xc9, 0x7e, 0xcb, 0x15, 0x8c, 0x4a, 0x22, 0x22, 0x22, 0xe9,
    0xd4, 0x22, 0x22, 0x0c, 0x28, 0xee, 0xee, 0xc2, 0x77, 0x2a, 0x2d, 0xee,
    0x61, 0xe5, 0x87, 0x3a, 0x23, 0xce, 0xee, 0xea, 0x7f, 0x85, 0x32, 0x28,
    0xee, 0xee, 0xee, 0xe9, 0xec, 0xca, 0x3b, 0xe9, 0xce, 0x9c, 0x6c, 0x39,
    0x9e, 0x87, 0x3f, 0x90, 0x03, 0xec, 0xce, 0x3d, 0x9e, 0xe9, 0xed, 0x9c,
    0x44, 0x9b, 0x03, 0xeb, 0x00, 0x7e, 0x03, 0x99, 0xc7, 0x18, 0xde, 0x9e,
    0xe9, 0x15, 0x3a, 0xb5, 0x22, 0x22, 0x60, 0x22, 0xe9, 0xd4, 0x22, 0x28,
    0xee, 0xee, 0xd5, 0xc6, 0x7f, 0x32, 0x8e, 0xee, 0xe5, 0x87, 0x3a, 0x5b,
    0x0c, 0xee, 0xee, 0xec, 0x33, 0x77, 0x29, 0x2a, 0xee, 0x03, 0xee, 0xee,
    0xc6, 0x77, 0x7c, 0xc7, 0xc9, 0xb1, 0x0d, 0xee, 0xee, 0xeb, 0xce, 0xb6,
    0x39, 0x9e, 0xa7, 0xc8, 0x5f, 0x13, 0xec, 0xce, 0xc5, 0xbe, 0xe9, 0xe9,
    0x24, 0xde, 0x7e, 0x03, 0xeb, 0x16, 0xc4, 0xe7, 0xec, 0x0c, 0xbe, 0x9e,
    0xeb, 0xde, 0x0c, 0x3a, 0xec, 0xba, 0x10, 0xaa, 0xaa, 0xaa, 0xe9, 0xa8,
    0x32, 0x22, 0x22, 0x10, 0x22, 0x22, 0x28, 0x79, 0x85, 0x55, 0x55, 0x55,
    0xc2, 0xe9, 0xd3, 0x58, 0xce, 0xee, 0xe5, 0x42, 0x5a, 0x10, 0xaa, 0xaa,
    0xaa, 0xe9, 0xaa, 0xab, 0xce, 0xee, 0x1a, 0xee, 0xee, 0xb8, 0x07, 0xb9,
    0xae, 0x79, 0xc9, 0x18, 0xee, 0xee, 0xd7, 0x41, 0x29, 0xee, 0xee, 0xe9,
    0x78, 0xce, 0xb6, 0x76, 0x87, 0x3f, 0xee, 0xec, 0xce, 0x81, 0x04, 0xeb,
    0x7b, 0xcb, 0xe9, 0xee, 0x9e, 0xac, 0x31, 0x49, 0x6e, 0x03, 0x81, 0x9c,
    0x97, 0xbe, 0x0c, 0xc0, 0xd4, 0xa5, 0xc5, 0x22, 0x22, 0x22, 0x22, 0x28,
    0xd7, 0x3f, 0x07, 0xe5, 0x42, 0xae, 0x47, 0x07, 0x77, 0x00, 0xee, 0xee,
    0xc9, 0xee, 0xee, 0xd7, 0xee, 0xc7, 0x00, 0x77, 0xbe, 0xee, 0xb6, 0x77,
    0xce, 0x94, 0x77, 0x00, 0xdb, 0xb9, 0x6e, 0xe9, 0x77, 0x7c, 0xee, 0x7c,
    0x01, 0x97, 0x6c, 0xee, 0x7e, 0xec, 0x77, 0x79, 0x01, 0xe4, 0xe9, 0xd4,
    0xa6, 0xec, 0xce, 0x54, 0xe9, 0xdc, 0x09, 0x79, 0xcb, 0xee, 0x9e, 0xac,
    0x69, 0x6e, 0x6c, 0x07, 0xee, 0xbc, 0x99, 0xcc, 0xbe, 0x0c, 0xd4, 0xa5,
    0x00, 0xec, 0x22, 0x22, 0x22, 0x22, 0x28, 0xee, 0xee, 0x61, 0xef, 0x27,
    0xa1, 0xfe, 0xee, 0xee, 0xe5, 0x42, 0x08, 0x8c, 0xcc, 0xcc, 0xcc, 0xe9,
    0xcc, 0xcc, 0xce, 0xc0, 0x17, 0xbf, 0xee, 0xee, 0xc9, 0xee, 0xee, 0xd7,
    0x00, 0xec, 0x7d, 0xee, 0x9b, 0xeb, 0x9e, 0xed, 0x6c, 0x00, 0xe9, 0xce,
    0xeb, 0x6c, 0xee, 0x99, 0xee, 0xc6, 0x00, 0xde, 0x6b, 0xee, 0xc6, 0xee,
    0x6e, 0xe6, 0xce, 0x07, 0xeb, 0x9e, 0xee, 0xee, 0xee, 0xe9, 0xd4, 0xa5,
    0x20, 0xec, 0xce, 0x5c, 0xe9, 0xee, 0xec, 0x97, 0xbc, 0x48, 0x9e, 0xac,
    0x7b, 0x4e, 0x6c, 0xcb, 0x79, 0xce, 0x70, 0xee, 0x6c, 0x43, 0xb7, 0xee,
    0x52, 0x22, 0x22, 0x00, 0x22, 0x28, 0xee, 0xee, 0xec, 0xa8, 0x88, 0x88,
    0x61, 0x88, 0xe9, 0xd3, 0x8a, 0xde, 0xee, 0xe5, 0x49, 0xc0, 0x31, 0xd4,
    0x22, 0x28, 0xee, 0xee, 0xee, 0xc8, 0xd0, 0x07, 0xb9, 0xbe, 0x79, 0xc6,
    0x99, 0x9e, 0xd7, 0x00, 0xe9, 0xbe, 0xee, 0xd7, 0xe7, 0xde, 0xee, 0xcc,
    0x00, 0xe9, 0xce, 0xeb, 0x9e, 0xee, 0x6e, 0xee, 0xeb, 0x00, 0xbe, 0x6d,
    0xee, 0xe7, 0xde, 0x6e, 0xc9, 0xee, 0x07, 0xee, 0x9e, 0xee, 0xee, 0xee,
    0xe9, 0xd4, 0xa5, 0x29, 0xec, 0xce, 0x5c, 0xe9, 0x21, 0xb4, 0x9e, 0x03,
    0x17, 0xe7, 0x9c, 0x1d, 0xc4, 0x6b, 0x01, 0x6c, 0x43, 0x80, 0xb7, 0xee,
    0x82, 0x22, 0x22, 0x22, 0x28, 0xee, 0x38, 0xee, 0xe8, 0xc9, 0xb1, 0xd4,
    0x22, 0x8e, 0xee, 0x61, 0xe5, 0x87, 0x3b, 0xae, 0xee, 0xec, 0x52, 0x77,
    0x80, 0x29, 0x2b, 0xee, 0xee, 0xee, 0xc9, 0xee, 0xee, 0x02, 0xd7, 0xe9,
    0x99, 0x99, 0x97, 0xe6, 0xa1, 0xe9, 0x00, 0xce, 0xeb, 0xbe, 0xed, 0x7e,
    0xee, 0xec, 0x9e, 0x4f, 0x7e, 0xa9, 0x6e, 0xbb, 0x11, 0x59, 0xd4, 0xa7,
    0x10, 0xee, 0xec, 0xce, 0x44, 0xe9, 0xcc, 0xcb, 0x99, 0x22, 0xbc, 0x9e,
    0x03, 0xe7, 0x9c, 0x1c, 0x6c, 0xc9, 0x1c, 0x99, 0xbc, 0xcc, 0x6c, 0x43,
    0xb7, 0xef, 0x82, 0x01, 0x22, 0x22, 0x22, 0x28, 0xee, 0xee, 0xc2, 0xc9,
    0xc3, 0xb1, 0xd4, 0x22, 0x3e, 0xee, 0xe5, 0x87, 0x3b, 0x18, 0x8e, 0xee,
    0xeb, 0x7f, 0x32, 0x28, 0xee, 0xee, 0x00, 0xee, 0xc9, 0xee, 0xee, 0xd7,
    0xe9, 0xce, 0xee, 0x00, 0xec, 0xe6, 0xee, 0xee, 0xcc, 0xe9, 0xce, 0xeb,
    0x00, 0xbe, 0xee, 0x6e, 0xee, 0xeb, 0x9e, 0x7e, 0xee, 0x00, 0xe9, 0xce,
    0x6e, 0xb9, 0xee, 0xee, 0xce, 0xee, 0x3a, 0xee, 0xee, 0xe9, 0xd4, 0xa5,
    0xec, 0x5d, 0xe7, 0x04, 0xbb, 0xbc, 0xde, 0xee, 0x9e, 0x03, 0xe6, 0xbd,
    0x40, 0x4c, 0x03, 0xe9, 0xee, 0xed, 0xcb, 0xbb, 0x7e, 0xe0, 0x0c, 0xd4,
    0xa5, 0xef, 0x82, 0x22, 0x22, 0x22, 0x0e, 0x28, 0xee, 0xef, 0xc2, 0xc9,
    0xb1, 0xd4, 0x22, 0x18, 0x2e, 0xee, 0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea,
    0xc0, 0x7f, 0x32, 0x25, 0xfe, 0xee, 0xee, 0xc9, 0xee, 0x00, 0xee, 0xd7,
    0xec, 0x9e, 0xee, 0xb9, 0xe9, 0xbe, 0x04, 0xee, 0x7c, 0xe9, 0xce, 0xeb,
    0xd1, 0xee, 0xe7, 0x00, 0xce, 0x7e, 0xee, 0xe9, 0xce, 0x6e, 0xd6, 0xee,
    0x07, 0xec, 0x7e, 0xee, 0xee, 0xee, 0xe9, 0xd4, 0xa5, 0x2a, 0xec, 0xce,
    0x5c, 0xe9, 0x22, 0x9e, 0x03, 0xd4, 0x2e, 0xce, 0x6b, 0x03, 0xd9, 0x6f,
    0x4b, 0xbf, 0xee, 0x00, 0xef, 0x82, 0x22, 0x22, 0x22, 0x28, 0xee, 0xef,
    0x70, 0xc2, 0xc9, 0xb1, 0xd4, 0x22, 0x2e, 0xee, 0xe5, 0xc6, 0x87, 0x3b,
    0x5f, 0xee, 0xea, 0x7f, 0x32, 0x25, 0x00, 0xfe, 0xee, 0xee, 0xc7, 0x99,
    0x9c, 0xd7, 0xee, 0x00, 0x97, 0xb9, 0x7d, 0xed, 0x79, 0x97, 0xbe, 0xeb,
    0x00, 0x69, 0xdb, 0xbe, 0xee, 0xd7, 0x99, 0x7b, 0xee, 0x00, 0x7e, 0xee,
    0xe9, 0xce, 0x6e, 0xeb, 0x79, 0x97, 0x0e, 0xce, 0xee, 0xee, 0xee, 0xe9,
    0xd4, 0xa5, 0xec, 0xa8, 0x5d, 0xe9, 0xa2, 0x7c, 0x03, 0xc1, 0xce, 0x79,
    0xae, 0x03, 0xc9, 0x2a, 0x9e, 0x0c, 0xd4, 0xa5, 0xef, 0x00, 0x82, 0x22,
    0x22, 0x22, 0x28, 0xee, 0xef, 0xc2, 0xe1, 0xc9, 0xb1, 0xd4, 0x22, 0x2e,
    0xee, 0xe5, 0x87, 0x8c, 0x3b, 0x5f, 0xee, 0xea, 0x7f, 0x32, 0x25, 0xfe,
    0x00, 0xee, 0xee, 0xec, 0xcc, 0xcd, 0xec, 0xee, 0xed, 0x40, 0xcc, 0xb9,
    0xcd, 0xee, 0xee, 0xdc, 0xed, 0xde, 0x00, 0xee, 0xee, 0xcc, 0xde, 0xee,
    0xce, 0xee, 0xec, 0x83, 0xe1, 0xdc, 0xce, 0xee, 0xee, 0xee, 0xe9, 0xd4,
    0xa0, 0xa6, 0xec, 0x55, 0xe9, 0x99, 0x99, 0x97, 0x96, 0x44, 0xb9, 0x03,
    0xc1, 0xde, 0x99, 0x03, 0x9b, 0x69, 0x0e, 0x79, 0x99, 0x99, 0x9e, 0x0c,
    0xd4, 0xa5, 0xef, 0x00, 0x82, 0x22, 0x22, 0x22, 0x28, 0xee, 0xef, 0xc2,
    0xe1, 0xc9, 0xb1, 0xd4, 0x22, 0x2e, 0xee, 0xe5, 0x87, 0x8c, 0x3b, 0x5f,
    0xee, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0x1f, 0xee, 0xee, 0xee, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0xc8, 0x07, 0x01, 0xec, 0xce, 0x04, 0xe9, 0xdd, 0x9d,
    0x11, 0xeb, 0x9c, 0xe9, 0x03, 0xb6, 0xee, 0x97, 0x03, 0x03, 0x9e, 0xb7,
    0xbe, 0xcb, 0xdd, 0xbe, 0x0c, 0xd4, 0x80, 0xa5, 0xef, 0x82, 0x22, 0x22,
    0x22, 0x28, 0xee, 0x38, 0xef, 0xc2, 0xc9, 0xb1, 0xd4, 0x22, 0x2e, 0xee,
    0x63, 0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0x7f, 0x32, 0x07, 0x25, 0xfe,
    0xee, 0xee, 0xee, 0xe9, 0xd4, 0xa7, 0xf2, 0x5f, 0x17, 0x07, 0x01, 0xec,
    0xce, 0x04, 0xeb, 0x04, 0xde, 0xbc, 0xb9, 0xce, 0xeb, 0x9b, 0x97, 0xee,
    0x40, 0xb4, 0x73, 0xbe, 0xec, 0x9b, 0xcb, 0xec, 0xbe, 0xe0, 0x0c, 0xd4,
    0xa5, 0xef, 0x82, 0x22, 0x22, 0x22, 0x0e, 0x28, 0xee, 0xef, 0xc2, 0xc9,
    0xb1, 0xd4, 0x22, 0x18, 0x2e, 0xee, 0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea,
    0xc0, 0x7f, 0x32, 0x25, 0xfe, 0xee, 0xee, 0xee, 0xcc, 0xfe, 0xe1, 0xc9,
    0xd4, 0xa7, 0x5f, 0x17, 0x06, 0xec, 0x40, 0xce, 0xc5, 0xbd, 0x97, 0xbe,
    0xee, 0xd9, 0x9d, 0x88, 0x02, 0x67, 0xee, 0xc0, 0x5a, 0xd9, 0x7d, 0xee,
    0x1c, 0xeb, 0x7b, 0xdb, 0x0d, 0xd4, 0xa5, 0xef, 0x82, 0x01, 0x22, 0x22,
    0x22, 0x28, 0xee, 0xef, 0xc2, 0xc9, 0xc3, 0xb1, 0xd4, 0x22, 0x2e, 0xee,
    0xe8, 0x87, 0x3b, 0x18, 0x5f, 0xee, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0xee,
    0x01, 0xee, 0xd7, 0xbb, 0x7c, 0xee, 0xee, 0xee, 0xe9, 0x3e, 0xee, 0xe6,
    0xc5, 0x8d, 0x97, 0x4f, 0x04, 0xec, 0x52, 0xce, 0x05, 0x79, 0xb9, 0x7d,
    0xd9, 0x01, 0xed, 0x09, 0x1b, 0xee, 0xd0, 0xbe, 0x01, 0x9e, 0xc9, 0x11,
    0x70, 0x97, 0x15, 0xcd, 0x94, 0xef, 0x82, 0x22, 0x22, 0x07, 0x22, 0x28,
    0xee, 0xee, 0xc2, 0xc9, 0xb1, 0xd4, 0x0c, 0x22, 0x2e, 0xee, 0xeb, 0x87,
    0x3b, 0x5f, 0xee, 0x60, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0xee, 0xee, 0x9b,
    0x00, 0xee, 0xc9, 0xed, 0xee, 0xee, 0xde, 0xee, 0xcd, 0x00, 0xee, 0xc6,
    0xdd, 0xee, 0xec, 0xce, 0xee, 0xed, 0x80, 0xe1, 0xcc, 0xee, 0xee, 0xdc,
    0xde, 0xee, 0xee, 0x7e, 0xee, 0xe9, 0xd4, 0xa7, 0x59, 0x01, 0x2c, 0xbc,
    0x02, 0xee, 0xee, 0xd9, 0x7e, 0xec, 0xbe, 0x71, 0x0b, 0x00, 0xee, 0xe4,
    0x9e, 0xee, 0xee, 0xeb, 0xce, 0xe7, 0xb8, 0xd1, 0xbb, 0x15, 0xcd, 0x94,
    0xef, 0x82, 0x22, 0x03, 0x22, 0x22, 0x28, 0xee, 0xee, 0xc2, 0xc9, 0xb1,
    0x83, 0xd4, 0x22, 0x5e, 0xee, 0xee, 0xb5, 0x7f, 0x32, 0x18, 0x5f, 0xee,
    0xeb, 0x87, 0x3a, 0x28, 0xee, 0xee, 0x00, 0xee, 0x9b, 0xee, 0xee, 0xe6,
    0xde, 0xee, 0x6d, 0x00, 0xc7, 0xb7, 0xbe, 0x94, 0x9b, 0xee, 0x79, 0x97,
    0x00, 0xbe, 0xe7, 0x99, 0x96, 0xc9, 0x99, 0x7d, 0xec, 0x3e, 0x7b, 0x7b,
    0x21, 0x09, 0xd4, 0xa7, 0x59, 0xec, 0x40, 0xce, 0x35, 0xd9, 0xee, 0xec,
    0x9c, 0xcc, 0xeb, 0x00, 0x7c, 0xee, 0xee, 0xe9, 0x0c, 0xee, 0xe6, 0x6e,
    0x00, 0xee, 0xee, 0xb7, 0xbe, 0xbc, 0xc9, 0xde, 0xee, 0x70, 0x9e, 0x15,
    0xcd, 0x94, 0xef, 0x82, 0x22, 0x22, 0x07, 0x22, 0x28, 0xee, 0xee, 0xe8,
    0xc9, 0xb1, 0xd4, 0x00, 0x23, 0xae, 0xee, 0xee, 0xec, 0xbb, 0xbb, 0xbb,
    0xd0, 0xe9, 0xd1, 0x82, 0x29, 0x5f, 0xee, 0xed, 0x52, 0xc0, 0x07, 0x81,
    0x5c, 0xee, 0xee, 0xee, 0xc6, 0xbe, 0x00, 0xee, 0xe9, 0xbe, 0xec, 0x9e,
    0x9c, 0xee, 0x7e, 0x00, 0xe6, 0xee, 0xe9, 0xce, 0xee, 0x7c, 0xe4, 0xce,
    0x01, 0xeb, 0x7c, 0xee, 0xb9, 0xe7, 0xde, 0xe7, 0x21, 0xf2, 0x09, 0xd4,
    0xa7, 0x59, 0xec, 0xce, 0x35, 0xe9, 0x00, 0xce, 0xb6, 0xce, 0xe7, 0xc9,
    0xeb, 0x9e, 0xee, 0x00, 0xe7, 0x4d, 0xee, 0xe9, 0x1c, 0xee, 0xd9, 0xcc,
    0x03, 0xbc, 0x9e, 0xec, 0x6b, 0xec, 0xbe, 0x15, 0xcd, 0x81, 0x94, 0xed,
    0x52, 0x22, 0x22, 0x22, 0x28, 0x31, 0x0d, 0xba, 0xaa, 0xaa, 0xaa, 0xe9,
    0xd3, 0xac, 0x02, 0x08, 0xef, 0xff, 0xff, 0xff, 0xe9, 0xff, 0xff, 0xa2,
    0x01, 0x22, 0x22, 0x22, 0x5f, 0xee, 0xee, 0xdb, 0x07, 0x00, 0xaa, 0xaa,
    0xab, 0xce, 0xee, 0xee, 0xee, 0xed, 0x00, 0xb7, 0x9d, 0xec, 0x7e, 0xe9,
    0xce, 0xbb, 0xee, 0x00, 0xde, 0xe6, 0xee, 0xe7, 0xee, 0xee, 0xbb, 0xe6,
    0x00, 0xee, 0xed, 0x6e, 0xee, 0xd7, 0xe9, 0xbe, 0xed, 0xf9, 0x21, 0x09,
    0xd4, 0xa7, 0x59, 0xec, 0xce, 0xbe, 0x00, 0x79, 0xcc, 0x9e, 0xe9, 0xb7,
    0xce, 0xc9, 0xde, 0x00, 0xc1, 0x6e, 0xee, 0xeb, 0x0b, 0xed, 0x9d, 0xec,
    0x03, 0x7b, 0x9e, 0xe9, 0xcc, 0x97, 0xde, 0x15, 0xcd, 0x81, 0x94, 0xea,
    0x22, 0x22, 0x22, 0x22, 0x28, 0x37, 0x83, 0x07, 0xee, 0xed, 0xbb, 0xbb,
    0xbb, 0xe9, 0xd1, 0x07, 0x82, 0x22, 0x22, 0x22, 0x5f, 0x07, 0xbf, 0x71,
    0x00, 0xb7, 0xee, 0x7c, 0xe6, 0xee, 0xeb, 0x97, 0xce, 0x00, 0xe6, 0xee,
    0xe6, 0x99, 0x99, 0x9c, 0xe7, 0xee, 0x01, 0xed, 0x7e, 0xee, 0xd7, 0xee,
    0xb9, 0x7c, 0x07, 0xc8, 0xbf, 0x74, 0xec, 0xce, 0x36, 0xbc, 0xee, 0xb9,
    0x00, 0x99, 0xec, 0xbe, 0xc9, 0xb9, 0x70, 0x9e, 0xee, 0x00, 0xec, 0x06,
    0x9b, 0x9d, 0xe9, 0xde, 0x99, 0x9b, 0x30, 0xee, 0xcb, 0x1e, 0xc3, 0xcb,
    0xbb, 0xbb, 0xbb, 0x80, 0xe9, 0xbb, 0x82, 0x22, 0x22, 0x22, 0x22, 0x28,
    0x86, 0x29, 0xdc, 0xcc, 0xcc, 0xcc, 0xe9, 0xd3, 0xcd, 0xb8, 0x81, 0xb5,
    0x3a, 0x1a, 0xc3, 0x5f, 0xee, 0xee, 0x60, 0xec, 0x07, 0xb9, 0xee, 0xee,
    0xee, 0xee, 0xcc, 0x00, 0xee, 0xe6, 0xee, 0xb9, 0xb9, 0xee, 0xde, 0xee,
    0x08, 0x7d, 0xe6, 0xee, 0xe7, 0x89, 0xe7, 0xee, 0xed, 0x01, 0x7e, 0xee,
    0xd7, 0xed, 0xee, 0xd7, 0xde, 0x12, 0xe4, 0xe2, 0xc6, 0x85, 0xec, 0xce,
    0x3e, 0xd9, 0xee, 0x00, 0xcc, 0xe9, 0xee, 0xbc, 0xe9, 0xee, 0xc7, 0xbc,
    0x00, 0xbb, 0xbc, 0x9d, 0xee, 0x9e, 0xcb, 0xed, 0x9e, 0x18, 0xbc, 0xee,
    0x9e, 0x1e, 0xc2, 0xc8, 0x22, 0x22, 0x60, 0x22, 0xe9, 0xd4, 0x22, 0x28,
    0xee, 0xee, 0xeb, 0x40, 0x52, 0x77, 0x22, 0x22, 0x25, 0xbe, 0xee, 0xeb,
    0x61, 0x23, 0x07, 0x3a, 0x5f, 0xee, 0xee, 0x83, 0x7f, 0x80, 0x31, 0x5c,
    0xee, 0xee, 0xee, 0xc7, 0xee, 0xc6, 0x00, 0xee, 0xe6, 0x7c, 0xee, 0x9c,
    0xee, 0x7c, 0xe6, 0x00, 0xee, 0xe9, 0xbe, 0xed, 0x6d, 0xe7, 0xee, 0xed,
    0x01, 0x7e, 0xee, 0xd7, 0xe9, 0xce, 0xe7, 0xde, 0x19, 0xe1, 0x01, 0xd4,
    0xa7, 0xee, 0xee, 0xec, 0xce, 0xb7, 0x00, 0x9b, 0xb9, 0xdc, 0xbe, 0xd7,
    0x99, 0xbe, 0xec, 0x00, 0x7b, 0xcd, 0xc7, 0xee, 0xeb, 0x99, 0x7e, 0xe9,
    0x18, 0xcd, 0x7b, 0xb9, 0x1f, 0x02, 0x52, 0x22, 0x22, 0x60, 0x22, 0xe9,
    0xd4, 0x22, 0x28, 0xee, 0xee, 0xc3, 0xc6, 0x7f, 0x32, 0x5e, 0xee, 0xe8,
    0x87, 0x3b, 0x5f, 0x30, 0xee, 0xeb, 0x7f, 0x32, 0x28, 0xee, 0xee, 0xee,
    0x00, 0xeb, 0x79, 0x7c, 0xee, 0xeb, 0x7e, 0xee, 0xd9, 0x00, 0x99, 0x9e,
    0xeb, 0x69, 0xee, 0x97, 0x97, 0xce, 0x00, 0xe7, 0xee, 0xed, 0x7e, 0xee,
    0xd7, 0xed, 0x99, 0x7c, 0x99, 0x21, 0x09, 0xd4, 0xa7, 0x59, 0xec, 0xce,
    0x80, 0x37, 0xc7, 0xcc, 0xbb, 0xb9, 0xd9, 0xdb, 0x69, 0x00, 0x97, 0x99,
    0x99, 0x97, 0x99, 0x96, 0xbd, 0x9c, 0x0c, 0x9b, 0x9b, 0xcc, 0x7c, 0x27,
    0x01, 0xe8, 0x22, 0x30, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x22, 0x28, 0xee,
    0x31, 0xef, 0xc2, 0x77, 0x2a, 0x2d, 0xee, 0xe5, 0x87, 0x8c, 0x3b, 0x5f,
    0xee, 0xea, 0x7f, 0x32, 0x25, 0xee, 0x23, 0xee, 0xee, 0xe9, 0xee, 0xe9,
    0xbe, 0xbd, 0x85, 0xe1, 0x97, 0x4f, 0x07, 0xee, 0xee, 0xec, 0xce, 0x07,
    0x00, 0xeb, 0xce, 0xec, 0x9c, 0x76, 0x99, 0xbc, 0xde, 0x81, 0x02, 0xcb,
    0x99, 0x66, 0xc9, 0xce, 0xeb, 0x27, 0x86, 0x02, 0xe5, 0x22, 0x22, 0x22,
    0xe9, 0xd4, 0x22, 0x06, 0x22, 0x28, 0xee, 0xef, 0xc2, 0x77, 0x2a, 0x2e,
    0x31, 0xee, 0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0x7f, 0x82, 0x32, 0x25,
    0xfe, 0xee, 0xee, 0xee, 0xe9, 0xe6, 0xfc, 0xcc, 0x9c, 0xa7, 0x5f, 0x17,
    0x03, 0xec, 0xce, 0x80, 0x07, 0xee, 0x9c, 0xec, 0x99, 0xbd, 0xee, 0xcc,
    0x04, 0xbc, 0xb9, 0xcc, 0xb9, 0xcb, 0x39, 0x99, 0xbe, 0x61, 0xc9, 0x2f,
    0x02, 0xe2, 0x22, 0x22, 0x22, 0xe9, 0x81, 0xd4, 0x22, 0x22, 0x28, 0xee,
    0xef, 0xc2, 0x77, 0x8c, 0x2a, 0x2e, 0xee, 0xe5, 0x87, 0x3b, 0x5f, 0xee,
    0x60, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0xee, 0xee, 0xee, 0xbf, 0xe9, 0xb9,
    0xcc, 0x9c, 0xa7, 0x5f, 0x17, 0x03, 0x20, 0xec, 0xce, 0xb7, 0xcb, 0xb6,
    0x7b, 0xde, 0xed, 0x00, 0xbb, 0xbc, 0xbc, 0xbb, 0xc9, 0xbb, 0xc9, 0xeb,
    0x01, 0x9c, 0xbe, 0xee, 0xb9, 0x6b, 0xbc, 0xcd, 0x1e, 0x86, 0x01, 0xe2,
    0x22, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x06, 0x22, 0x28, 0xee, 0xef, 0xc2,
    0x77, 0x2a, 0x2e, 0x31, 0xee, 0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0x7f,
    0x80, 0x32, 0x25, 0xfe, 0xee, 0xee, 0xdb, 0xbb, 0xbc, 0x04, 0xee, 0xcc,
    0xee, 0xee, 0xee, 0xe9, 0xe4, 0xce, 0xc7, 0xc4, 0x94, 0xee, 0xec, 0x6e,
    0x8f, 0x4f, 0x4a, 0x40, 0xce, 0x03, 0xed, 0xcb, 0x99, 0x9b, 0xbb, 0xcc,
    0x00, 0x9b, 0xee, 0xe9, 0x99, 0xcb, 0xcd, 0xde, 0xed, 0x00, 0xed, 0xdb,
    0xeb, 0x9b, 0xbe, 0xee, 0xc9, 0xcc, 0x0c, 0xcb, 0xb9, 0x99, 0xbb, 0x04,
    0xd9, 0xe2, 0x22, 0x30, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x22, 0x28, 0xee,
    0x31, 0xef, 0xc2, 0x77, 0x2a, 0x2e, 0xee, 0xe5, 0x87, 0x8c, 0x3b, 0x5f,
    0xee, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0x00, 0xee, 0xee, 0xc7, 0xbb, 0xbc,
    0xee, 0xee, 0xee, 0x8d, 0xe9, 0xee, 0xee, 0xed, 0xbe, 0x7d, 0xde, 0x87,
    0xc8, 0x3f, 0x01, 0xec, 0xce, 0x02, 0xc9, 0x99, 0xbc, 0x02, 0xec, 0xec,
    0xcc, 0xbb, 0xeb, 0x9c, 0x89, 0xcb, 0x00, 0xb9, 0x97, 0x99, 0xbc, 0xde,
    0xec, 0xee, 0xe9, 0x00, 0x9c, 0xbb, 0xbb, 0xbc, 0xdd, 0xdc, 0x99, 0x9b,
    0x08, 0xde, 0xee, 0xee, 0xee, 0xe9, 0xe2, 0x22, 0x22, 0x60, 0x22, 0xe9,
    0xd4, 0x22, 0x22, 0x28, 0xee, 0xef, 0x63, 0xc2, 0x77, 0x2a, 0x2e, 0xee,
    0xe5, 0x87, 0x3b, 0x18, 0x5f, 0xee, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0xee,
    0x00, 0xee, 0xc9, 0xee, 0xee, 0xec, 0xeb, 0xbc, 0xee, 0x00, 0xee, 0xcb,
    0xce, 0xcd, 0xec, 0xee, 0xce, 0xbb, 0x08, 0xce, 0xee, 0xec, 0xbb, 0x71,
    0xbc, 0xee, 0xec, 0x00, 0xec, 0xce, 0xce, 0xcd, 0xcb, 0xbe, 0xee, 0xee,
    0x03, 0xbb, 0xce, 0xce, 0xee, 0xee, 0xee, 0xe9, 0xd4, 0x20, 0xee, 0xec,
    0x8a, 0xc7, 0x7c, 0xee, 0xcb, 0xb9, 0x00, 0x9b, 0x99, 0xb9, 0xde, 0xd9,
    0x9c, 0xdb, 0x74, 0x00, 0x14, 0x67, 0x77, 0x76, 0x41, 0x16, 0x9c, 0xdb,
    0x00, 0x9c, 0xec, 0x99, 0xc9, 0x99, 0x9b, 0xbb, 0xce, 0x04, 0xc9, 0x6b,
    0xee, 0xee, 0xee, 0xe9, 0xe2, 0x22, 0x30, 0x22, 0x22, 0xe9, 0xd4, 0x22,
    0x22, 0x2a, 0xee, 0x31, 0xef, 0xc2, 0x77, 0x2a, 0x2e, 0xee, 0xe5, 0x87,
    0x8c, 0x3b, 0x5f, 0xee, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0x00, 0xee, 0xee,
    0xc9, 0xee, 0xee, 0xc7, 0x9b, 0xb6, 0x00, 0xce, 0xe9, 0x7b, 0xb9, 0x9c,
    0xe7, 0xec, 0x99, 0x00, 0xbb, 0x6c, 0xee, 0x99, 0xbb, 0x7d, 0xed, 0x7b,
    0x00, 0xb9, 0x9e, 0xe7, 0x97, 0xbd, 0x7e, 0xb9, 0x9b, 0x00, 0x97, 0xee,
    0xd6, 0x9b, 0x9b, 0x6e, 0xee, 0xee, 0x62, 0xee, 0xe9, 0xd4, 0xee, 0xec,
    0xce, 0x8a, 0xc9, 0x04, 0x7d, 0xb9, 0x99, 0xbc, 0xcd, 0x39, 0xdb, 0x60,
    0x40, 0x09, 0x7a, 0xec, 0xb1, 0x04, 0x9c, 0xee, 0xec, 0x00, 0xcd, 0xcc,
    0xbc, 0xbb, 0xc9, 0xcb, 0x9b, 0xde, 0xc3, 0x41, 0x29, 0xe2, 0x22, 0x22,
    0x22, 0xe9, 0xd4, 0x03, 0x22, 0x22, 0x2b, 0xee, 0xef, 0xc2, 0x77, 0x2a,
    0x18, 0x2e, 0xee, 0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0xc0, 0x7f, 0x32,
    0x25, 0xfe, 0xee, 0xee, 0xc9, 0xcc, 0x00, 0xce, 0xd6, 0xde, 0xec, 0x7e,
    0xc7, 0xee, 0xec, 0x00, 0x4c, 0xe7, 0xec, 0x6e, 0xee, 0xc9, 0xec, 0x9e,
    0x00, 0xee, 0xc9, 0xe9, 0xce, 0xee, 0x9c, 0xe7, 0x9e, 0x00, 0xed, 0x7e,
    0xb9, 0xee, 0xe9, 0xbe, 0x9b, 0xee, 0x06, 0xeb, 0x6e, 0xee, 0xee, 0xee,
    0xe9, 0xd4, 0xee, 0x20, 0xec, 0xce, 0x8b, 0x9e, 0xcc, 0xdc, 0xcb, 0x99,
    0x02, 0x99, 0x99, 0x99, 0x99, 0x96, 0x04, 0x7b, 0x70, 0x43, 0x19, 0x93,
    0xbb, 0xce, 0xeb, 0xeb, 0x83, 0x61, 0x0c, 0xe2, 0x22, 0x22, 0x22, 0xe9,
    0xd4, 0x22, 0x22, 0x0c, 0x3d, 0xee, 0xef, 0xc2, 0x77, 0x2a, 0x2e, 0xee,
    0x63, 0xe5, 0x87, 0x3b, 0x5f, 0xee, 0xea, 0x7f, 0x32, 0x00, 0x25, 0xfe,
    0xee, 0xee, 0xc7, 0xbb, 0xbe, 0xd7, 0x00, 0xee, 0xee, 0x6e, 0xbb, 0xee,
    0xee, 0x7c, 0xe7, 0x00, 0xec, 0x7e, 0xee, 0xe7, 0xe9, 0xbe, 0xee, 0xd7,
    0x00, 0xe7, 0xee, 0xee, 0xb9, 0xe7, 0xce, 0xed, 0x7e, 0x00, 0xbb, 0xee,
    0xeb, 0xbe, 0x6e, 0xee, 0xed, 0x6e, 0x18, 0xee, 0xee, 0xee, 0xe9, 0xd4,
    0xee, 0xec, 0xce, 0x82, 0xd3, 0xbc, 0xb9, 0x99, 0xbc, 0xde, 0x83, 0xb9,
    0x44, 0x7c, 0x01, 0xe9, 0x9b, 0xcd, 0x03, 0xcb, 0xb9, 0x10, 0x99, 0xcc,
    0x9e, 0xb3, 0xee, 0xee, 0xe2, 0x22, 0x30, 0x22, 0x22, 0xe9, 0xd4, 0x22,
    0x22, 0xae, 0xee, 0x31, 0xef, 0xc2, 0x77, 0x2a, 0x2e, 0xee, 0xe5, 0x87,
    0x8c, 0x3b, 0x5f, 0xee, 0xea, 0x7f, 0x32, 0x25, 0xfe, 0x00, 0xee, 0xee,
    0xc9, 0xee, 0xee, 0xd7, 0xee, 0xee, 0x00, 0x6e, 0xbb, 0xee, 0xee, 0x9c,
    0xe7, 0xec, 0x9e, 0x00, 0xee, 0xe7, 0xe9, 0x9b, 0xbb, 0xbb, 0xe6, 0xbb,
    0x00, 0xbb, 0xbc, 0xe7, 0xce, 0xed, 0x7e, 0xbb, 0xee, 0x11, 0xeb, 0xbe,
    0x6e, 0x19, 0xee, 0xee, 0xee, 0xe9, 0x89, 0xd4, 0xee, 0xec, 0xce, 0x8a,
    0xe9, 0x9b, 0xcb, 0xc2, 0x37, 0x07, 0xee, 0xec, 0xb9, 0x6d, 0x35, 0xe5,
    0x18, 0x22, 0x22, 0x22, 0xe9, 0xd4, 0x22, 0x25, 0xde, 0x18, 0xee, 0xef,
    0xc2, 0x77, 0x2a, 0x2e, 0xee, 0xe8, 0xc6, 0x87, 0x3b, 0x8e, 0xee, 0xea,
    0x7f, 0x32, 0x25, 0x00, 0xfe, 0xee, 0xee, 0xc9, 0xee, 0xee, 0xd7, 0xee,
    0x00, 0xee, 0x6e, 0xb9, 0xee, 0xee, 0x6c, 0xe7, 0xec, 0x00, 0x9e, 0xee,
    0xe7, 0xeb, 0xbe, 0xee, 0xdb, 0xe7, 0x00, 0xde, 0xee, 0xcc, 0xe7, 0xce,
    0xed, 0x7e, 0xbb, 0x00, 0xee, 0xeb, 0xbe, 0x7c, 0xee, 0xec, 0x6e, 0xee,
    0x31, 0xee, 0xee, 0xe9, 0xd4, 0xee, 0xec, 0xce, 0xd3, 0xe8, 0x67, 0x1f,
    0x77, 0xde, 0x25, 0xe8, 0x22, 0x22, 0x65, 0x22, 0xe9, 0xd4, 0x23, 0x5c,
    0x01, 0xc2, 0x77, 0x86, 0x2a, 0x2d, 0xee, 0xeb, 0x23, 0x7f, 0x31, 0x32,
    0x18, 0xbe, 0xee, 0xea, 0x07, 0x3a, 0x25, 0xfe, 0xee, 0x00, 0xee, 0xc9,
    0xee, 0xee, 0xd7, 0xee, 0xee, 0x6e, 0x00, 0xe6, 0xbe, 0xe9, 0x7c, 0xe7,
    0xec, 0x9e, 0xee, 0x00, 0xe7, 0xed, 0x7c, 0xee, 0x9b, 0xec, 0x9d, 0xec,
    0x00, 0x7d, 0xe7, 0xce, 0xed, 0x7e, 0xbb, 0xee, 0xeb, 0x00, 0xbe, 0xb7,
    0xce, 0xc9, 0x6e, 0xee, 0xee, 0xee, 0xc7, 0xe9, 0xd4, 0xee, 0xec, 0xce,
    0x8f, 0x47, 0x77, 0xc1, 0x2f, 0x02, 0xec, 0x32, 0x22, 0x22, 0x22, 0xe9,
    0x96, 0xd3, 0x25, 0xcf, 0x01, 0xd5, 0x7f, 0x32, 0x5e, 0x18, 0xee, 0xee,
    0x83, 0x7f, 0x31, 0x28, 0xee, 0xee, 0x60, 0xeb, 0x07, 0x7d, 0xee, 0xc7,
    0x77, 0x7c, 0xd9, 0x00, 0xee, 0xee, 0x9e, 0xec, 0x77, 0x7c, 0x9c, 0xe9,
    0x00, 0xec, 0xbe, 0xee, 0xe9, 0xee, 0xc9, 0x77, 0xbe, 0x00, 0xee, 0xb7,
    0x77, 0xce, 0xe9, 0xde, 0xee, 0x9e, 0x00, 0xbc, 0xee, 0xec, 0xbe, 0xeb,
    0x77, 0x9d, 0x6e, 0x18, 0xee, 0xee, 0xee, 0xe9, 0xd4, 0xee, 0xec, 0xce,
    0x97, 0x8f, 0xee, 0xcc, 0x31, 0xed, 0xda, 0x04, 0x37, 0x86, 0x05, 0xb5,
    0x22, 0x22, 0x22, 0xe9, 0xd2, 0x25, 0x48, 0xae, 0x22, 0xeb, 0x52, 0x77,
    0x22, 0x22, 0x28, 0x0c, 0xce, 0xee, 0xee, 0xe8, 0x87, 0x39, 0x8c, 0xee,
    0x10, 0xee, 0xee, 0xa5, 0x7f, 0x22, 0x22, 0x23, 0x8d, 0xe1, 0x79, 0x61,
    0xd2, 0xec, 0xee, 0xee, 0x9c, 0x97, 0xc3, 0x4f, 0x01, 0xcd, 0xee, 0xed,
    0x7e, 0x3f, 0x02, 0x30, 0xec, 0xce, 0xd3, 0x02, 0xed, 0x6b, 0xbe, 0xee,
    0x0f, 0xee, 0xe7, 0xcc, 0x9d, 0x06, 0x33, 0x9e, 0x02, 0x08, 0xba, 0xaa,
    0xaa, 0xaa, 0xe9, 0xaa, 0xaa, 0xab, 0xec, 0x2f, 0x07, 0x7c, 0xcb, 0x04,
    0xd2, 0xac, 0xdf, 0xe1, 0x07, 0x07, 0x77, 0xe6, 0xde, 0xec, 0x6e, 0x0f,
    0xc3, 0x07, 0x01, 0xc9, 0xee, 0xeb, 0x9e, 0x3f, 0x02, 0x20, 0xec, 0xce,
    0x4b, 0x99, 0x97, 0xb9, 0x9b, 0xbb, 0x00, 0x69, 0x7b, 0x79, 0x7d, 0xd7,
    0x9b, 0x96, 0xb9, 0x00, 0x99, 0x99, 0x9b, 0xbb, 0x7c, 0xdb, 0x7b, 0x79,
    0x01, 0x97, 0xbb, 0x99, 0x79, 0x7b, 0xbb, 0x7c, 0x01, 0xff, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0xc3, 0x07, 0x06, 0xec, 0x79, 0x96,
    0xce, 0x07, 0x07, 0x8c, 0x01, 0xe9, 0x79, 0x97, 0x47, 0x07, 0xee, 0xee,
    0x00, 0xeb, 0x79, 0xb7, 0xde, 0x6c, 0x9c, 0x6c, 0x7b, 0x00, 0x9b, 0x7e,
    0xe9, 0xc6, 0xc6, 0xb7, 0xbb, 0x9b, 0x00, 0xb7, 0x7b, 0x7e, 0xee, 0x99,
    0x9c, 0xe7, 0xcb, 0x07, 0x9b, 0x7c, 0x9b, 0x79, 0x7d, 0x01, 0xe9, 0xd4,
    0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x3b, 0xec, 0xce,
    0x07, 0x07, 0x03, 0xdc, 0x3f, 0x07, 0x80, 0x01, 0xe9, 0x99, 0xb7, 0xc9,
    0xbb, 0x9e, 0x7c, 0x00, 0x7b, 0x9b, 0x7e, 0xe9, 0xc6, 0xc6, 0xdc, 0x99,
    0x20, 0x9b, 0xb6, 0xb9, 0x9c, 0x7b, 0x79, 0xc9, 0xbb, 0x0f, 0x6c, 0x99,
    0x99, 0x7d, 0x01, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x01, 0xeb, 0xbb, 0xcc,
    0x00, 0xbd, 0xbe, 0x9c, 0xbe, 0xcc, 0xbe, 0xeb, 0xcd, 0x00, 0xc9, 0xc9,
    0x9c, 0xbb, 0xcd, 0xcc, 0xbe, 0xed, 0x00, 0xbc, 0xbc, 0xcb, 0xee, 0xcc,
    0x9c, 0xbe, 0xce, 0x7f, 0xbc, 0x02, 0xe2, 0xc6, 0x87, 0x3f, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xc0, 0x07, 0x05,
};
