
/*
Changes are made in slider canvas and main function

*/


#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"
#include "utils/ustdlib.h"
#include "drivers/Kentec320x240x16_ssd2119_spi.h"
#include "drivers/touch.h"
#include "images.h"
#include <math_fun.h>

#define N 16
  void delayMs(int n)

    {

        int i, j;

        for(i = 0 ; i < n; i++)

            for(j = 0; j < 3180; j++) {}   /* do nothing for 1 ms */

    }


  complex float a[100][N]={
                         {15, 5, 13, 7, 2, 16, 10, 8, 4, 6, 14, 11, 3, 9, 1, 12},
                         {7, 11, 9, 13, 15, 12, 4, 1, 2, 16, 10, 8, 14, 6, 3, 5},
                         {5, 3, 13, 7, 4, 8, 9, 15, 11, 14, 1, 16, 2, 12, 10, 6},
                         {12, 8, 7, 10, 5, 6, 14, 4, 2, 1, 3, 15, 11, 9, 13, 16},
                         {12, 7, 13, 14, 15, 11, 16, 8, 1, 10, 9, 6, 3, 4, 5, 2},
                         {4, 10, 15, 11, 8, 2, 6, 3, 14, 7, 1, 13, 9, 16, 5, 12},
                         {5, 2, 3, 15, 11, 12, 1, 8, 6, 4, 7, 13, 10, 9, 14, 16},
                         {5, 10, 9, 4, 8, 7, 2, 3, 14, 6, 13, 1, 16, 12, 15, 11},
                         {11, 3, 9, 7, 4, 5, 16, 8, 14, 13, 10, 1, 12, 6, 2, 15},
                         {12, 1, 7, 10, 4, 16, 6, 2, 13, 11, 9, 14, 8, 3, 15, 5},
                         {15, 13, 11, 5, 10, 3, 1, 6, 14, 7, 8, 16, 4, 9, 2, 12},
                         {13, 12, 6, 14, 9, 1, 15, 3, 10, 8, 2, 7, 16, 4, 5, 11},
                         {6, 1, 12, 9, 13, 4, 5, 16, 10, 14, 7, 8, 3, 2, 15, 11},
                         {5, 7, 16, 3, 11, 1, 12, 10, 4, 2, 8, 15, 13, 14, 9, 6},
                         {5, 8, 2, 16, 3, 4, 10, 14, 9, 15, 7, 11, 13, 1, 6, 12},
                         {10, 6, 4, 16, 13, 8, 3, 5, 12, 1, 9, 11, 15, 7, 2, 14},
                         {11, 14, 8, 1, 2, 10, 13, 4, 7, 3, 6, 9, 15, 5, 16, 12},
                         {4, 16, 14, 10, 13, 12, 6, 11, 7, 2, 3, 5, 1, 9, 8, 15},
                         {13, 5, 12, 15, 2, 14, 8, 11, 6, 16, 9, 1, 4, 3, 7, 10},
                         {13, 8, 10, 2, 9, 3, 7, 14, 4, 5, 16, 11, 1, 6, 12, 15},
                         {16, 9, 13, 3, 14, 1, 4, 11, 8, 12, 6, 15, 2, 5, 10, 7},
                         {8, 5, 9, 7, 4, 10, 1, 13, 14, 3, 6, 16, 12, 2, 11, 15},
                         {4, 5, 11, 13, 7, 6, 14, 3, 8, 15, 1, 12, 2, 16, 10, 9},
                         {14, 1, 4, 13, 7, 12, 6, 9, 15, 10, 8, 11, 16, 2, 5, 3},
                         {6, 8, 11, 16, 2, 1, 3, 4, 10, 14, 13, 9, 7, 12, 15, 5},
                         {1, 3, 4, 7, 15, 16, 2, 9, 8, 5, 11, 10, 14, 6, 12, 13},
                         {5, 8, 15, 16, 14, 6, 12, 7, 1, 4, 9, 2, 11, 13, 10, 3},
                         {11, 6, 10, 16, 15, 3, 1, 13, 4, 9, 14, 12, 2, 5, 7, 8},
                         { 8, 16, 10, 2, 13, 4, 9, 12, 1, 14, 5, 7, 11, 6, 15, 3},
                         { 13, 15, 6, 4, 3, 2, 12, 9, 14, 8, 7, 10, 5, 11, 16, 1},
                         { 9, 10, 16, 3, 2, 12, 4, 13, 14, 8, 7, 5, 1, 11, 15, 6},
                         {2, 3, 16, 7, 1, 14, 11, 15, 10, 9, 12, 4, 6, 5, 13, 8},
                         {1, 7, 2, 9, 8, 14, 12, 11, 5, 4, 10, 13, 6, 15, 3, 16},
                         {7, 14, 8, 11, 10, 12, 1, 5, 4, 6, 3, 2, 16, 13, 15, 9},
                         {2, 13, 12, 1, 10, 6, 15, 14, 5, 4, 16, 7, 3, 8, 9, 11},
                         {15, 12, 13, 4, 16, 2, 9, 1, 7, 14, 11, 3, 6, 8, 5, 10},
                         { 5, 15, 16, 11, 1, 3, 10, 4, 12, 2, 13, 6, 14, 9, 7, 8},
                         {11, 13, 12, 8, 7, 14, 2, 3, 6, 16, 4, 9, 5, 15, 10, 1},
                         {6, 2, 14, 12, 9, 11, 3, 4, 8, 1, 13, 10, 16, 7, 15, 5},
                         {14, 16, 12, 5, 11, 4, 1, 6, 9, 8, 2, 10, 3, 15, 7, 13},
                         {5, 1, 15, 2, 6, 12, 13, 8, 3, 7, 14, 16, 9, 4, 11, 10},
                         {3, 8, 15, 16, 9, 10, 2, 1, 5, 13, 14, 11, 12, 6, 4, 7},
                         {14, 8, 11, 13, 16, 15, 4, 2, 6, 1, 9, 12, 3, 10, 5, 7},
                         { 9, 12, 8, 3, 11, 16, 15, 14, 6, 2, 7, 5, 1, 4, 10, 13},
                         { 14, 8, 13, 12, 2, 9, 5, 6, 16, 1, 7, 15, 11, 10, 4, 3},
                         { 9, 7, 5, 15, 6, 4, 11, 14, 2, 8, 10, 3, 16, 12, 1, 13},
                         { 14, 12, 13, 10, 4, 2, 7, 11, 5, 15, 8, 16, 1, 9, 3, 6},
                         {13, 6, 15, 7, 8, 1, 12, 11, 10, 3, 9, 4, 5, 14, 16, 2},
                         {5, 14, 4, 9, 12, 11, 2, 1, 13, 15, 6, 3, 16, 7, 8, 10},
                         {12, 3, 4, 5, 1, 13, 8, 2, 11, 7, 14, 16, 9, 15, 10, 6},
                         {13, 4, 7, 1, 14, 3, 15, 16, 10, 5, 11, 2, 9, 6, 12, 8},
                         {10, 5, 8, 14, 16, 4, 1, 9, 2, 13, 12, 7, 3, 6, 15, 11},
                         {16, 12, 1, 11, 4, 5, 10, 9, 3, 7, 14, 8, 2, 15, 6, 13},
                         {12, 13, 8, 10, 4, 2, 11, 9, 14, 7, 6, 1, 16, 3, 5, 15},
                         {7, 12, 5, 1, 10, 4, 13, 15, 2, 3, 11, 9, 8, 16, 6, 14},
                         {15, 5, 3, 1, 10, 9, 11, 13, 2, 16, 4, 6, 14, 7, 8, 12},
                         {12, 16, 2, 1, 15, 14, 8, 10, 11, 7, 13, 9, 5, 3, 4, 6},
                         {14, 1, 6, 10, 8, 2, 9, 13, 11, 16, 15, 7, 5, 12, 4, 3},
                         {16, 5, 6, 2, 7, 9, 11, 12, 4, 13, 3, 1, 8, 14, 15, 10},
                         {5, 12, 9, 1, 6, 7, 13, 10, 14, 16, 2, 4, 15, 8, 3, 11},
                         {2, 15, 14, 9, 3, 6, 16, 5, 1, 11, 12, 8, 13, 7, 10, 4},
                         {2, 12, 14, 1, 9, 6, 10, 13, 7, 4, 11, 15, 16, 5, 8, 3},
                         {15, 5, 14, 7, 6, 3, 10, 16, 2, 12, 9, 11, 8, 13, 4, 1},
                         {1, 2, 14, 15, 9, 7, 12, 3, 16, 10, 11, 8, 4, 13, 5, 6},
                         {11, 15, 3, 10, 5, 4, 8, 6, 12, 16, 2, 7, 1, 9, 13, 14},
                         {12, 10, 14, 13, 4, 8, 2, 3, 7, 11, 1, 15, 5, 16, 9, 6},
                         {1, 9, 15, 5, 2, 3, 13, 6, 7, 12, 10, 14, 8, 4, 16, 11},
                         {14, 3, 9, 2, 6, 13, 5, 16, 10, 11, 12, 4, 8, 7, 15, 1},
                         {4, 7, 10, 6, 13, 1, 8, 5, 14, 15, 16, 12, 9, 11, 3, 2},
                         { 5, 1, 11, 7, 14, 9, 6, 16, 3, 4, 15, 13, 12, 8, 10, 2},
                         {11, 7, 9, 10, 8, 1, 5, 4, 2, 15, 14, 12, 16, 13, 6, 3},
                         {10, 8, 6, 5, 12, 16, 3, 11, 7, 14, 15, 13, 9, 2, 1, 4},
                         {16, 3, 14, 13, 2, 7, 12, 15, 6, 10, 11, 1, 9, 8, 4, 5},
                         {2, 15, 8, 10, 4, 3, 14, 1, 7, 12, 13, 11, 16, 5, 9, 6},
                         {6, 12, 15, 9, 6, 10, 5, 4, 2, 14, 8, 7, 11, 3, 1, 13},
                         { 1, 5, 7, 3, 8, 9, 10, 2, 6, 15, 11, 16, 14, 4, 12, 13},
                         { 4, 10, 2, 6, 5, 11, 3, 1, 16, 8, 9, 14, 7, 12, 13, 15},
                         { 6, 16, 11, 13, 15, 10, 1, 7, 14, 2, 12, 4, 8, 9, 5, 3},
                         {6, 3, 9, 14, 8, 16, 2, 10, 13, 15, 7, 4, 11, 1, 5, 12},
                         {14, 4, 5, 13, 15, 2, 12, 16, 9, 7, 3, 8, 11, 6, 1, 10},
                         {11, 2, 9, 1, 12, 14, 16, 10, 13, 3, 8, 7, 4, 15, 6, 5},
                         { 12, 8, 6, 1, 2, 10, 14, 16, 13, 5, 9, 4, 7, 3, 15, 11},
                         { 1, 7, 8, 2, 16, 9, 12, 5, 13, 10, 15, 3, 4, 14, 6, 11},
                         { 4, 5, 1, 3, 13, 16, 10, 2, 12, 15, 11, 14, 9, 8, 6, 7},
                         {16, 4, 8, 7, 2, 15, 9, 3, 12, 1, 13, 14, 11, 6, 10, 5},
                         { 1, 6, 13, 15, 3, 7, 11, 14, 8, 9, 16, 12, 2, 10, 5, 4},
                         { 11, 8, 12, 7, 5, 14, 1, 13, 16, 9, 2, 10, 3, 6, 4, 15},
                         {4, 2, 9, 3, 11, 5, 6, 13, 14, 16, 8, 12, 7, 10, 15, 1},
                         { 13, 10, 16, 2, 8, 15, 1, 11, 4, 6, 7, 9, 14, 3, 12, 5},
                         { 13, 11, 16, 6, 1, 10, 2, 7, 14, 4, 3, 9, 15, 12, 8, 5},
                         {6, 7, 9, 5, 14, 10, 16, 12, 8, 2, 15, 4, 13, 1, 11, 3},
                         { 1, 5, 11, 4, 13, 16, 15, 7, 8, 14, 2, 12, 6, 3, 9, 10},
                         { 16, 3, 8, 2, 6, 15, 11, 12, 5, 9, 10, 13, 4, 14, 1, 7},
                         { 3, 16, 7, 14, 15, 13, 8, 6, 11, 10, 4, 2, 1, 5, 9, 12},
                         { 8, 7, 9, 13, 12, 2, 3, 11, 16, 15, 1, 14, 6, 5, 10, 4},
                         { 9, 12, 1, 2, 5, 6, 14, 13, 15, 16, 3, 11, 4, 10, 7, 8},
                         {5, 6, 16, 1, 8, 3, 12, 9, 11, 2, 14, 10, 4, 7, 13, 15},
                         {11, 7, 2, 10, 9, 1, 15, 4, 6, 16, 13, 14, 5, 8, 12, 3},
                         {16, 2, 7, 9, 15, 10, 6, 4, 12, 11, 14, 3, 13, 5, 8, 1},
                         {12, 7, 1, 16, 14, 13, 8, 15, 6, 3, 2, 10, 11, 4, 5, 9}
};
  float absfft[N];

//*****************************************************************************

//*****************************************************************************
//
// The error routine that is called if the driver library encounters an error.
//
//*****************************************************************************
#ifdef DEBUG
void
__error__(char *pcFilename, uint32_t ui32Line)
{
}
#endif

//*****************************************************************************
//
// The DMA control structure table.
//
//*****************************************************************************
#ifdef ewarm
#pragma data_alignment=1024
tDMAControlTable psDMAControlTable[64];
#elif defined(ccs)
#pragma DATA_ALIGN(psDMAControlTable, 1024)
tDMAControlTable psDMAControlTable[64];
#else
tDMAControlTable psDMAControlTable[64] __attribute__ ((aligned(1024)));
#endif

//*****************************************************************************
//
// Forward declarations for the globals required to define the widgets at
// compile-time.
//
//*****************************************************************************
void OnPrevious(tWidget *psWidget);
void OnNext(tWidget *psWidget);
void OnIntroPaint(tWidget *psWidget, tContext *psContext);
void OnPrimitivePaint(tWidget *psWidget, tContext *psContext);
void OnCanvasPaint(tWidget *psWidget, tContext *psContext);
void OnCheckChange(tWidget *psWidget, uint32_t bSelected);
void OnButtonPress(tWidget *psWidget);
void OnRadioChange(tWidget *psWidget, uint32_t bSelected);
void OnSliderChange(tWidget *psWidget, int32_t i32Value);
extern tCanvasWidget g_psPanels[];

//*****************************************************************************
//
// The first panel, which contains introductory text explaining the
// application.
//
//*****************************************************************************
Canvas(g_sIntroduction, g_psPanels, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 24,
       320, 166, CANVAS_STYLE_APP_DRAWN, 0, 0, 0, 0, 0, 0, OnIntroPaint);

//*****************************************************************************
//
// The second panel, which demonstrates the graphics primitives.
//
//*****************************************************************************
Canvas(g_sPrimitives, g_psPanels + 1, 0, 0, &g_sKentec320x240x16_SSD2119, 0,
       24, 320, 166, CANVAS_STYLE_APP_DRAWN, 0, 0, 0, 0, 0, 0,
       OnPrimitivePaint);

//*****************************************************************************
//
// The third panel, which demonstrates the canvas widget.
//
//*****************************************************************************
Canvas(g_sCanvas3, g_psPanels + 2, 0, 0, &g_sKentec320x240x16_SSD2119, 205,
       27, 110, 158, CANVAS_STYLE_OUTLINE | CANVAS_STYLE_APP_DRAWN, 0, ClrGray,
       0, 0, 0, 0, OnCanvasPaint);
Canvas(g_sCanvas2, g_psPanels + 2, &g_sCanvas3, 0,
       &g_sKentec320x240x16_SSD2119, 5, 109, 195, 76,
       CANVAS_STYLE_OUTLINE | CANVAS_STYLE_IMG, 0, ClrGray, 0, 0, 0, g_pui8Logo,
       0);
Canvas(g_sCanvas1, g_psPanels + 2, &g_sCanvas2, 0,
       &g_sKentec320x240x16_SSD2119, 5, 27, 195, 76,
       CANVAS_STYLE_FILL | CANVAS_STYLE_OUTLINE | CANVAS_STYLE_TEXT,
       ClrMidnightBlue, ClrGray, ClrSilver, &g_sFontCm22, "Text", 0, 0);

//*****************************************************************************
//
// The fourth panel, which demonstrates the checkbox widget.
//
//*****************************************************************************
tCanvasWidget g_psCheckBoxIndicators[] =
{
    CanvasStruct(g_psPanels + 3, g_psCheckBoxIndicators + 1, 0,
                 &g_sKentec320x240x16_SSD2119, 230, 30, 50, 42,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psPanels + 3, g_psCheckBoxIndicators + 2, 0,
                 &g_sKentec320x240x16_SSD2119, 230, 82, 50, 48,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psPanels + 3, 0, 0,
                 &g_sKentec320x240x16_SSD2119, 230, 134, 50, 42,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0)
};
tCheckBoxWidget g_psCheckBoxes[] =
{
    CheckBoxStruct(g_psPanels + 3, g_psCheckBoxes + 1, 0,
                   &g_sKentec320x240x16_SSD2119, 40, 30, 185, 42,
                   CB_STYLE_OUTLINE | CB_STYLE_FILL | CB_STYLE_TEXT, 16,
                   ClrMidnightBlue, ClrGray, ClrSilver, &g_sFontCm22, "Select",
                   0, OnCheckChange),
    CheckBoxStruct(g_psPanels + 3, g_psCheckBoxes + 2, 0,
                   &g_sKentec320x240x16_SSD2119, 40, 82, 185, 48,
                   CB_STYLE_IMG, 16, 0, ClrGray, 0, 0, 0, g_pui8Logo,
                   OnCheckChange),
    CheckBoxStruct(g_psPanels + 3, g_psCheckBoxIndicators, 0,
                   &g_sKentec320x240x16_SSD2119, 40, 134, 189, 42,
                   CB_STYLE_OUTLINE | CB_STYLE_TEXT, 16,
                   0, ClrGray, ClrGreen, &g_sFontCm20, "Select",
                   0, OnCheckChange),
};
#define NUM_CHECK_BOXES         (sizeof(g_psCheckBoxes) /   \
                                 sizeof(g_psCheckBoxes[0]))

//*****************************************************************************
//
// The fifth panel, which demonstrates the container widget.
//
//*****************************************************************************
Container(g_sContainer3, g_psPanels + 4, 0, 0, &g_sKentec320x240x16_SSD2119,
          210, 47, 105, 118, CTR_STYLE_OUTLINE | CTR_STYLE_FILL,
          ClrMidnightBlue, ClrGray, 0, 0, 0);
Container(g_sContainer2, g_psPanels + 4, &g_sContainer3, 0,
          &g_sKentec320x240x16_SSD2119, 5, 109, 200, 76,
          (CTR_STYLE_OUTLINE | CTR_STYLE_FILL | CTR_STYLE_TEXT |
           CTR_STYLE_TEXT_CENTER), ClrMidnightBlue, ClrGray, ClrSilver,
          &g_sFontCm22, "Group2");
Container(g_sContainer1, g_psPanels + 4, &g_sContainer2, 0,
          &g_sKentec320x240x16_SSD2119, 5, 27, 200, 76,
          CTR_STYLE_OUTLINE | CTR_STYLE_FILL | CTR_STYLE_TEXT, ClrMidnightBlue,
          ClrGray, ClrSilver, &g_sFontCm22, "Group1");

//*****************************************************************************
//
// The sixth panel, which contains a selection of push buttons.
//
//*****************************************************************************
tCanvasWidget g_psPushButtonIndicators[] =
{
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 1, 0,
                 &g_sKentec320x240x16_SSD2119, 40, 85, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 2, 0,
                 &g_sKentec320x240x16_SSD2119, 90, 85, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 3, 0,
                 &g_sKentec320x240x16_SSD2119, 145, 85, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 4, 0,
                 &g_sKentec320x240x16_SSD2119, 40, 165, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 5, 0,
                 &g_sKentec320x240x16_SSD2119, 90, 165, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 6, 0,
                 &g_sKentec320x240x16_SSD2119, 145, 165, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 7, 0,
                 &g_sKentec320x240x16_SSD2119, 190, 35, 110, 24,
                 CANVAS_STYLE_TEXT, 0, 0, ClrSilver, &g_sFontCm20, "Non-auto",
                 0, 0),
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 8, 0,
                 &g_sKentec320x240x16_SSD2119, 190, 55, 110, 24,
                 CANVAS_STYLE_TEXT, 0, 0, ClrSilver, &g_sFontCm20, "repeat",
                 0, 0),
    CanvasStruct(g_psPanels + 5, g_psPushButtonIndicators + 9, 0,
                 &g_sKentec320x240x16_SSD2119, 190, 115, 110, 24,
                 CANVAS_STYLE_TEXT, 0, 0, ClrSilver, &g_sFontCm20, "Auto",
                 0, 0),
    CanvasStruct(g_psPanels + 5, 0, 0,
                 &g_sKentec320x240x16_SSD2119, 190, 135, 110, 24,
                 CANVAS_STYLE_TEXT, 0, 0, ClrSilver, &g_sFontCm20, "repeat",
                 0, 0),
};
tPushButtonWidget g_psPushButtons[] =
{
    RectangularButtonStruct(g_psPanels + 5, g_psPushButtons + 1, 0,
                            &g_sKentec320x240x16_SSD2119, 30, 35, 40, 40,
                            PB_STYLE_FILL | PB_STYLE_OUTLINE | PB_STYLE_TEXT,
                            ClrMidnightBlue, ClrBlack, ClrGray, ClrSilver,
                            &g_sFontCm22, "1", 0, 0, 0, 0, OnButtonPress),
    CircularButtonStruct(g_psPanels + 5, g_psPushButtons + 2, 0,
                         &g_sKentec320x240x16_SSD2119, 100, 55, 20,
                         PB_STYLE_FILL | PB_STYLE_OUTLINE | PB_STYLE_TEXT,
                         ClrMidnightBlue, ClrBlack, ClrGray, ClrSilver,
                         &g_sFontCm22, "3", 0, 0, 0, 0, OnButtonPress),
    RectangularButtonStruct(g_psPanels + 5, g_psPushButtons + 3, 0,
                            &g_sKentec320x240x16_SSD2119, 130, 30, 50, 50,
                            PB_STYLE_IMG | PB_STYLE_TEXT, 0, 0, 0, ClrSilver,
                            &g_sFontCm22, "5", g_pui8Blue50x50,
                            g_pui8Blue50x50Press, 0, 0, OnButtonPress),
    RectangularButtonStruct(g_psPanels + 5, g_psPushButtons + 4, 0,
                            &g_sKentec320x240x16_SSD2119, 30, 115, 40, 40,
                            (PB_STYLE_FILL | PB_STYLE_OUTLINE | PB_STYLE_TEXT |
                             PB_STYLE_AUTO_REPEAT), ClrMidnightBlue, ClrBlack,
                            ClrGray, ClrSilver, &g_sFontCm22, "2", 0, 0, 125,
                            25, OnButtonPress),
    CircularButtonStruct(g_psPanels + 5, g_psPushButtons + 5, 0,
                         &g_sKentec320x240x16_SSD2119, 100, 135, 20,
                         (PB_STYLE_FILL | PB_STYLE_OUTLINE | PB_STYLE_TEXT |
                          PB_STYLE_AUTO_REPEAT), ClrMidnightBlue, ClrBlack,
                         ClrGray, ClrSilver, &g_sFontCm22, "4", 0, 0, 125, 25,
                         OnButtonPress),
    RectangularButtonStruct(g_psPanels + 5, g_psPushButtonIndicators, 0,
                            &g_sKentec320x240x16_SSD2119, 130, 110, 50, 50,
                            (PB_STYLE_IMG | PB_STYLE_TEXT |
                             PB_STYLE_AUTO_REPEAT), 0, 0, 0, ClrSilver,
                            &g_sFontCm22, "6", g_pui8Blue50x50,
                            g_pui8Blue50x50Press, 125, 25, OnButtonPress),
};
#define NUM_PUSH_BUTTONS        (sizeof(g_psPushButtons) /   \
                                 sizeof(g_psPushButtons[0]))
uint32_t g_ui32ButtonState;

//*****************************************************************************
//
// The seventh panel, which contains a selection of radio buttons.
//
//*****************************************************************************
tContainerWidget g_psRadioContainers[];
tCanvasWidget g_psRadioButtonIndicators[] =
{
    CanvasStruct(g_psRadioContainers, g_psRadioButtonIndicators + 1, 0,
                 &g_sKentec320x240x16_SSD2119, 95, 62, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psRadioContainers, g_psRadioButtonIndicators + 2, 0,
                 &g_sKentec320x240x16_SSD2119, 95, 107, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psRadioContainers, 0, 0,
                 &g_sKentec320x240x16_SSD2119, 95, 152, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psRadioContainers + 1, g_psRadioButtonIndicators + 4, 0,
                 &g_sKentec320x240x16_SSD2119, 260, 62, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psRadioContainers + 1, g_psRadioButtonIndicators + 5, 0,
                 &g_sKentec320x240x16_SSD2119, 260, 107, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
    CanvasStruct(g_psRadioContainers + 1, 0, 0,
                 &g_sKentec320x240x16_SSD2119, 260, 152, 20, 20,
                 CANVAS_STYLE_IMG, 0, 0, 0, 0, 0, g_pui8LightOff, 0),
};
tRadioButtonWidget g_psRadioButtons1[] =
{
    RadioButtonStruct(g_psRadioContainers, g_psRadioButtons1 + 1, 0,
                      &g_sKentec320x240x16_SSD2119, 10, 50, 80, 45,
                      RB_STYLE_TEXT, 16, 0, ClrSilver, ClrSilver, &g_sFontCm20,
                      "One", 0, OnRadioChange),
    RadioButtonStruct(g_psRadioContainers, g_psRadioButtons1 + 2, 0,
                      &g_sKentec320x240x16_SSD2119, 10, 95, 80, 45,
                      RB_STYLE_TEXT, 16, 0, ClrSilver, ClrSilver, &g_sFontCm20,
                      "Two", 0, OnRadioChange),
    RadioButtonStruct(g_psRadioContainers, g_psRadioButtonIndicators, 0,
                      &g_sKentec320x240x16_SSD2119, 10, 140, 80, 45,
                      RB_STYLE_TEXT, 24, 0, ClrSilver, ClrSilver, &g_sFontCm20,
                      "Three", 0, OnRadioChange)
};
#define NUM_RADIO1_BUTTONS      (sizeof(g_psRadioButtons1) /   \
                                 sizeof(g_psRadioButtons1[0]))
tRadioButtonWidget g_psRadioButtons2[] =
{
    RadioButtonStruct(g_psRadioContainers + 1, g_psRadioButtons2 + 1, 0,
                      &g_sKentec320x240x16_SSD2119, 175, 50, 80, 45,
                      RB_STYLE_IMG, 16, 0, ClrSilver, 0, 0, 0, g_pui8Logo,
                      OnRadioChange),
    RadioButtonStruct(g_psRadioContainers + 1, g_psRadioButtons2 + 2, 0,
                      &g_sKentec320x240x16_SSD2119, 175, 95, 80, 45,
                      RB_STYLE_IMG, 24, 0, ClrSilver, 0, 0, 0, g_pui8Logo,
                      OnRadioChange),
    RadioButtonStruct(g_psRadioContainers + 1, g_psRadioButtonIndicators + 3,
                      0, &g_sKentec320x240x16_SSD2119, 175, 140, 80, 45,
                      RB_STYLE_IMG, 24, 0, ClrSilver, 0, 0, 0, g_pui8Logo,
                      OnRadioChange)
};
#define NUM_RADIO2_BUTTONS      (sizeof(g_psRadioButtons2) /   \
                                 sizeof(g_psRadioButtons2[0]))
tContainerWidget g_psRadioContainers[] =
{
    ContainerStruct(g_psPanels + 6, g_psRadioContainers + 1, g_psRadioButtons1,
                    &g_sKentec320x240x16_SSD2119, 5, 27, 148, 160,
                    CTR_STYLE_OUTLINE | CTR_STYLE_TEXT, 0, ClrGray, ClrSilver,
                    &g_sFontCm20, "Group One"),
    ContainerStruct(g_psPanels + 6, 0, g_psRadioButtons2,
                    &g_sKentec320x240x16_SSD2119, 167, 27, 148, 160,
                    CTR_STYLE_OUTLINE | CTR_STYLE_TEXT, 0, ClrGray, ClrSilver,
                    &g_sFontCm20, "Group Two")
};

//*****************************************************************************
//
// The eighth panel, which demonstrates the slider widget.
//
//*****************************************************************************
Canvas(g_sSliderValueCanvas, g_psPanels + 7, 0, 0,
       &g_sKentec320x240x16_SSD2119, 0, 0, 320, 240,
       CANVAS_STYLE_TEXT | CANVAS_STYLE_TEXT_OPAQUE, ClrBlack, 0, ClrSilver,
       &g_sFontCm24, 0,
       0, 0);

tSliderWidget g_psSliders[] =
{
    SliderStruct(g_psPanels + 7, g_psSliders + 1, 0,
                 &g_sKentec320x240x16_SSD2119, 13, 30, 15, 160, 0, 1000, 50,
                 (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
                  SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
                  ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),
    SliderStruct(g_psPanels + 7, g_psSliders + 2, 0,
                 &g_sKentec320x240x16_SSD2119, 30, 30, 15, 160, 0, 1000, 50,
                 (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
                  SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
                  ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),
    SliderStruct(g_psPanels + 7, g_psSliders + 3, 0,
                 &g_sKentec320x240x16_SSD2119, 48, 30, 15, 160, 0, 1000, 50,
                 (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
                 SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
                 ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),
    SliderStruct(g_psPanels + 7, g_psSliders + 4, 0,
                 &g_sKentec320x240x16_SSD2119, 66, 30, 15, 160, 0, 1000, 50,
                 (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
                 SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
                 ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),
    SliderStruct(g_psPanels + 7, g_psSliders + 5, 0,
                 &g_sKentec320x240x16_SSD2119, 84, 30, 15, 160, 0, 1000, 50,
                 (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
                 SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
                 ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),
    SliderStruct(g_psPanels + 7, g_psSliders + 6, 0,
                 &g_sKentec320x240x16_SSD2119, 102, 30, 15, 160, 0, 1000, 50,
                 (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
                 SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
                 ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 7, 0,
             &g_sKentec320x240x16_SSD2119, 120, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 8, 0,
             &g_sKentec320x240x16_SSD2119, 138, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 9, 0,
             &g_sKentec320x240x16_SSD2119, 156, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 10, 0,
             &g_sKentec320x240x16_SSD2119, 174, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 11, 0,
             &g_sKentec320x240x16_SSD2119, 192, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 12, 0,
             &g_sKentec320x240x16_SSD2119, 210, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 13, 0,
             &g_sKentec320x240x16_SSD2119, 228, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 14, 0,
             &g_sKentec320x240x16_SSD2119, 246, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 15, 0,
             &g_sKentec320x240x16_SSD2119, 264, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),

SliderStruct(g_psPanels + 7, g_psSliders + 16, 0,
             &g_sKentec320x240x16_SSD2119, 282, 30, 15, 160, 0, 1000, 50,
             (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
             SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
             ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),
/*SliderStruct(g_psPanels + 7, g_psSliders + 17, 0,
                 &g_sKentec320x240x16_SSD2119, 3, 30, 15, 160, 0, 100, 50,
                 (SL_STYLE_FILL | SL_STYLE_BACKG_FILL | SL_STYLE_VERTICAL |
                  SL_STYLE_OUTLINE | SL_STYLE_LOCKED), ClrCrimson,
                  ClrHoneydew, ClrSilver, 0, 0, 0, 0, 0, 0, 0),
*/
};

#define SLIDER_TEXT_VAL_INDEX   0
#define SLIDER_LOCKED_INDEX     2
#define SLIDER_CANVAS_VAL_INDEX 4

#define NUM_SLIDERS (sizeof(g_psSliders) / sizeof(g_psSliders[0]))

//*****************************************************************************
//
// An array of canvas widgets, one per panel.  Each canvas is filled with
// black, overwriting the contents of the previous panel.
//
//*****************************************************************************
tCanvasWidget g_psPanels[] =
{
    CanvasStruct(0, 0, &g_sIntroduction, &g_sKentec320x240x16_SSD2119, 0, 24,
                 320, 166, CANVAS_STYLE_FILL, ClrBlack, 0, 0, 0, 0, 0, 0),
    CanvasStruct(0, 0, &g_sPrimitives, &g_sKentec320x240x16_SSD2119, 0, 24,
                 320, 166, CANVAS_STYLE_FILL, ClrBlack, 0, 0, 0, 0, 0, 0),
    CanvasStruct(0, 0, &g_sCanvas1, &g_sKentec320x240x16_SSD2119, 0, 24, 320,
                 166, CANVAS_STYLE_FILL, ClrBlack, 0, 0, 0, 0, 0, 0),
    CanvasStruct(0, 0, g_psCheckBoxes, &g_sKentec320x240x16_SSD2119, 0, 24,
                 320, 166, CANVAS_STYLE_FILL, ClrBlack, 0, 0, 0, 0, 0, 0),
    CanvasStruct(0, 0, &g_sContainer1, &g_sKentec320x240x16_SSD2119, 0, 24,
                 320, 166, CANVAS_STYLE_FILL, ClrBlack, 0, 0, 0, 0, 0, 0),
    CanvasStruct(0, 0, g_psPushButtons, &g_sKentec320x240x16_SSD2119, 0, 24,
                 320, 166, CANVAS_STYLE_FILL, ClrBlack, 0, 0, 0, 0, 0, 0),
    CanvasStruct(0, 0, g_psRadioContainers, &g_sKentec320x240x16_SSD2119, 0,
                 24, 320, 166, CANVAS_STYLE_FILL, ClrBlack, 0, 0, 0, 0, 0, 0),
    CanvasStruct(0, 0, g_psSliders, &g_sKentec320x240x16_SSD2119, 0,
                 24, 320, 166, CANVAS_STYLE_FILL, ClrBlack, 0, 0, 0, 0, 0, 0),
};

//*****************************************************************************
//
// The number of panels.
//
//*****************************************************************************
#define NUM_PANELS              (sizeof(g_psPanels) / sizeof(g_psPanels[0]))

//*****************************************************************************
//
// The names for each of the panels, which is displayed at the bottom of the
// screen.
//
//*****************************************************************************
char *g_pcPanei32Names[] =
{
    "     Welcome     ",
    "     Welcome      ",
    "     Welcome     ",
    "     Welcome     ",
    "     Welcome     ",
    "     Welcome     ",
    "     Welcome     ",
    "     Welcome     ",
    "     S/W Update    "
};

//*****************************************************************************
//
// The buttons and text across the bottom of the screen.
//
//*****************************************************************************
RectangularButton(g_sPrevious, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 190,
                  50, 50, PB_STYLE_FILL, ClrBlack, ClrBlack, 0, ClrSilver,
                  &g_sFontCm20, "-", g_pui8Blue50x50, g_pui8Blue50x50Press, 0, 0,
                  OnPrevious);
                  
Canvas(g_sTitle, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 50, 190, 220, 50,
       CANVAS_STYLE_TEXT | CANVAS_STYLE_TEXT_OPAQUE, 0, 0, ClrSilver,
       &g_sFontCm20, 0, 0, 0);
       
RectangularButton(g_sNext, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 270, 190,
                  50, 50, PB_STYLE_IMG | PB_STYLE_TEXT, ClrBlack, ClrBlack, 0,
                  ClrSilver, &g_sFontCm20, "+", g_pui8Blue50x50,
                  g_pui8Blue50x50Press, 0, 0, OnNext);

//*****************************************************************************
//
// The panel that is currently being displayed.
//
//*****************************************************************************
uint32_t g_ui32Panel;

//*****************************************************************************
//
// Handles presses of the previous panel button.
//
//*****************************************************************************
void
OnPrevious(tWidget *psWidget)
{
    //
    // There is nothing to be done if the first panel is already being
    // displayed.
    //
    if(g_ui32Panel == 0)
    {
        return;
    }

    //
    // Remove the current panel.
    //
    WidgetRemove((tWidget *)(g_psPanels + g_ui32Panel));

    //
    // Decrement the panel index.
    //
    g_ui32Panel--;

    //
    // Add and draw the new panel.
    //
    WidgetAdd(WIDGET_ROOT, (tWidget *)(g_psPanels + g_ui32Panel));
    WidgetPaint((tWidget *)(g_psPanels + g_ui32Panel));

    //
    // Set the title of this panel.
    //
    CanvasTextSet(&g_sTitle, g_pcPanei32Names[g_ui32Panel]);
    WidgetPaint((tWidget *)&g_sTitle);

    //
    // See if this is the first panel.
    //
    if(g_ui32Panel == 0)
    {
        //
        // Clear the previous button from the display since the first panel is
        // being displayed.
        //
        PushButtonImageOff(&g_sPrevious);
        PushButtonTextOff(&g_sPrevious);
        PushButtonFillOn(&g_sPrevious);
        WidgetPaint((tWidget *)&g_sPrevious);
    }

    //
    // See if the previous panel was the last panel.
    //
    if(g_ui32Panel == (NUM_PANELS - 2))
    {
        //
        // Display the next button.
        //
        PushButtonImageOn(&g_sNext);
        PushButtonTextOn(&g_sNext);
        PushButtonFillOff(&g_sNext);
        WidgetPaint((tWidget *)&g_sNext);
    }

}

//*****************************************************************************
//
// Handles presses of the next panel button.
//
//*****************************************************************************
void
OnNext(tWidget *psWidget)
{
    //
    // There is nothing to be done if the last panel is already being
    // displayed.
    //
    if(g_ui32Panel == (NUM_PANELS - 1))
    {
        return;
    }

    //
    // Remove the current panel.
    //
    WidgetRemove((tWidget *)(g_psPanels + g_ui32Panel));

    //
    // Increment the panel index.
    //
    g_ui32Panel++;

    //
    // Add and draw the new panel.
    //
    WidgetAdd(WIDGET_ROOT, (tWidget *)(g_psPanels + g_ui32Panel));
    WidgetPaint((tWidget *)(g_psPanels + g_ui32Panel));

    //
    // Set the title of this panel.
    //
    CanvasTextSet(&g_sTitle, g_pcPanei32Names[g_ui32Panel]);
    WidgetPaint((tWidget *)&g_sTitle);

    //
    // See if the previous panel was the first panel.
    //
    if(g_ui32Panel == 1)
    {
        //
        // Display the previous button.
        //
        PushButtonImageOn(&g_sPrevious);
        PushButtonTextOn(&g_sPrevious);
        PushButtonFillOff(&g_sPrevious);
        WidgetPaint((tWidget *)&g_sPrevious);
    }

    //
    // See if this is the last panel.
    //
    if(g_ui32Panel == (NUM_PANELS - 1))
    {
        //
        // Clear the next button from the display since the last panel is being
        // displayed.
        //
        PushButtonImageOff(&g_sNext);
        PushButtonTextOff(&g_sNext);
        PushButtonFillOn(&g_sNext);
        WidgetPaint((tWidget *)&g_sNext);
    }

}

//*****************************************************************************
//
// Handles paint requests for the introduction canvas widget.
//
//*****************************************************************************
void
OnIntroPaint(tWidget *psWidget, tContext *psContext)
{
    //
    // Display the introduction text in the canvas.
    //
    GrContextFontSet(psContext, &g_sFontCm18);
    GrContextForegroundSet(psContext, ClrSilver);
    //GrStringDraw(psContext, "Welcome to Music Visualizer Demo", -1,
  //               0, 32, 0);
    //GrStringDraw(psContext, "By: Ankit Verma & Himanshu Verma", -1, 0, 50, 0);
    //GrImageDraw(psContext,
    //            g_dese_logo, 0, 120);

}

//*****************************************************************************
//
// Handles paint requests for the primitives canvas widget.
//
//*****************************************************************************
void
OnPrimitivePaint(tWidget *psWidget, tContext *psContext)
{
    uint32_t ui32Idx;
    tRectangle sRect;

    //
    // Draw a vertical sweep of lines from red to green.
    //
    for(ui32Idx = 0; ui32Idx <= 8; ui32Idx++)
    {
        GrContextForegroundSet(psContext,
                               (((((10 - ui32Idx) * 255) / 10) << ClrRedShift) |
                                (((ui32Idx * 255) / 10) << ClrGreenShift)));
        GrLineDraw(psContext, 115, 120, 5, 120 - (11 * ui32Idx));
    }

    //
    // Draw a horizontal sweep of lines from green to blue.
    //
    for(ui32Idx = 1; ui32Idx <= 10; ui32Idx++)
    {
        GrContextForegroundSet(psContext,
                               (((((10 - ui32Idx) * 255) / 10) <<
                                 ClrGreenShift) |
                                (((ui32Idx * 255) / 10) << ClrBlueShift)));
        GrLineDraw(psContext, 115, 120, 5 + (ui32Idx * 11), 29);
    }

    //
    // Draw a filled circle with an overlapping circle.
    //
    GrContextForegroundSet(psContext, ClrBrown);
    GrCircleFill(psContext, 185, 69, 40);
    GrContextForegroundSet(psContext, ClrSkyBlue);
    GrCircleDraw(psContext, 205, 99, 30);

    //
    // Draw a filled rectangle with an overlapping rectangle.
    //
    GrContextForegroundSet(psContext, ClrSlateGray);
    sRect.i16XMin = 20;
    sRect.i16YMin = 100;
    sRect.i16XMax = 75;
    sRect.i16YMax = 160;
    GrRectFill(psContext, &sRect);
    GrContextForegroundSet(psContext, ClrSlateBlue);
    sRect.i16XMin += 40;
    sRect.i16YMin += 40;
    sRect.i16XMax += 30;
    sRect.i16YMax += 28;
    GrRectDraw(psContext, &sRect);

    //
    // Draw a piece of text in fonts of increasing size.
    //
    GrContextForegroundSet(psContext, ClrSilver);
    GrContextFontSet(psContext, &g_sFontCm14);
    GrStringDraw(psContext, "Strings", -1, 125, 110, 0);
    GrContextFontSet(psContext, &g_sFontCm18);
    GrStringDraw(psContext, "Strings", -1, 145, 124, 0);
    GrContextFontSet(psContext, &g_sFontCm22);
    GrStringDraw(psContext, "Strings", -1, 165, 142, 0);
    GrContextFontSet(psContext, &g_sFontCm24);
    GrStringDraw(psContext, "Strings", -1, 185, 162, 0);

    //
    // Draw an image.
    //
    GrImageDraw(psContext, g_pui8Logo, 270, 80);
}

//*****************************************************************************
//
// Handles paint requests for the canvas demonstration widget.
//
//*****************************************************************************
void
OnCanvasPaint(tWidget *psWidget, tContext *psContext)
{
    uint32_t ui32Idx;

    //
    // Draw a set of radiating lines.
    //
    GrContextForegroundSet(psContext, ClrGoldenrod);
    for(ui32Idx = 50; ui32Idx <= 180; ui32Idx += 10)
    {
        GrLineDraw(psContext, 210, ui32Idx, 310, 230 - ui32Idx);
    }

    //
    // Indicate that the contents of this canvas were drawn by the application.
    //
    GrContextFontSet(psContext, &g_sFontCm12);
    GrStringDrawCentered(psContext, "App Drawn", -1, 260, 50, 1);
}

//*****************************************************************************
//
// Handles change notifications for the check box widgets.
//
//*****************************************************************************
void
OnCheckChange(tWidget *psWidget, uint32_t bSelected)
{
    uint32_t ui32Idx;

    //
    // Find the index of this check box.
    //
    for(ui32Idx = 0; ui32Idx < NUM_CHECK_BOXES; ui32Idx++)
    {
        if(psWidget == (tWidget *)(g_psCheckBoxes + ui32Idx))
        {
            break;
        }
    }

    //
    // Return if the check box could not be found.
    //
    if(ui32Idx == NUM_CHECK_BOXES)
    {
        return;
    }

    //
    // Set the matching indicator based on the selected state of the check box.
    //
    CanvasImageSet(g_psCheckBoxIndicators + ui32Idx,
                   bSelected ? g_pui8LightOn : g_pui8LightOff);
    WidgetPaint((tWidget *)(g_psCheckBoxIndicators + ui32Idx));

}

//*****************************************************************************
//
// Handles press notifications for the push button widgets.
//
//*****************************************************************************
void
OnButtonPress(tWidget *psWidget)
{
    uint32_t ui32Idx;

    //
    // Find the index of this push button.
    //
    for(ui32Idx = 0; ui32Idx < NUM_PUSH_BUTTONS; ui32Idx++)
    {
        if(psWidget == (tWidget *)(g_psPushButtons + ui32Idx))
        {
            break;
        }
    }

    //
    // Return if the push button could not be found.
    //
    if(ui32Idx == NUM_PUSH_BUTTONS)
    {
        return;
    }

    //
    // Toggle the state of this push button indicator.
    //
    g_ui32ButtonState ^= 1 << ui32Idx;

    //
    // Set the matching indicator based on the selected state of the check box.
    //
    CanvasImageSet(g_psPushButtonIndicators + ui32Idx,
                   (g_ui32ButtonState & (1 << ui32Idx)) ? g_pui8LightOn :
                   g_pui8LightOff);
    WidgetPaint((tWidget *)(g_psPushButtonIndicators + ui32Idx));

}

//*****************************************************************************
//
// Handles notifications from the slider controls.
//
//*****************************************************************************
void
OnSliderChange(tWidget *psWidget, int32_t i32Value)
{
    static char pcCanvasText[5];
    static char pcSliderText[5];

    //
    // Is this the widget whose value we mirror in the canvas widget and the
    // locked slider?
    //
    if(psWidget == (tWidget *)&g_psSliders[SLIDER_CANVAS_VAL_INDEX])
    {
        //
        // Yes - update the canvas to show the slider value.
        //
        usprintf(pcCanvasText, "%3d%%", i32Value);
        CanvasTextSet(&g_sSliderValueCanvas, pcCanvasText);
        WidgetPaint((tWidget *)&g_sSliderValueCanvas);

        //
        // Also update the value of the locked slider to reflect this one.
        //
        SliderValueSet(&g_psSliders[SLIDER_LOCKED_INDEX], i32Value);
        WidgetPaint((tWidget *)&g_psSliders[SLIDER_LOCKED_INDEX]);
    }

    if(psWidget == (tWidget *)&g_psSliders[SLIDER_TEXT_VAL_INDEX])
    {
        //
        // Yes - update the canvas to show the slider value.
        //
        usprintf(pcSliderText, "%3d%%", i32Value);
        SliderTextSet(&g_psSliders[SLIDER_TEXT_VAL_INDEX], pcSliderText);
        WidgetPaint((tWidget *)&g_psSliders[SLIDER_TEXT_VAL_INDEX]);
    }
}

//*****************************************************************************
//
// Handles change notifications for the radio button widgets.
//
//*****************************************************************************
void
OnRadioChange(tWidget *psWidget, uint32_t bSelected)
{
    uint32_t ui32Idx;

    //
    // Find the index of this radio button in the first group.
    //
    for(ui32Idx = 0; ui32Idx < NUM_RADIO1_BUTTONS; ui32Idx++)
    {
        if(psWidget == (tWidget *)(g_psRadioButtons1 + ui32Idx))
        {
            break;
        }
    }

    //
    // See if the radio button was found.
    //
    if(ui32Idx == NUM_RADIO1_BUTTONS)
    {
        //
        // Find the index of this radio button in the second group.
        //
        for(ui32Idx = 0; ui32Idx < NUM_RADIO2_BUTTONS; ui32Idx++)
        {
            if(psWidget == (tWidget *)(g_psRadioButtons2 + ui32Idx))
            {
                break;
            }
        }

        //
        // Return if the radio button could not be found.
        //
        if(ui32Idx == NUM_RADIO2_BUTTONS)
        {
            return;
        }

        //
        // Sind the radio button is in the second group, offset the index to
        // the indicators associated with the second group.
        //
        ui32Idx += NUM_RADIO1_BUTTONS;
    }

    //
    // Set the matching indicator based on the selected state of the radio
    // button.
    //
    CanvasImageSet(g_psRadioButtonIndicators + ui32Idx,
                   bSelected ? g_pui8LightOn : g_pui8LightOff);
    WidgetPaint((tWidget *)(g_psRadioButtonIndicators + ui32Idx));

}

//*****************************************************************************
//
// A simple demonstration of the features of the TivaWare Graphics Library.
//
//*****************************************************************************
int
main(void)
{
    tContext sContext;
    tRectangle sRect;
    uint32_t ui32SysClock;

    //
    // The FPU should be enabled because some compilers will use floating-
    // point registers, even for non-floating-point code.  If the FPU is not
    // enabled this will cause a fault.  This also ensures that floating-
    // point operations could be added to this application and would work
    // correctly and use the hardware floating-point unit.  Finally, lazy
    // stacking is enabled for interrupt handlers.  This allows floating-
    // point instructions to be used within interrupt handlers, but at the
    // expense of extra stack usage.
    //
    FPUEnable();
    FPULazyStackingEnable();

    //
    // Set the clock to 40Mhz derived from the PLL and the external oscillator
    //
    ROM_SysCtlClockSet(SYSCTL_SYSDIV_5 | SYSCTL_USE_PLL | SYSCTL_XTAL_16MHZ |
                       SYSCTL_OSC_MAIN);

    ui32SysClock = ROM_SysCtlClockGet();

    //
    // Initialize the display driver.
    //
    Kentec320x240x16_SSD2119Init(ui32SysClock);

    //
    // Initialize the graphics context.
    //
    GrContextInit(&sContext, &g_sKentec320x240x16_SSD2119);

    //
    // Fill the top 24 rows of the screen with blue to create the banner.
    //
    sRect.i16XMin = 0;
    sRect.i16YMin = 0;
    sRect.i16XMax = GrContextDpyWidthGet(&sContext) - 1;
    sRect.i16YMax = 23;
    GrContextForegroundSet(&sContext, ClrDarkSeaGreen);
    GrRectFill(&sContext, &sRect);

    //
    // Put a white box around the banner.
    //
    GrContextForegroundSet(&sContext, ClrWhite);
    GrRectDraw(&sContext, &sRect);

    //
    // Put the application name in the middle of the banner.
    //
    GrContextFontSet(&sContext, &g_sFontCm20);
    GrStringDrawCentered(&sContext, "Music Visualizer", -1,
                         GrContextDpyWidthGet(&sContext) / 2, 8, 0);

    //
    // Configure and enable uDMA
    //
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UDMA);
    SysCtlDelay(10);
    uDMAControlBaseSet(&psDMAControlTable[0]);
    uDMAEnable();

    //
    // Initialize the touch screen driver and have it route its messages to the
    // widget tree.
    //
    TouchScreenInit(ui32SysClock);
    TouchScreenCallbackSet(WidgetPointerMessage);

    //
    // Add the title block and the previous and next buttons to the widget
    // tree.
    //
    WidgetAdd(WIDGET_ROOT, (tWidget *)&g_sPrevious);
    WidgetAdd(WIDGET_ROOT, (tWidget *)&g_sTitle);
    WidgetAdd(WIDGET_ROOT, (tWidget *)&g_sNext);

    //
    // Add the first panel to the widget tree.
    //
    g_ui32Panel = 0;
    WidgetAdd(WIDGET_ROOT, (tWidget *)g_psPanels);
    CanvasTextSet(&g_sTitle, g_pcPanei32Names[0]);

    //
    // Issue the initial paint request to the widgets.
    //
    WidgetPaint(WIDGET_ROOT);

    //
    // Loop forever handling widget messages.
    //


    complex float s[N];


    while(1)
    {
int i,p,k;
       /* if(i==100)
            i=0;
        for(k=1;k<=17;k++)
        {
            SliderValueSet(g_psSliders+k, i);
            WidgetPaint(g_psSliders+k);
            delayMs(1);
        }
        i++;*/
        for (p=0;p<100;p++)
        {
            fft(a[p],N,s);

        for(i=0;i<N;i++)
        {
            absfft[i]=abs(a[p][i]);
        }
        for(k=0;k<16;k++)
        {
            SliderValueSet(g_psSliders+k, absfft[k]);
            WidgetPaint(g_psSliders+k);

        }
        delayMs(1000);
        WidgetMessageQueueProcess();
        }
        //
        // Process any messages in the widget message queue.
        //

    }
}
