#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include <string.h>


#define BUFFER_SIZE 100
#define ADMIN_MOB "9748659923"

void PRINT_UART(char*);
int Send_SMS(char*, char*, int);
void init_ADC(void);
void init_LED(void);
void Init_PIR_sensor(void);
int Send_PPM_toServer(int);
void get_server_data(void);
void Init_GSM(void);
int rcv_data(int);
void delay(int);
void init_Uart5(void);
void init_Uart0(void);
void send(char*);
void PRINT_UART(char*);
void ADMIN_reply(void);
void read_new_SMS(int, int);
void DOCTOR_reply(void);

char BUFFER[1000];
char DETAILS[100] = "";
int assign = 0, mobile_set = 0, details_set = 0;
char SM[2];
char index_sms[4];
char recent_cmd[100];
char MOB_NUMBER[11];
char DOCTOR_MOB[11];
char stri[] = "";



void init_ADC()
{
    SYSCTL_RCGCGPIO_R |= 0x10;
    SYSCTL_RCGCADC_R |= 1;

    GPIO_PORTE_AFSEL_R |= 8;
    GPIO_PORTE_DEN_R &= ~8;
    GPIO_PORTE_AMSEL_R |= 8;
    ADC0_ACTSS_R &= ~8;
    ADC0_EMUX_R &= ~0xF000;
    ADC0_SSMUX3_R = 0;
    ADC0_SSCTL3_R |= 6;
    ADC0_ACTSS_R |= 8;
}


void init_LED()
{
    SYSCTL_RCGC2_R |= 0x00000020;
    GPIO_PORTF_LOCK_R = 0x4C4F434B;
    GPIO_PORTF_CR_R = 0x11;
    GPIO_PORTF_DIR_R = 0x0E;
    GPIO_PORTF_DEN_R = 0x1F;
    GPIO_PORTF_PUR_R = 0x11;

}

void Init_PIR_sensor()
{
    SYSCTL_RCGC2_R |= 0x000000010;

    GPIO_PORTE_DEN_R = 0xFF;
    GPIO_PORTE_DIR_R &= 0xFB;
}


int Send_PPM_toServer(int temp)
{
    int PPM;
    PPM = temp;
    char stri[] = "";
    int j = 0;
    char url[] ="GET https://api.thingspeak.com/update?api_key=46DGOURZI9UG3ZYY&field1=";
    itoa(PPM, stri, 10);
    char val;

    while (1)
    {

        if (UARTCharsAvail(UART5_BASE))
        {
            val = UARTCharGet(UART5_BASE);
            UARTCharPut(UART0_BASE, val);

        }
        else
        {

            switch (j)
            {
            case 0:
                delay(500);
                send("AT+CIPSHUT\r");
                j++;
                break;
            case 1:
                delay(500);
                send("AT+CIPMUX=0\r");
                j++;
                break;
            case 2:
                delay(1000);
                send("AT+CPAS\r");
                j++;
                break;
            case 3:
                delay(2000);
                send("AT+CSTT=\"portalnmms\",\"\",\"\"\r");

                j++;
                break;
            case 4:
                delay(2000);
                send("AT+CIICR\r");
                j++;
                break;
            case 5:
                delay(2000);
                send("AT+CIFSR\r");
                j++;
                break;
            case 6:
                delay(1000);
                send("AT+CIPQSEND=0\r");
                j++;
                break;

            case 7:
                delay(1000);
                send("AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",\"80\"\r");
                j++;
                break;
            case 8:
                delay(3000);
                send("AT+CIPSEND");
                UARTCharPut(UART5_BASE, '\r');
                j++;
                break;
            case 9:
                delay(1000);
                send(url);
                send(stri);
                send("\n\r");
                UARTCharPut(UART5_BASE, (char) 26);
                j++;
                break;
            default:
                delay(3000);
                return 0;

            }

        }
    }
}



int Send_SMS(char *message, char mob[], int n)
{

    char CMGS1[] = "AT+CMGS=\"";
    char CMGS2[] = "\"\r";

    int i = 0;

    char val;
    int j = 0;
    while (1)
    {

        if (UARTCharsAvail(UART5_BASE))
        {
            val = UARTCharGet(UART5_BASE);
            UARTCharPut(UART0_BASE, val);

        }
        else
        {

            switch (j)
            {
            case 0:
            {
                delay(500);
                send("AT+CFUN=1\r");
                j++;
            }
                break;
            case 1:
                delay(500);
                send("AT+CMGF=1\r");
                j++;
                break;
            case 2:
                delay(1000);
                send(CMGS1);
                send(mob);
                send(CMGS2);
                j++;
                break;

            case 3:
                delay(1000);
                send(message);
                UARTCharPut(UART5_BASE, (char) 26);
                j++;
                break;
            default:
                delay(n);
                return 0;

            }

        }
    }

}


void get_server_data()
{

    int j = 0;
    char url[] =
            "GET https://api.thingspeak.com/channels/1699914/fields/1.csv?api_key=4PK4IMI9E7U3RLFS&results=30";

    char val;

    while (1)
    {

        if (UARTCharsAvail(UART5_BASE))
        {
            val = UARTCharGet(UART5_BASE);
            UARTCharPut(UART0_BASE, val);

        }
        else
        {

            switch (j)
            {
            case 0:
            {
                delay(500);
                send("AT+CIPSHUT\r");
                j++;
            }
                break;
            case 1:
                delay(500);
                send("AT+CIPMUX=0\r");
                j++;
                break;
            case 2:
                delay(500);
                send("AT+CPAS\r");
                j++;
                break;
            case 3:
                delay(1000);
                send("AT+CSTT=\"portalnmms\",\"\",\"\"\r");
                j++;
                break;
            case 4:
                delay(1000);
                send("AT+CIICR\r");
                j++;
                break;
            case 5:
                delay(2000);
                send("AT+CIFSR\r");
                j++;
                break;
            case 6:
                delay(1000);
                send("AT+CIPQSEND=0\r");
                j++;
                break;

            case 7:
                delay(500);
                send("AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",\"80\"\r");
                j++;
                break;
            case 8:
                delay(3000);
                send("AT+CIPSEND");
                UARTCharPut(UART5_BASE, '\r');
                j++;
                break;
            case 9:
                delay(500);
                send(url);

                send("\n\r");
                UARTCharPut(UART5_BASE, (char) 26);
                j++;
                break;
            default:
                rcv_data(5000);
                return;

            }

        }
    }

}



void Init_GSM()
{
    send("AT\r");
    delay(200);
    send("AT+IPR=9600\r");
    delay(2000);
    send("AT+CMGD=?\r");
    delay(1000);
    send("AT+CPMS=\"");
    send("ME");
    send("\"\r");
    delay(1000);
    send("AT+CMGD=61\r");
    delay(200);
    send("AT+CMGD=62\r");
    delay(200);
    send("AT+CMGD=63\r");
    delay(200);
    send("AT+CMGD=64\r");
    delay(200);
    send("AT+CMGD=65\r");
    delay(200);

}



void main()
{
    int flag = 0, A_status, D_status, flag_t, count = 0;
    long unsigned int i = 0;
    char stri[] = "";
    int outOfRange = 0;
    volatile int result;
    char val;
    int size;

    Init_PIR_sensor();
    init_LED();
    init_ADC();
    init_Uart0();
    init_Uart5();
    Init_GSM();

    Send_SMS("ASSIGN DOCTOR MOBILE NUMBER and PATIENT DETAILS!",
    ADMIN_MOB,
             3000);

    while (1)
    {

        if (UARTCharsAvail(UART5_BASE))
        {
            read_new_SMS(1, 1500);
            send("AT+CMGF=1\r");
            delay(800);
            send("AT+CPMS=\"");
            send(SM);
            send("\"\r");
            delay(1000);
            send("AT+CMGR=");
            send(index_sms);
            UARTCharPut(UART5_BASE, '\r');
            read_new_SMS(2, 1500);
            if (strcmp(ADMIN_MOB, MOB_NUMBER) == 0)
            {
                ADMIN_reply();

            }
            else if ((strcmp(DOCTOR_MOB, MOB_NUMBER) == 0) && mobile_set == 1
                    && details_set == 1)
            {

                DOCTOR_reply();
            }
            delay(500);
            send("AT+CMGD=62\r");
            delay(200);
            send("AT+CMGD=63\r");
            delay(200);
            send("AT+CMGD=64\r");
            delay(200);
            send("AT+CMGD=65\r");
            delay(200);

        }

        else if (mobile_set == 1 && details_set == 1)
        {

            i++;

            ADC0_PSSI_R |= 8;
            while ((ADC0_RIS_R & 8) == 0)
                ;
            result = (ADC0_SSFIFO3_R) & 0xFFF; /* read conversion result */

            result = result - 2000;
            result = result * 20;

            bzero(stri, sizeof(stri));
            itoa(result, stri, 10);
            PRINT_UART(stri);

            if (result > 1700 && flag == 0)
            {
                count++;
                flag = 1;
            }
            else if (result < 1100)
            {
                flag = 0;
            }

            ADC0_ISC_R = 8;

            if (i == 4000)
            {
                bzero(stri, sizeof(stri));
                itoa(count*3, stri, 10);
                PRINT_UART("PULSE RATE::");
                PRINT_UART(stri);
                delay(1000);

                count = count * 3;

                if (count < 40 || count > 120)
                {



                    if (outOfRange == 2)
                    {
                        delay(500);
                        send("ATD");
                        send(DOCTOR_MOB);
                        UARTCharPut(UART5_BASE, ';');
                        UARTCharPut(UART5_BASE, '\r');

                        delay(20000);
                        outOfRange = 0;
                    }
                }
                    Send_PPM_toServer(count);

                count = 0;

                i = 0;

            }

        }

        GPIO_PORTF_DATA_R = GPIO_PORTE_DATA_R & 0X04;
    }

}



void DOCTOR_reply()
{

    if (strcmp(recent_cmd, "GET_SERVER_DATA") == 0)
    {
        get_server_data();
        Send_SMS(BUFFER, DOCTOR_MOB, 2000);
    }
    else if (strcmp(recent_cmd, "PATIENT_DETAILS") == 0)
    {
        Send_SMS(DETAILS, DOCTOR_MOB, 2000);
    }

}



void ADMIN_reply()
{

    int i = 0;
    char temp[] = "";
    while (recent_cmd[i] != '_')
    {
        temp[i] = recent_cmd[i];
        i++;
    }
    temp[i] = '\0';
    i = 0;

    if (strcmp(temp, "CNG") == 0)
    {
        while (i < 10)
        {
            DOCTOR_MOB[i] = recent_cmd[i + 4];
            i++;
        }

        DOCTOR_MOB[i] = '\0';
        Send_SMS("DOCTOR NUMBER CHANGED", ADMIN_MOB, 1500);
        Send_SMS(
                "USE #GET_SERVER_DATA#: TO GET DATA FROM SERVER,#PATIENT_DETAILS# TO GET DETAILS",
                DOCTOR_MOB, 2000);
        mobile_set = 1;
        if (details_set == 1)
        {
            Send_SMS(DETAILS, DOCTOR_MOB, 2000);
        }
    }
    else if (strcmp(temp, "SET") == 0)
    {
        i = 0;
        while (recent_cmd[i + 4] != '\0')
        {
            DETAILS[i] = recent_cmd[i + 4];
            i++;
        }
        DETAILS[i] = '\0';
        Send_SMS("PATIENT DETAILS ENTERED", ADMIN_MOB, 1500);
        if (mobile_set == 1)
        {
            Send_SMS(DETAILS, DOCTOR_MOB, 2000);
        }
        details_set = 1;
    }

    return;
}



void read_new_SMS(int mux, int n)
{
    char val;
    int i, j;
    int clm = 0;

    for (i = 0; i < n; i++)
    {
        for (j = 0; j < 3180; j++)
        {
            GPIO_PORTF_DATA_R = GPIO_PORTE_DATA_R & 0X04;
            if (UARTCharsAvail(UART5_BASE))
            {
                val = UARTCharGet(UART5_BASE);
                UARTCharPut(UART0_BASE, val);
                BUFFER[clm] = val;

                clm++;

            }
        }
    }

    if (mux == 1)
    {
        clm = clm - 2;
        index_sms[2] = '\0';
        index_sms[1] = BUFFER[--clm];
        index_sms[0] = BUFFER[--clm];
        clm = clm - 2;
        SM[2] = '\0';
        SM[1] = BUFFER[--clm];
        SM[0] = BUFFER[--clm];
    }
    else if (mux == 2)
    {
        char *token_rx = strtok(BUFFER, "#");
        int p = 0;
        token_rx = strtok(NULL, " ");

        while (token_rx[p] != '#')
        {
            recent_cmd[p] = token_rx[p];
            p++;
        }
        recent_cmd[p] = '\0';

        char *token_m = strtok(BUFFER, ",");
        token_m = strtok(NULL, " ");
        for (int k = 0; k < 10; k++)
        {
            MOB_NUMBER[k] = token_m[4 + k];
        }
        MOB_NUMBER[10] = '\0';

    }

}




void PRINT_UART(char *s)
{
    int i = 0;
    while (s[i] != '\0')
    {

        {
            UARTCharPut(UART0_BASE, s[i]);
        }

        i++;
    }
    UARTCharPut(UART0_BASE, '\n');
    UARTCharPut(UART0_BASE, '\r');

}



void send(char *s)
{
    int i = 0;
    while (s[i] != '\0')
    {

        {
            GPIO_PORTF_DATA_R = GPIO_PORTE_DATA_R & 0X04;
            UARTCharPut(UART5_BASE, s[i]);
        }

        i++;
    }

}



void init_Uart0()
{
    SysCtlClockSet(
    SYSCTL_SYSDIV_5 | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN | SYSCTL_XTAL_16MHZ);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

    UARTConfigSetExpClk(
            UART0_BASE, SysCtlClockGet(), 9600,
            (0x00000060 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
}



void init_Uart5()
{

    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART5);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);

    GPIOPinConfigure(GPIO_PE4_U5RX);
    GPIOPinConfigure(GPIO_PE5_U5TX);
    GPIOPinTypeUART(GPIO_PORTE_BASE, GPIO_PIN_4 | GPIO_PIN_5);

    UARTConfigSetExpClk(
            UART5_BASE, SysCtlClockGet(), 9600,
            (0x00000060 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
}




void delay(int n)
{
    char val;
    int result;
    int i, j;
    for (i = 0; i < n; i++)
    {
        for (j = 0; j < 3180; j++)
        {
            if (UARTCharsAvail(UART5_BASE))
            {
                val = UARTCharGet(UART5_BASE);
                UARTCharPut(UART0_BASE, val);

            }
            GPIO_PORTF_DATA_R = GPIO_PORTE_DATA_R & 0X04;

        }

    }
}



int rcv_data(int n)
{
    char val;
    int i, j;
    int row = 0, clm = 0;

    for (i = 0; i < n; i++)
    {
        for (j = 0; j < 3180; j++)
        {
            if (UARTCharsAvail(UART5_BASE))
            {
                val = UARTCharGet(UART5_BASE);
                UARTCharPut(UART0_BASE, val);
                if ((val != (char) 26 || val != '\r' || val != '\n'
                        || val != ' ') && i > 200)
                {
                    BUFFER[clm] = val;

                    clm++;
                }

            }
        }
        GPIO_PORTF_DATA_R = GPIO_PORTE_DATA_R & 0X04;
    }

    clm--;
    return clm;

}

