
/////////////////////////////////////////



#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <string.h>

#define SampleSize 1024
#define Fs 16384


#include "delay.h"

#include "UART.h"


volatile int8_t ScreenDispVals[8];

volatile int8_t Samples[SampleSize];

volatile uint16_t samplesRead = 0;

//char tempVal[]="a\r\n";

void UART_debug(int a)
{
    char numStr[7];
    numStr[5]=10;
    numStr[6]=13;
    if(a<0)
    {   numStr[0]= '-';
        a=a*-1;
    }
    else
    {   numStr[0]= '0';}

    numStr[1]= (a/1000)%10+48;
    numStr[2]= (a/100)%10+48;
    numStr[3]= (a/10)%10+48;
    numStr[4]= a%10+48;

    UART_Write(7, numStr);
    delayUs(600);

}

int main()
{
    UART_Init(115200);
    UART_debug(1234);


        LEDstripInit();

        int8_t A[] = {0, 1, 2, 3, 4, 5, 6, 7};

        //char B[] = {15, 10, 5, 0, 7, 9, 11, 15};
        //char C[] = {6, 8, 0, 2, 12, 15, 2, 5};
        //char D[] = {8, 7, 6, 5, 4, 3, 2, 1};



        //UART_Write(strlen(tempVal), tempVal);

        //screenUpdate(A);
        //delayMs(1000);
        //screenUpdate(B);
        //delayMs(1000);
        //screenUpdate(C);
        //delayMs(1000);
        //screenUpdate(D);
        //delayMs(1000);



        SYSCTL_RCGC2_R |= 0x00000010; // enable clock to GPIO E at clock gating control register
        SYSCTL_RCGCGPIO_R |= 0x10; // enable clock to PE (AIN0 is on PE3)

        GPIO_PORTE_AFSEL_R |= 8;   // enable alternate function
        GPIO_PORTE_DEN_R &= ~8;    // disable digital function
        GPIO_PORTE_AMSEL_R |= 8;   // enable analog function


        // enable clocks
        SYSCTL_RCGCADC_R |= 1;       // enable clock to ADC0
        SYSCTL_RCGCWTIMER_R |= 1;    // enable clock to WTimer Block 0

        // initialize ADC0
        ADC0_ACTSS_R &= ~8;          // disable SS3 during configuration
        ADC0_EMUX_R &= ~0xF000;
        ADC0_EMUX_R |= 0x5000;       // timer trigger conversion seq 0

        ADC0_SSMUX3_R = 0;           // get input from channel 0 (PE3)
        ADC0_SSCTL3_R |= 0x06;       // don't take chip temperature, set flag at 1st sample
        ADC0_ACTSS_R |= 8;           // enable ADC0 sequencer 3

        // initialize wtimer 0 to trigger ADC at 8192 sample/sec

        uint32_t countLoad = 16000000/Fs;
        WTIMER0_CTL_R = 0;           // disable WTimer before initialization
        WTIMER0_CFG_R = 0x04;        // 32-bit option
        WTIMER0_TAMR_R = 0x02;       // periodic mode and down-counter
        WTIMER0_TAILR_R = countLoad;  // WTimer A interval load value reg
        WTIMER0_CTL_R |= 0x20;       // timer triggers ADC
        WTIMER0_CTL_R |= 0x01;       // enable WTimer A after initialization


        ADC0_ISC_R = 0xFF; //clear any pending interrupt at ADC
        ADC0_IM_R = 0x08;


        NVIC_PRI4_R = (NVIC_PRI4_R & 0xFFFF1FFF) | 0x00002000; //  priority 1
        NVIC_EN0_R = 0x00020000;        //  Enable interrupt in NVIC

        __asm ("    CPSIE  I\n"); //enable interrupts



        while(1)
        {
            if (samplesRead == SampleSize)

                {
                    __asm ("    CPSID  I\n"); //disable interrupts
                    //UART_Write(strlen(tempVal), tempVal);
                    samplesRead = 0;

                    int16_t interSum=0;

                    int avgSize = SampleSize/8;


                    for (int j=0; j<8; j++)
                    {

                        interSum = 0;
                        for (int i=avgSize*j; i< avgSize*(j+1); i++)
                        {
                            //UART_debug(Samples[i]);
                            if(Samples[i] >= 0)
                                interSum = interSum + Samples[i]/8;
                            else
                                interSum = interSum - (Samples[i]/8);

                        }
                        interSum = interSum/avgSize;


                        A[j]=interSum;
                        //UART_debug((int)A[j]);
                        //delayMs(10);

                    }

                   // A[0] = Samples[0]/16+8;
                   // A[1] = Samples[128]/16+8;
                   // A[2] = Samples[256]/16+8;
                   // A[3] = Samples[384]/16+8;
                  //  A[4] = Samples[512]/16+8;
                   // A[5] = Samples[640]/16+8;
                   // A[6] = Samples[768]/16+8;
                   // A[6] = Samples[640]/16+8;
                   // A[7] = Samples[896]/16+8;

                    //UART_debug((Samples[0]));

                    screenUpdate(A);

                    __asm ("    CPSIE  I\n"); //enable interrupts

                }
        }

}


void ADC0_SS3_ISR(void)
{
    volatile int voltage;
    voltage = ADC0_SSFIFO3_R;
    ADC0_ISC_R = 8;          // clear completion flag
    //UART_Write(strlen(tempVal), tempVal);
    Samples[samplesRead] = (voltage-1400)/10.5 ; // to remove bias, and get in -127 to 127 range
    //UART_debug((voltage-1560)/10.5);
    samplesRead++;

}





