#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>


int UART_Init(int iBaudRate)
{
        int I_BR = (int)(1000000/iBaudRate); //calculate integer part of baud rate divider
        float F_BR_dec = ((1000000.0/(float)iBaudRate) - I_BR)*64+0.5; //calculate fractional part of baud rate divider and scale it
        int F_BR = (int)F_BR_dec; //scaled integer count for fractional part of BR divider

        int LineControlVal=0x70;
        //Defaults taken:
        //Word length = 8 bits hence bits 5 and 6 are 1 and 1
        //FIFO enabled hence bit 4 is 1
        //Stop bits length = 1 bit hence bit 3 is 0
        //No break hence bit 0 is 0
        //Hence initial value assigned as 0x70

        int CTLval = 0x301; //without loopback, just enable Rx Tx and UART

       //No parity used

        SYSCTL_RCGCUART_R |= 0x01; //give clock to uart 0
        SYSCTL_RCGCGPIO_R |= 0x01; //give clock to port A where uart 0 rx and tx exist (PA0, PA1)
        UART0_CTL_R = 0x0000; //disable uart0 before configuration
        UART0_IBRD_R = I_BR; //integer part of baud rate divider
        UART0_FBRD_R = F_BR; //fractional part of baud rate divider

        UART0_LCRH_R = LineControlVal;

        UART0_CTL_R = CTLval;

        GPIO_PORTA_DEN_R |= 0x03; //set PA0 and PA1 as digital pins
        GPIO_PORTA_AFSEL_R |= 0x03; //set PA0 and PA1 as alternate function instead of GPIO(enabled)
        GPIO_PORTA_PCTL_R &= 0xFFFFFF00;
        GPIO_PORTA_PCTL_R |= 0x00000011; //select type of alternate function (binary 0001 is for UART in each 4 bits for each pin)
        GPIO_PORTA_AMSEL_R &= ~0x03; //disable analog functionality by clearing pins PA0 and PA1


        UART0_IFLS_R = 0x10; //8 byte water level
        UART0_IM_R = 0x00000050; //Rx FIFO fill interrupt and Rx timeout enabled
        UART0_ICR_R = 0x00000050; //clear interrupt

        NVIC_PRI1_R = (NVIC_PRI1_R & 0xFFFF1FFF) | 0x0000A000; // priority 5
        NVIC_EN0_R = 0x00000020;        // Enable interrupt 30 in NVIC

}



int UART_Write(int iBytes, unsigned char *pcBytes)
{
    int donewrite=0;
    while( !(UART0_FR_R & 0x20) && donewrite<iBytes) //Tx fifo not full and input bytes not exhausted
    {
        UART0_DR_R = *(pcBytes+donewrite);
        donewrite++;
    }
    return donewrite;
}




int UART_Read(int iBytes,  unsigned char *pcBytes)
{
    int doneread=0;
    while(!(UART0_FR_R & 0x10) && doneread<iBytes)
    {
        *(pcBytes+doneread) = UART0_DR_R;
        doneread++;
    }
    return doneread;
}

/*
int UART_BytesInRx()
{   volatile int RxFE ; //to check if Rx FIFO is empty
    volatile int RxFLF; //FIFO level full (will change levels and check)
    volatile int RxFF; //to check fully filled status

            RxFE = UART0_FR_R & 0x10;
                    if(RxFE)
                        return 0; //0 bytes filled
                    else
                    {
                        RxFF = UART0_FR_R & 0x40;
                        if(RxFF)
                            return 16; //Full FIFO filled(16B)
                        else
                        {
                            UART0_IFLS_R = 0x20; //>=7/8 (14B) full check
                            RxFLF = UART0_RIS_R & 0x10; //check status of rx raw interrupt
                            if (RxFLF)
                                return 14;
                            else
                            {
                                UART0_IFLS_R = 0x18; //>=3/4 (12B) full check
                                RxFLF = UART0_RIS_R & 0x10; //check status of rx raw interrupt
                                if (RxFLF)
                                    return 12;
                                else
                                {
                                    UART0_IFLS_R = 0x10; //>=1/2 (8B) full check
                                    RxFLF = UART0_RIS_R & 0x10; //check status of rx raw interrupt
                                    if (RxFLF)
                                        return 8;
                                    else
                                    {
                                        UART0_IFLS_R = 0x08; //>=1/4 (4B) full check
                                        RxFLF = UART0_RIS_R & 0x10; //check status of rx raw interrupt
                                        if (RxFLF)
                                            return 4;
                                        else
                                        {
                                            UART0_IFLS_R = 0x00; //>=1/8 (2B) full check
                                            RxFLF = UART0_RIS_R & 0x10; //check status of rx raw interrupt
                                            if (RxFLF)
                                                return 2;
                                            else
                                            {
                                                return 1;
                                            }
                                        }
                                    }
                                }

                            }
                        }

                    }


}

*/
