#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <string.h>
#include <complex.h>
#include <stdio.h>


#define SampleSize 64
#define Fs 8192 //8192


#include "delay.h"
#include "UART.h"

#include "LEDstrip.h"

#include "math_fun.h"

volatile int8_t A[] = {0, 1, 2, 3, 4, 5, 6, 7}; //Screen display values

volatile uint16_t samplesRead = 0;

volatile complex float q[SampleSize];
volatile complex float scratch[SampleSize];


volatile float fftabs[SampleSize/2+1];

volatile int16_t tempA[8];

int main()
{

    UART_Init(115200);


        LEDstripInit();

/////////////////////////////////////////////// ADC INITIALISATION /////////////////////////////////////////////////////////////////////
        SYSCTL_RCGC2_R |= 0x00000010; // enable clock to GPIO E at clock gating control register
        SYSCTL_RCGCGPIO_R |= 0x10; // enable clock to PE (AIN0 is on PE3)

        GPIO_PORTE_AFSEL_R |= 8;   // enable alternate function
        GPIO_PORTE_DEN_R &= ~8;    // disable digital function
        GPIO_PORTE_AMSEL_R |= 8;   // enable analog function


        // enable clocks
        SYSCTL_RCGCADC_R |= 1;       // enable clock to ADC0
        SYSCTL_RCGCWTIMER_R |= 1;    // enable clock to WTimer Block 0

        // initialize ADC0
        ADC0_ACTSS_R &= ~8;          // disable SS3 during configuration
        ADC0_EMUX_R &= ~0xF000;
        ADC0_EMUX_R |= 0x5000;       // timer trigger conversion seq 0
        ADC0_EMUX_R |= 0x0000;       //without timer (software trig)

        ADC0_PP_R &= ~0xF;
        ADC0_PP_R |= 0x5;

        ADC0_SSMUX3_R = 0;           // get input from channel 0 (PE3)
        ADC0_SSCTL3_R |= 0x06;       // don't take chip temperature, set flag at 1st sample
        ADC0_ACTSS_R |= 8;           // enable ADC0 sequencer 3



/////////////////////////////////////////// TIMER TRIGGER FOR ADC INTIALISATION /////////////////////////////////////////
        uint32_t countLoad = 16000000/Fs;
        WTIMER0_CTL_R = 0;           // disable WTimer before initialization
        WTIMER0_CFG_R = 0x04;        // 32-bit option
        WTIMER0_TAMR_R = 0x02;       // periodic mode and down-counter
        WTIMER0_TAILR_R = countLoad;  // WTimer A interval load value reg
        WTIMER0_CTL_R |= 0x20;       // timer triggers ADC
        WTIMER0_CTL_R |= 0x01;       // enable WTimer A after initialization


        ///////////////////// ADC INTERRUPT SETTINGS //////////////////////////////
        ADC0_ISC_R = 0xFF; //clear any pending interrupt at ADC
        ADC0_IM_R = 0x08;
        NVIC_PRI4_R = (NVIC_PRI4_R & 0xFFFF1FFF) | 0x00002000; //  priority 1
        NVIC_EN0_R = 0x00020000;        //  Enable interrupt in NVIC


        __asm ("    CPSIE  I\n"); //enable interrupts
        //__asm ("    CPSID  I\n"); //disable interrupts



        samplesRead = 0;

        volatile int voltage;
        while(1)
        {



            if (samplesRead >= SampleSize)
            {
                    //__asm ("    CPSID  I\n"); //disable interrupts
                ADC0_IM_R = 0x00;
                    //WTIMER0_CTL_R = 0;           // disable WTimer before initialization



                   UART_Write(7,"sta\r\n");

                    //for(int j=0; j<SampleSize; j++)
                       //UART_showComplex (q[j]);

                    for(int k=0; k<8; k++)
                        tempA[k] = 0 ; //clear all accumulators

                    //UART_Write(7,"FFTst\n");



                    fft(q, SampleSize ,scratch);

                    //UART_Write(7,"FFTen\n");

                    //for(int j=0; j<16; j++)
                         // UART_showComplex (q[j]);


                     for (int i=0; i<33 ; i++)
                        {

                            fftabs[i] = sqrt((creal(q[i])*creal(q[i])+cimag(q[i])*cimag(q[i])))*2/SampleSize; //8 because *2/16 (2/L)


                            //int A_indx = (int)(i/(SampleSize/16));

                            if(i==0)
                                fftabs[i] = fftabs[i]/2;
                           // else
                                //tempA[A_indx] = tempA[A_indx] + fftabs[i];

                            if(i>0 && i<5)
                            {
                                tempA[0] = tempA[0] + fftabs[i];
                            }
                            else if(i<9)
                            {
                                tempA[1] = tempA[1] + fftabs[i];
                                //UART_debug(tempA[1]);
                            }
                            else if(i<13)
                            {
                                tempA[2] = tempA[2] + fftabs[i];
                            }
                            else if(i<17)
                            {
                                tempA[3] = tempA[3] + fftabs[i];
                            }
                            else if(i<21)
                            {
                                tempA[4] = tempA[4] + fftabs[i];
                            }
                            else if(i<25)
                            {
                                tempA[5] = tempA[5] + fftabs[i];
                            }
                            else if(i<29)
                            {
                                tempA[6] = tempA[6] + fftabs[i];
                            }
                            else
                            {
                                tempA[7] = tempA[7] + fftabs[i];
                            }








                        }


                     for(int k=0; k<8; k++)
                     {
                         A[k] = (uint8_t) (tempA[k]/4);
                         //UART_debug(A[k]);
                     }
                     samplesRead = 0;

                        screenUpdate(A);

                       //UART_Write(1,"e");



                        //WTIMER0_TAILR_R = countLoad;
                                //WTIMER0_CTL_R |= 0x01;       // enable WTimer A after initialization

                                ADC0_ISC_R = 0xFF; //clear any pending interrupt at ADC
                      ADC0_IM_R = 0x08;


                        //__asm ("    CPSIE  I\n"); //enable interrupts

                }
        }

}


void ADC0_SS3_ISR(void)
{
    volatile int voltage;
    //UART_Write(1,"i");

    voltage = ADC0_SSFIFO3_R;
    ADC0_ISC_R = 8;          // clear completion flag
    q[samplesRead] = (voltage-1400)/12 + 0*I;

    //(voltage-1400)/10.5 + 0*I; // to remove bias, and get in -127 to 127 range
    samplesRead++;
}





