#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>

#include "delay.h"

#include <string.h>
#include <complex.h>

void UART_debug(int a)
{
    char numStr[8];
    numStr[5]=10;
    numStr[6]=13;
    numStr[7] = 0;
    if(a<0)
    {   numStr[0]= '-';
        a=a*-1;
    }
    else
    {   numStr[0]= '0';}

    numStr[1]= (a/1000)%10+48;
    numStr[2]= (a/100)%10+48;
    numStr[3]= (a/10)%10+48;
    numStr[4]= a%10+48;

    //char buf[20];
    //gcvt(a, 10, buf);

   UART_Write(strlen(numStr), numStr);
    delayMs(1);

}
void UART_newline()
{
    char buf[] = "\r\n";
    UART_Write(strlen(buf), buf);
    delayUs(500);
}


void UART_showComplex (complex float z)
{

    char temp[20];
    gcvt(creal(z),6,temp);
    UART_Write(strlen(temp), temp);
    delayUs(1800);
    temp[0]='+';
    temp[1]='i';
    temp[2]=0;
    UART_Write(strlen(temp), temp);
    delayUs(1300);
    gcvt(cimag(z),6,temp);
    UART_Write(strlen(temp), temp);
    delayUs(1800);

    UART_newline();
}


int UART_Init(int iBaudRate)
{
        int I_BR = (int)(1000000/iBaudRate); //calculate integer part of baud rate divider
        float F_BR_dec = ((1000000.0/(float)iBaudRate) - I_BR)*64+0.5; //calculate fractional part of baud rate divider and scale it
        int F_BR = (int)F_BR_dec; //scaled integer count for fractional part of BR divider

        int LineControlVal=0x70;
        //Defaults taken:
        //Word length = 8 bits hence bits 5 and 6 are 1 and 1
        //FIFO enabled hence bit 4 is 1
        //Stop bits length = 1 bit hence bit 3 is 0
        //No break hence bit 0 is 0
        //Hence initial value assigned as 0x70

        int CTLval = 0x301; //without loopback, just enable Rx Tx and UART

       //No parity used

        SYSCTL_RCGCUART_R |= 0x01; //give clock to uart 0
        SYSCTL_RCGCGPIO_R |= 0x01; //give clock to port A where uart 0 rx and tx exist (PA0, PA1)
        UART0_CTL_R = 0x0000; //disable uart0 before configuration
        UART0_IBRD_R = I_BR; //integer part of baud rate divider
        UART0_FBRD_R = F_BR; //fractional part of baud rate divider

        UART0_LCRH_R = LineControlVal;

        UART0_CTL_R = CTLval;

        GPIO_PORTA_DEN_R |= 0x03; //set PA0 and PA1 as digital pins
        GPIO_PORTA_AFSEL_R |= 0x03; //set PA0 and PA1 as alternate function instead of GPIO(enabled)
        GPIO_PORTA_PCTL_R &= 0xFFFFFF00;
        GPIO_PORTA_PCTL_R |= 0x00000011; //select type of alternate function (binary 0001 is for UART in each 4 bits for each pin)
        GPIO_PORTA_AMSEL_R &= ~0x03; //disable analog functionality by clearing pins PA0 and PA1


        UART0_IFLS_R = 0x10; //8 byte water level
        UART0_IM_R = 0x00000050; //Rx FIFO fill interrupt and Rx timeout enabled
        UART0_ICR_R = 0x00000050; //clear interrupt

        NVIC_PRI1_R = (NVIC_PRI1_R & 0xFFFF1FFF) | 0x0000A000; // priority 5
        NVIC_EN0_R = 0x00000020;        // Enable interrupt 30 in NVIC

}



int UART_Write(int iBytes, unsigned char *pcBytes)
{
    int donewrite=0;
    while( !(UART0_FR_R & 0x20) && donewrite<iBytes) //Tx fifo not full and input bytes not exhausted
    {
        UART0_DR_R = *(pcBytes+donewrite);
        donewrite++;
    }
    return donewrite;
}


int UART_Read(int iBytes,  unsigned char *pcBytes)
{
    int doneread=0;
    while(!(UART0_FR_R & 0x10) && doneread<iBytes)
    {
        *(pcBytes+doneread) = UART0_DR_R;
        doneread++;
    }
    return doneread;
}
