#include <stdint.h>
#include <./inc/tm4c123gh6pm.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>
// from arduino code

#define LINE_BUFFER_LENGTH 512
// Servo position for Up and Down
const int penZUp = 115;
const int penZDown = 83;

// Servo on PWM pin 10
const int penServoPin =0 ;

// Should be right for DVD steppers, but is not too important here
const int stepsPerRevolution = 48;

struct point {
  float x;
  float y;
  float z;
};

// Current position of plothead
struct point actuatorPos;

//  Drawing settings, should be OK
float StepInc = 1;
int StepDelay = 0;
int LineDelay =0;
int penDelay = 50;

// Motor steps to go 1 millimeter.
// Use test sketch to go 100 steps. Measure the length of line.
// Calculate steps per mm. Enter here.
float StepsPerMillimeterX = 74;
float StepsPerMillimeterY = 74;

// Drawing robot limits, in mm
// OK to start with. Could go up to 50 mm if calibrated well.
float Xmin = 0;
float Xmax = 210;
float Ymin = 0;
float Ymax = 297;
float Zmin = 0;
float Zmax = 1;

float Xpos = 0;
float Ypos = 0;
float Zpos = 1;

//.................

void delayMs(int n);
void Servo_Init();
void PortF_Config(void);
void PortD_Config(void);
void Enable_Pin_Config(void);

void Servo_Up(void);  // 3% duty cycle of 50Hz pulse
void Servo_Down(void); // 7% duty cycle of 50Hz pulse
void Step_X_Dir(void);
void Step_Y_Dir(void);

void XDir_Left(void);
void XDir_Right(void);
void YDir_Up(void);
void YDir_Down(void);

void Enable_StepperXY(void);
void Disable_StepperXY(void);

void Delay_MicroSecond(int time); // generates delay in microseconds

// UART part
void UART0_Init(void);
void UART0_Handler(void);
void setCommand(void);

void EnableInterrupts(void);

// arduino code
void processIncomingLine( char* line, int charNB );
void drawLine(float x1, float y1);
//.............


#define ASCII_ENTER 13
#define ASCII_BACKSPACE 127
char data[20];
int i;

char line[ LINE_BUFFER_LENGTH ];
int lineIndex = 0;
bool lineIsComment = false;
bool lineSemiColon = false;
char* indexX;
char* indexY;

int main(){



    lineIndex = 0;
    lineSemiColon = false;
    lineIsComment = false;

    Enable_Pin_Config(); // enable signal for stepper motors
    Servo_Init();
    UART0_Init();
    PortF_Config();  // LEDs for debugging
    PortD_Config();  // port D configurations
    Servo_Up();
    Enable_StepperXY();

    while(1){
//        Servo_Up();
//        Delay_MicroSecond(100000);
//        Servo_Down();
//        Delay_MicroSecond(100000);
    }
    return 0;
}

void delayMs(int n){
    int i, j;
    for(i = 0 ; i < n; i++)
        for(j = 0; j < 100; j++) {}   /* do nothing for 0.5 ms */
}


void Servo_Init(){
    /* PA4 as a digital output signal to provide trigger signal */
         SYSCTL_RCGC2_R |= 0x02;      /* enable clock to PORTA */
         GPIO_PORTB_DIR_R |=(1<<0);         /* set PA4 as a digial output pin */
         GPIO_PORTB_DEN_R |=(1<<0);         /* make PA4 as digital pin */
}

void Servo_Up(void)
{
    int i=0;
     for(i=0; i<50; i++)
     {
       /* Given 10us trigger pulse */
       GPIO_PORTB_DATA_R |= (1<<0); /* make control  pin high */
       Delay_MicroSecond(600); /*0.6ms seconds delay */
       GPIO_PORTB_DATA_R &= ~(1<<0); /* make control  pin low */
       Delay_MicroSecond(19400); /*1.94ms seconds delay */
   }
}
/* This function generate a 7% duty cycle from 20ms PWM signal or 50Hz*/
void Servo_Down(void)
{
    int i=0;
      for(i=0; i<50; i++)
     {
     /* Given 10us trigger pulse */
       GPIO_PORTB_DATA_R |= (1<<0); /* make control  pin high */
       Delay_MicroSecond(1400); /*1.4ms seconds delay */
       GPIO_PORTB_DATA_R &= ~(1<<0); /* make control  pin low */
       Delay_MicroSecond(18600); /*1.86ms seconds delay */
         }
}

void Delay_MicroSecond(int time)
{
    int i;
    SYSCTL_RCGCTIMER_R |= 2;     /* enable clock to Timer Block 1 */
    TIMER1_CTL_R = 0;            /* disable Timer before initialization */
    TIMER1_CFG_R = 0x04;         /* 16-bit option */
    TIMER1_TAMR_R = 0x02;        /* periodic mode and down-counter */
    TIMER1_TAILR_R  = 16 - 1;  /* TimerA interval load value reg */
    TIMER1_ICR_R  = 0x1;          /* clear the TimerA timeout flag */
    TIMER1_CTL_R |= 0x01;        /* enable Timer A after initialization */

    for(i = 0; i < time; i++)
    {
        while ((TIMER1_RIS_R & 0x1) == 0) ;      /* wait for TimerA timeout flag */
        TIMER1_ICR_R = 0x1;      /* clear the TimerA timeout flag */
    }
}

void Enable_StepperXY(void){
    GPIO_PORTE_DATA_R &= ~0x02;   // PE1 = 0, enable the stepper motors (both x and y)
}

void Disable_StepperXY(void){
    GPIO_PORTE_DATA_R |= 0x02;  // PE1 = 1, disable the stepper motors (both x and y)
}

void Enable_Pin_Config(void){
    SYSCTL_RCGC2_R |= 0x10;  // enable clock to PORT-E (PE1 is used as enable for stepper)
    GPIO_PORTE_DEN_R |= 0x02;;  // PE1
    GPIO_PORTE_DIR_R |= 0x02;   // PE1
}

void PortF_Config(void){
    SYSCTL_RCGC2_R |= 0x20;  // enable clock to PORT-F (for debugging)
    GPIO_PORTF_DEN_R |= 0x0E; // PF-1,2,3
    GPIO_PORTF_DIR_R |= 0x0E; // PF-1,2,3
}

void PortD_Config(void){
    SYSCTL_RCGC2_R |= 0x08;  // enable clock to PORT-D (PD0, PD1, PD2 and PD3 are used for x and y axis stepper)
    GPIO_PORTD_DEN_R |= 0x0F; // PD-0,1,2,3
    GPIO_PORTD_DIR_R |= 0x0F; // PD-0,1,2,3
}

void Step_X_Dir(void){


        GPIO_PORTD_DATA_R |= 0x01;
        delayMs(1);
        GPIO_PORTD_DATA_R &= ~0x01;
        delayMs(1);


}
void Step_Y_Dir(void){


        GPIO_PORTD_DATA_R |= 0x02;
        delayMs(1);
        GPIO_PORTD_DATA_R &= ~0x02;
        delayMs(1);

}

void XDir_Left(void){
    GPIO_PORTD_DATA_R &= ~(1<<2);   // direction set
}
void XDir_Right(void){
    GPIO_PORTD_DATA_R |= (1<<2);   // direction set
}
void YDir_Down(void){
    GPIO_PORTD_DATA_R &= ~(1<<3);   // direction set
}
void YDir_Up(void){
    GPIO_PORTD_DATA_R |= (1<<3);   // direction set
}

void EnableInterrupts(void){
    __asm  ("    CPSIE  I\n");
}

void UART0_Init(void){

    SYSCTL_RCGCUART_R = 0x01;
    SYSCTL_RCGCGPIO_R = 0x01;
    UART0_CTL_R &= ~0x00000001;
//    UART0_IBRD_R = 0x08;
//    UART0_FBRD_R = 0x2C;
    UART0_IBRD_R = 0x68;
    UART0_FBRD_R = 0x0B;
    UART0_LCRH_R = 0x60;
    UART0_CTL_R |= 0x301;

    GPIO_PORTA_DEN_R = 0x03;
    GPIO_PORTA_AFSEL_R = 0x03;
    GPIO_PORTA_PCTL_R = 0x11;
    GPIO_PORTA_AMSEL_R = 0x00;


    UART0_ICR_R |= 0x10;    // clear interrupt
    UART0_IM_R |= 0x10;
    NVIC_PRI1_R = (NVIC_PRI1_R & 0xFF1FFFFF) | 0x00A00000; // set priority 5
    NVIC_EN0_R |= 0x00000020; // enable UART0 interrupt

    EnableInterrupts();             /* Enable global Interrupt flag (I) */
}

void UART0_Handler(void){
    volatile int readback;
    char c;
    c = UART0_DR_R;
    if (( c == '\n') || (c == '\r') ) {             // End of line reached
        if ( lineIndex > 0 ) {                        // Line is complete. Then execute!
            line[ lineIndex ] = '\0';                   // Terminate string
            processIncomingLine( line, lineIndex );
            UART0_DR_R = 'd';
            lineIndex = 0;
        }

        lineIsComment = false;
        lineSemiColon = false;
    }
    else {
        if ( (lineIsComment) || (lineSemiColon) ) {   // Throw away all comment characters
            if ( c == ')' )  lineIsComment = false;     // End of comment. Resume line.
        }
        else {
            if ( c <= ' ' ) {                           // Throw away whitepace and control characters
                //UART0_DR_R = c;
            }
            else if ( c == '/' ) {                    // Block delete not supported. Ignore character.
            }
            else if ( c == '(' ) {                    // Enable comments flag and ignore all characters until ')' or EOL.
                lineIsComment = true;
            }
            else if ( c == ';' ) {
                lineSemiColon = true;
            }
            else if ( lineIndex >= LINE_BUFFER_LENGTH-1 ) {
                lineIsComment = false;
                lineSemiColon = false;
            }
            else if ( c >= 'a' && c <= 'z' ) {        // Upcase lowercase
                line[ lineIndex++ ] = c-'a'+'A';
                //UART0_DR_R = c-'a'+'A';;
            }
            else {
                line[ lineIndex++ ] = c;
                //UART0_DR_R = c;
            }
        }
    }

    readback = UART0_ICR_R;    /* a read to force clearing of interrupt flag */
    readback = readback;
}

void setCommand(){
    if(!strcmp(data, "l")){
        Enable_StepperXY();
        XDir_Left();
        Step_X_Dir();
        Disable_StepperXY();
    }else if(!strcmp(data, "r")){
        Enable_StepperXY();
        XDir_Right();
        Step_X_Dir();
        Disable_StepperXY();
    }else if(!strcmp(data, "u")){
        Enable_StepperXY();
        YDir_Up();
        Step_Y_Dir();
        Disable_StepperXY();
    }else if(!strcmp(data, "d")){
        Enable_StepperXY();
        YDir_Down();
        Step_Y_Dir();
        Disable_StepperXY();
    }else if(!strcmp(data, "pu")){
        Servo_Up();
    }else if(!strcmp(data, "pd")){
        Servo_Down();
    }
}

void processIncomingLine( char* line, int charNB ) {
    int currentIndex = 0;
    char buffer[ 64 ];                                 // Hope that 64 is enough for 1 parameter
    struct point newPos;

    newPos.x = 0.0;
    newPos.y = 0.0;

    //  Needs to interpret
    //  G1 for moving
    //  G4 P300 (wait 150ms)
    //  G1 X60 Y30
    //  G1 X30 Y50
    //  M300 S30 (pen down)
    //  M300 S50 (pen up)
    //  Discard anything with a (
    //  Discard +any other command!

    while( currentIndex < charNB ) {
        switch ( line[ currentIndex++ ] ) {              // Select command, if any
            case 'U':
                Servo_Up();
            break;
            case 'D':
                Servo_Down();
            break;
            case 'G':
                buffer[0] = line[ currentIndex++ ];          // /!\ Dirty - Only works with 2 digit commands
                //      buffer[1] = line[ currentIndex++ ];
                //      buffer[2] = '\0';
                buffer[1] = '\0';

                switch ( atoi( buffer ) ){                   // Select G command
                    case 0:                                   // G00 & G01 - Movement or fast movement. Same here
                    case 1:
                        // /!\ Dirty - Suppose that X is before Y
                        indexX = strchr( line+currentIndex, 'X' );  // Get X/Y position in the string (if any)
                        indexY = strchr( line+currentIndex, 'Y' );
                        if ( indexY <= 0 ) {
                            newPos.x = atof( indexX + 1);
                            newPos.y = actuatorPos.y;
                        }
                        else if ( indexX <= 0 ) {
                            newPos.y = atof( indexY + 1);
                            newPos.x = actuatorPos.x;
                        }
                        else {
                            newPos.y = atof( indexY + 1);
                            indexY = '\0';
                            newPos.x = atof( indexX + 1);
                        }
                        drawLine(newPos.x, newPos.y );
                        actuatorPos.x = newPos.x;
                        actuatorPos.y = newPos.y;
                    break;
                }
            break;
            case 'M':
                buffer[0] = line[ currentIndex++ ];        // /!\ Dirty - Only works with 3 digit commands
                buffer[1] = line[ currentIndex++ ];
                buffer[2] = line[ currentIndex++ ];
                buffer[3] = '\0';
                switch ( atoi( buffer ) ){
                    case 300:
                        {
                        char* indexS = strchr( line+currentIndex, 'S' );
                        float Spos = atof( indexS + 1);
                        //         Serial.println("ok");
                        if (Spos == 30) {
                            Servo_Down();
                        }
                        if (Spos == 50) {
                            Servo_Up();
                        }
                        break;
                        }
                    case 114:                                // M114 - Repport position
                    break;
                    default:
                        //Serial.print( "Command not recognized : M");
                        //Serial.println( buffer );
                    break;

            }
        }
    }
}

void drawLine(float x1, float y1) {
    //  Bring instructions within limits
    if (x1 >= Xmax) {
        x1 = Xmax;
    }
    if (x1 <= Xmin) {
        x1 = Xmin;
    }
    if (y1 >= Ymax) {
        y1 = Ymax;
    }
    if (y1 <= Ymin) {
        y1 = Ymin;
    }

    //  Convert coordinates to steps
    x1 = (int)(x1*StepsPerMillimeterX);
    y1 = (int)(y1*StepsPerMillimeterY);
    float x0 = Xpos;
    float y0 = Ypos;

    //  Let's find out the change for the coordinates
    long dx = abs(x1-x0);
    long dy = abs(y1-y0);
    int sx = x0<x1 ? StepInc : -StepInc;
    int sy = y0<y1 ? StepInc : -StepInc;

    long i;
    long over = 0;

    if (dx > dy) {
        for (i=0; i<dx; ++i) {
            //................... added for exp
            if(sx>0){
                XDir_Right();   // added for experiment
            }else{
                XDir_Left();
            }
        Step_X_Dir();   // added for experiment
        //myStepperX.onestep(sx,STEP);
        over+=dy;
        if (over>=dx) {
            over-=dx;
            //................... added for exp
            if(sy>0){
                YDir_Up();   // added for experiment
            }else{
                YDir_Down();
            }
            Step_Y_Dir();   // added for experiment
            //myStepperY.onestep(sy,STEP);
        }
        }
    }
    else {
        for (i=0; i<dy; ++i) {
        //................... added for exp
        if(sy>0){
            YDir_Up();   // added for experiment
        }else{
            YDir_Down();
        }
        Step_Y_Dir();
        // added for experiment
        //myStepperY.onestep(sy,STEP);
        over+=dx;
        if (over>=dy) {
            //................... added for exp
            if(sx>0){
                XDir_Right();   // added for experiment
            }else{
                XDir_Left();
            }
            Step_X_Dir();   // added for experiment
            over-=dy;
            //myStepperX.onestep(sx,STEP);
        }
        }
    }
    //  Delay before any next lines are submitted
    //delay(LineDelay);
    //  Update the positions
    Xpos = x1;
    Ypos = y1;
}
