/*
 * pwm.c
 *
 *  Created on: 08-Apr-2022
 *      Author: anonymous
 */
#include "i2c.h"
#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "mpu6050.h"
#include "pwm.h"
void pwm_init(void)
{
    /* Enable Peripheral Clocks */
    SYSCTL_RCGCPWM_R |= 2;       /* enable clock to PWM1 */
    SYSCTL_RCGCGPIO_R |= 0x21;   /* enable clock to PORTF */
    SYSCTL_RCC_R &= ~0x00100000; /* no pre-divide for PWM clock */

    /* Enable port PF3 for PWM1 M1PWM7 */
    GPIO_PORTF_LOCK_R = 0x4C4F434B;          // unlock GPIO Port F
    GPIO_PORTF_CR_R |= 0x03;
    GPIO_PORTF_DIR_R |= 0x13;
    GPIO_PORTF_DEN_R |= 0x1F;       /* pin digital */
    GPIO_PORTF_AFSEL_R = 0x09;      /* PF3 uses alternate function */
    GPIO_PORTF_PCTL_R &= ~0x0000F00F; /* make PF3 PWM output pin */
    GPIO_PORTF_PCTL_R |= 0x00005005;

    PWM1_3_CTL_R = 0;            /* stop counter */

    PWM1_3_GENB_R = 0x0000008C;  /* M1PWM7 output set when reload, */

    PWM1_3_LOAD_R = 16000;       /* set load value for 1kHz (16MHz/16000) */

    PWM1_3_CMPA_R = 15999;       /* set duty cycle to min */

    PWM1_3_CTL_R = 1;            /* start timer */
}

