#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "mpu6050.h"
#include "i2c.h"
#include "pwm.h"

char msg[20];
float angle =0;
float angleY=0;
float stability=0;
float x;

double yz;
int  accX, accY, accZ, GyroX, GyroY, GyroZ, Temper;
float AX, AY, AZ, t, GX, GY, GZ;
double accel_angle = 0, new_accel_angle, angle_est, prev_angle, count = 0;
double set_point = 0, Total_error = 0, Deviation, correction, duty = 0;

int main()
{   char data[14];

    SysTickEnable();

//    ConfigUart();
    i2c_init();
    mpu_6050_init();
    pwm_init();

    while(1){
        i2c_read(0x68, ACCEL_XOUT_H ,14, data);
        accX = (int) ( (data[0] << 8 ) |data[1] );
        if (data[0] > 0x80)
            accX=0xFFFF0000|accX;

        accY = (int) ( (data[2] << 8 ) |data[3] );
        if (data[2] > 0x80)
            accY=0xFFFF0000|accY;

        accZ = (int) ( (data[4] << 8 ) |data[5] );
        if (data[4] > 0x80)
            accZ=0xFFFF0000|accZ;
        Temper = (int) ( (data[6] << 8 ) |data[7] );

        GyroX = (int) ( (data[8] << 8 ) |data[9] );
        if (data[8] > 0x80)
            GyroX=0xFFFF0000|GyroX;
        GyroY = (int) ( (data[10] << 8 ) |data[11] );
        if (data[10] > 0x80)
            GyroY=0xFFFF0000|GyroY;
        GyroZ = (int) ( (data[12] << 8 ) |data[13] );
        if (data[12] > 0x80)
            GyroZ=0xFFFF0000|GyroZ;

          AX = ((float)accX/16384.0)-0.04;
          AY = ((float)accY/16384.0)+0.014;
          AZ = ((float)accZ/16384.0)+0.07-0.12;

          GX = ((float)GyroX/131.0);
          GY = ((float)GyroY/131.0);
          GZ = ((float)GyroZ/131.0);

//              uart_write("GY = ");
//              uart_write(itoa(angleY,msg,10));
//              uart_write("\ttotal error= ");
//              uart_write(itoa(Total_error,msg,10));
//
//              uart_write("\tangle = ");
//
//              ftoa(angle_est,msg,4);
//              uart_write(msg);
//              uart_write("\tprev_angle = ");
//                            ftoa(prev_angle,msg,4);
//                            uart_write(msg);
//
////          uart_write("\tAccZ = ");
////              uart_write(itoa(GyroY,msg,10));
////              uart_write("\tGY = ");
////              ftoa(GY,msg,4);
////              uart_write(msg);
//              uart_write("\tCorrection = ");
//              ftoa(correction,msg,4);
//              uart_write(msg);
//             uart_write("\tdeviation = ");
//          uart_write(itoa(Deviation,msg,10)); uart_write(msg);
//              uart_write(itoa(accel_angle,msg,10));

//              uart_write("\tdeviation = ");
//              uart_write(itoa(Deviation,msg,10));

////              uart_write("\tt = ");
////              uart_write(itoa(t,msg,10));
//              UARTCharPut(UART0_BASE, 13);
//              uart_write("\n\r");
          PID_Controller();
    }

    return 0;
}

void PID_Controller(void)
{
    if(angle_est <-15){
     if((correction)>0){
                duty = correction;
                set_dutycycle1((int)(correction));
                PWM1_ENABLE_R = 0x80;
                GPIO_PORTF_DATA_R = 0x04;
     }
    }

     else if(angle_est >15)
     {if((correction)<0){
                duty =  correction;
                set_dutycycle1((-1)*(int)(correction));
                GPIO_PORTF_DATA_R = 0x02;
                    PWM1_ENABLE_R = 0x80;


         }
     }
     else
     {
    if((Deviation)<0){
               duty = correction;
               set_dutycycle1((-1)*(int)(Deviation));
               PWM1_ENABLE_R = 0x80;
               GPIO_PORTF_DATA_R = 0x04;


    }

    else if((Deviation)>=0){
               duty =  correction;
               set_dutycycle1((int)(Deviation));
               GPIO_PORTF_DATA_R = 0x02;
                   PWM1_ENABLE_R = 0x80;


        }
     }
}


void SysTickEnable(){
    /* enable clock to GPIOF at clock gating control register */
        SYSCTL_RCGC2_R |= 0x20;
        /* enable the GPIO pins for the LED (PF3, 2, 1) as output */
        GPIO_PORTF_DIR_R |= 0x0E;
        /* enable the GPIO pins for digital function */
        GPIO_PORTF_DEN_R |= 0x0E;

        /* Configure SysTick */
        NVIC_ST_RELOAD_R = (16000*79)-1;  /* reload with number of clocks per 20 ms  */
        NVIC_ST_CTRL_R = 7;             /* enable SysTick interrupt, use system clock */

        enable_irq();
}

void enable_irq(void)
{
    __asm  ("    CPSIE  I\n");
}
void SysTick_Handler(void)
{

    int Kp = 10000, Ki =1, Kd = 0;        // Design 1 - Kp = 2500, Ki = 5000, Kd = 30
                                              // Design 2 - Kp = 2500, Ki = 1500, Kd = 100
    double present_error,dt = 0.079;   //dt=20msec which timer overflow interrupt

    yz = (double) sqrt(AX * AX + AY * AY);
    accel_angle = Atan2((double) (AZ), yz) * 180 / 3.141592 ;

    prev_angle = angle_est;
    angle_est = ((0.99) * (angle_est + (double) (GY * dt)) + (0.01 * accel_angle));   //Complementary filter

    Deviation = 4000000* ((angle_est - set_point)-(prev_angle - set_point));
    present_error = set_point - angle_est;
    correction = Kp * (present_error) + Ki * Total_error + Kd * Deviation/dt;   //Deviation*50 = Deviation/dt
    Total_error = Total_error + present_error*dt;


}
void set_dutycycle1(int i)
{   if(i>13000){
    i=13000-1;
    }
    i = 13000-(i*i);
    PWM1_3_CMPA_R = i;
}
void ftoa(float n, char *res, int afterpoint)
{
    int i = 0, flag = 0;
    if (n < 0)
    {
        flag = 1;
        res[0] = '-';
        n = -1 * n;
    }
    // Extract integer part
    int ipart = (int) n;

    // Extract floating part
    float fpart = n - (float) ipart;

    // convert integer part to string
    if (flag)
    {
        i = intToStr(ipart, res + 1, 8);
    }
    else
    {
        i = intToStr(ipart, res, 8);
    }

    // check for display option after point
    if (afterpoint != 0)
    {
        if (flag)
        {
            res[i + 1] = '.';  // add dot
        }
        else
        {
            res[i] = '.';  // add dot
        }

        // Get the value of fraction part upto given no.
        // of points after dot. The third parameter is needed
        // to handle cases like 233.007
        int j = 0;
        for (j = 0; j < afterpoint; j++)
        {
            fpart = fpart * 10;
        }

        if (flag)
        {

            intToStr((int) fpart, res + i + 2, afterpoint);
        }
        else
        {
            intToStr((int) fpart, res + i + 1, afterpoint);
        }

    }
}
void ConfigUart(){
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

    UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 115200,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
    SYSCTL_RCGC2_R |= 0x00000023;   /* enable clock to GPIOF */

    GPIO_PORTF_DIR_R = 0x0E;         /* set PORTF3 pin as output (LED) pin */
    GPIO_PORTF_DEN_R = 0x0E;
}
void uart_write(char *pcBytes){
        for(int i =0; pcBytes[i]!='\0';i++){
            UARTCharPut(UART0_BASE, pcBytes[i]);
        }
}
void delayMs(int del){
    int a, b;
    for(a = 0 ; a < del; a++)
                for(b = 0; b < 3180; b++) {}
}

float sqrt(const float m)
{
    float i=0;
    float x1,x2;
    while( (i*i) <= m )
           i+=0.1f;
    x1=i;
    for(int j=0;j<10;j++)
        {
            x2=m;
           x2/=x1;
           x2+=x1;
           x2/=2;
           x1=x2;
        }
    return x2;
}

float Fabsf(float x)
{
    union {float f; unsigned int i;} u = {x};
    u.i &= 0x7fffffff;
    return u.f;
}

float Atan2(float y, float x)
{
    const float n1 = 0.97239411f;
    const float n2 = -0.19194795f;
    float result = 0.0f;
    if (x != 0.0f)
    {
        const union { float flVal; unsigned int nVal; } tYSign = { y };
        const union { float flVal; unsigned int nVal; } tXSign = { x };
        if (Fabsf(x) >= Fabsf(y))
        {
            union { float flVal; unsigned int nVal; } tOffset = { PI };
            // Add or subtract PI based on y's sign.
            tOffset.nVal |= tYSign.nVal & 0x80000000u;
            // No offset if x is positive, so multiply by 0 or based on x's sign.
            tOffset.nVal *= tXSign.nVal >> 31;
            result = tOffset.flVal;
            const float z = y / x;
            result += (n1 + n2 * z * z) * z;
        }
        else // Use atan(y/x) = pi/2 - atan(x/y) if |y/x| > 1.
        {
            union { float flVal; unsigned int nVal; } tOffset = { PI_2 };
            // Add or subtract PI/2 based on y's sign.
            tOffset.nVal |= tYSign.nVal & 0x80000000u;
            result = tOffset.flVal;
            const float z = x / y;
            result -= (n1 + n2 * z * z) * z;
        }
    }
    else if (y > 0.0f)
    {
        result = PI_2;
    }
    else if (y < 0.0f)
    {
        result = -PI_2;
    }
    return result;
}

int intToStr(int x, char str[], int d)
{
    int i = 0;
    while (x)
    {
        str[i++]= (x % 10) + '0';
        x = x / 10;
    }

    // If number of digits required is more, then
    // add 0s at the beginning
    while (i < d)
        str[i++] = '0';

    reverse(str, i);
    str[i] = '\0';
    return i;
}
void reverse(char *str, int len)
{
    int i = 0, j = len - 1, temp;
    while (i < j)
    {
        temp = str[i];
        str[i] = str[j];
        str[j] = temp;
        i++;
        j--;
    }
}


