/*
 * i2c.c
 *
 *  Created on: 07-Apr-2022
 *      Author: anonymous
 */
#include "i2c.h"
#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "mpu6050.h"
#include "i2c.h"


void i2c_init(void){
    SYSCTL_RCGC2_R  |= 0x00000008 ; // Enable the clock for port D
    SYSCTL_RCGCI2C_R  |= 0x00000008 ; // Enable the clock for I2C 3
    GPIO_PORTD_DEN_R |= 0x03;
    GPIO_PORTD_AFSEL_R |= 0x00000003 ;
    GPIO_PORTD_PCTL_R |= 0x00000033 ;
    GPIO_PORTD_ODR_R |= 0x00000002 ; // SDA (PD1 ) pin as open darin
    I2C3_MCR_R  = 0x0010 ;
    I2C3_MTPR_R  = 0x07 ;
}

/*
 * Function to write data from pc to mpu through i2c
 * to configure mpu6050
 */

char i2c_write(int slaveAdd, char memAdd, char data){
    char error;

    /* send slave address and starting address */
    I2C3_MSA_R = slaveAdd << 1;
    I2C3_MDR_R = memAdd;
    I2C3_MCS_R = 3;                      /* S-(saddr+w)-ACK-maddr-ACK */

    error = I2C_wait_till_done();       /* wait until write is complete */
    if (error) return error;

    /* send data */
    I2C3_MDR_R= data;
    I2C3_MCS_R = 5;                      /* -data-ACK-P */
    error = I2C_wait_till_done();       /* wait until write is complete */
    while(I2C3_MCS_R & 0x40);            /* wait until bus is not busy */
    error = I2C3_MCS_R & 0xE;
    if (error) return error;

    return 0;       /* no error */
}

void i2c_read(int slaveAdd,char memAdd, int length, char* data){
    char error;

   if (length <= 0)
       return;         /* no read was performed */

   /* send slave address and starting address */
   I2C3_MSA_R = slaveAdd << 1;
   I2C3_MDR_R = memAdd;
   I2C3_MCS_R = 3;       /* S-(saddr+w)-ACK-maddr-ACK */
   error = I2C_wait_till_done();
//   if (error)
//       uart_write("error");

   /* to change bus from write to read, send restart with slave addr */
   I2C3_MSA_R = (slaveAdd << 1) + 1;   /* restart: -R-(saddr+r)-ACK */

   if (length == 1)             /* if last byte, don't ack */
       I2C3_MCS_R= 7;              /* -data-NACK-P */
   else                            /* else ack */
       I2C3_MCS_R = 0xB;            /* -data-ACK- */
   error = I2C_wait_till_done();
//   if (error)
//       uart_write("error");

   *data++ = I2C3_MDR_R;            /* store the data received */

   if (--length == 0)           /* if single byte read, done */
   {
       while(I2C3_MCS_R& 0x40);    /* wait until bus is not busy */
       return;       /* no error */
   }

   /* read the rest of the bytes */
   while (length > 1)
   {
       I2C3_MCS_R = 9;              /* -data-ACK- */
       error = I2C_wait_till_done();
//       if (error)
 //          uart_write("error");
       length--;
       *data++ = I2C3_MDR_R;        /* store data received */
   }

   I2C3_MCS_R = 5;                  /* -data-NACK-P */
   error = I2C_wait_till_done();
   *data = I2C3_MDR_R;              /* store data received */
   while(I2C3_MCS_R & 0x40);        /* wait until bus is not busy */

}


static int I2C_wait_till_done(void)
{
    while(I2C3_MCS_R & 1);   /* wait until I2C master is not busy */
    return I2C3_MCS_R & 0xE; /* return I2C error code */
}

