    /* Washing Machine Simulator

     * Peripherals used Timer0 Timer1 Timer2
     *                  UART0  LED's  Switches
     *                  7segmentDisp  LCD
     *                  M1PWM0 Keypad

     *

     */



#include <stdint.h>
#include <string.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include <./inc/tm4c123gh6pm.h>
#include "UART_driver.h"
#include "Peripheral_Init.h"

struct machine_state
{
    int power;
    int door;
    int time;
    int mode;
    int detergent;
    int run_state;
    int wash_complete;

};



struct machine_state state;
int enter_pressed;
int digits_place;
int next_instr_rdy;
int sw_command;
int blink;
int stage_of_wash;
int resume, change;
char str[30];
char LCD1[40];
char LCD2[40];
char char_enter;
int wait_for_command;
int wait_for_msg;
int wait_for_dld;
int mode;
char str_fin[100];
char field1, field2, field3;
char field4[5];
char str1[100];

void EnableInterrupts(void)

{

    __asm  ("    CPSIE  I\n");

}

void state_reset(struct machine_state *state);
void delayMs(int n);
void UART_handler();
void UART5_handler();
void Timer_main_handler();
void Timer_7seg_handler();
void Timer_LCD_handler();
void Timer_LED_handler();
void Switch_handler();
void start_lcd_delay(int sel);
void LCD_init();
void Put_string();
void send_command(char* str);
void send_command1(char* str);
void send_msg(char*msg);
void Command_msg(char* cmd, char* msg);
void Command_dld(char* cmd);
void Command(char* str);
void init_gprs();
void Timer_10shandler();
void Timer_0_8shandler();
void Timer_1shandler();
void Timer_1_2shandler();


int main()
{
    // reset all state variables
    state_reset( &state );
    enter_pressed = 0;
    digits_place = 0;
    next_instr_rdy = 1;
    sw_command = 0;
    blink = 0;
    stage_of_wash = 0;
    resume = 0;
    change = 0;
    char_enter = 0x0d;
    wait_for_command = 0;
    wait_for_msg = 0;
    wait_for_dld = 0;
    strcpy(str,"");
    strcpy(LCD1,"TMODE:______ DOOR:_____ DET:_ ");
    strcpy(LCD2,"STATUS:________ MODE:_______ ER:_");


    // initialise all peripherals
    SYSCTL_RCGCTIMER_R |= 0x1;
    UART_init(0);
    UART_init(5);
    UART_interrupt_init(0);
    UART_interrupt_init(5);
    Timer_Main_init();
    Timer_7seg_init();
    Timer_LCD_init();
    Timer_LED_init();
    Timer_log_0_8s();
    Timer_log_1s();
    Timer_log_1_2s();
    Timer_log_10s();
    LED_SW_init();
    pwm_init();
    seg7_init();
    Command("ATE1");
    Command("AT");
    Command("AT+CFUN=1");
    Command("AT+CMGF=1");
//    init_gprs();
    for( int i=1; i<20; i++)
        start_lcd_delay(1);
    LCD_init();
    Put_string();
    

    int len, timer_n,timer, error, timer_min, timer_sec;
    char sub_str[5] = "";
    strcpy(str1,"api_key=4I4386CX47RBXYFA");
    int d0,d1,d2,d3;

    strcpy(str_fin,"");
    timer_n = -1;
    timer_min = 0;
    timer_sec = 0;
    timer = 0;
    mode = 0;


    EnableInterrupts();


    TIMER1_CTL_R = 0x01;
    TIMER2_CTL_R = 0x01;
    while(1)
    {
        if ( enter_pressed == 1 )
        {   unsigned char n = '\r';
            len = strlen(str);
            UART_write(0,&n);
            n = '\n';
            UART_write(0,&n);
            if (len == 0)
            {   
                error = 5;
                continue;
            }
            if (state.run_state == 1 || state.wash_complete == 1 )
            {
                error = 6;
                enter_pressed = 0;
                continue;
            }
            for (int k = 0; k<len; k++)
            {
                if ( str[k] == ' ' || str[k] == '\t' )
                {
                    for (int p = k; p<len; p++)
                    {
                        str[p] = str[p+1];
                    }
                }
            }
            if ( strncmp(str,"settimer",8) == 0)
            {   
                
                for (int k = 8; k<len; k++)
                    strncat(sub_str, &str[k], 1);
                len = strlen(sub_str);
                if (len >= 3)
                {   
                    error = 5;
                    enter_pressed = 0;
                    continue;
                }

                timer_n = atoi(sub_str);
                if ( timer_n == 5 )
                {
                    state.mode = 1;
                    state.time = timer_n*60;
                    error = 0;
                }
                else if ( timer_n == 15 )
                {
                    state.mode = 2;
                    state.time = timer_n*60;
                    error = 0;
                }
                else if ( timer_n == 30 )
                {
                    state.mode = 3;
                    state.time = timer_n*60;
                    error = 0;
                }
                else
                {
                    error = 5;
                }

            }
            else if ( strcmp(str,"loaddt") == 0 )
            {
                state.detergent = 1;
                error = 0;
            }
            else if ( strncmp(str,"door",4) == 0 )
            {
                for (int k = 4; k<len; k++)
                    strncat(sub_str, &str[k], 1);

                len = strlen(sub_str);
                if ( strcmp(sub_str,"open") == 0 )
                {
                    if ( state.door == 2 )
                    {   
                        error = 2;
                        enter_pressed = 0;
                        continue;
                    }
                    else if ( state.door == 1 )
                    {
                        state.door = 0;
                    }
                }
                else if ( strcmp(sub_str,"close") == 0 )
                {
                    if ( state.door == 0 )
                    {
                        state.door = 1;
                    }
                }
                error = 0;
            }
            else if ( strcmp(str,"start") == 0 )
            {
                if ( state.time == 0 || state.detergent == 0 || state.door ==0 )
                {   
                    if(state.time == 0)
                        error = 4;
                    else if (state.detergent == 0)
                        error = 3;
                    else if (state.door == 0)
                        error = 1;
                    enter_pressed = 0;
                    continue;
                }
                if (state.run_state != 1 && state.wash_complete != 1)
                {
                    state.door = 2;
                    state.run_state = 1;
                    blink = 1;
                    WTIMER0_CTL_R = 0x01;
                    TIMER3_CTL_R = 0x01;
                    PWM1_0_CTL_R = (PWM1_0_CTL_R & ~0x01) + 0x01;
                    PWM1_ENABLE_R = 0x01;
                    WTIMER2_CTL_R = 0x01;
                    init_gprs();
                    Command_msg("AT+CMGS=\"7904580576\"","Wash Start");

                }
                else
                {
                    error = 5;
                    enter_pressed = 0;
                    continue;
                }
            }
                
           
            Put_string();
            strcpy(str,"");
            strcpy(sub_str,"");
            enter_pressed = 0;
        }
        else if ( state.wash_complete == 1 )
        {
            blink = 0;
            GPIO_PORTF_DATA_R = 0x0E;
            Put_string();
            state.wash_complete = 0;
            PWM1_0_CTL_R = (PWM1_0_CTL_R & ~0x01) + 0x00;
            PWM1_ENABLE_R = 0x00;
            WTIMER2_CTL_R = 0x00;
            Command("AT+HTTPTERM");
            Command("AT+CGATT=0");
            Command_msg("AT+CMGS=\"7904580576\"","Wash Complete");
            

        }
        if ( sw_command == 1 )
        {
            if (state.run_state == 1)
            {


            blink = 0;
            state.run_state = 2;
            WTIMER0_CTL_R = 0x0;
            TIMER3_CTL_R = 0x0;
            PWM1_0_CTL_R = (PWM1_0_CTL_R & ~0x01) + 0x00;
            PWM1_ENABLE_R = 0x00;
            Command_msg("AT+CMGS=\"7904580576\"","Wash Pause");

            }
        }
        if ( sw_command == 0 && state.run_state != 1 && resume == 1 && state.time != 0 && state.door == 2 && state.detergent == 1 )
        {
            blink = 1;
            state.run_state = 1;
            WTIMER0_CTL_R = 0x01;
            TIMER3_CTL_R = 0x01;
            PWM1_0_CTL_R = (PWM1_0_CTL_R & ~0x01) + 0x01;
            PWM1_ENABLE_R = 0x01;
            Command_msg("AT+CMGS=\"7904580576\"","Wash Resume");
            resume = 0;

        }
        if ( sw_command == 2 )
        {
            if (state.run_state = 1)
            {
                Command("AT+HTTPTERM");
                Command("AT+CGATT=0");
            }
            else
            {

            }
            state_reset(&state);
            timer_n = -1;
            stage_of_wash = 0;
            error = 0;
            sw_command = 0;
            WTIMER0_CTL_R = 0x0;
            TIMER3_CTL_R = 0x0;
            GPIO_PORTF_DATA_R = (GPIO_PORTF_DATA_R & ~0x0E) + 0x0;
            PWM1_0_CTL_R = (PWM1_0_CTL_R & ~0x01) + 0x00;
            PWM1_ENABLE_R = 0x00;
            resume = 0;
            blink = 0;
            WTIMER2_CTL_R = 0x00;

            Command_msg("AT+CMGS=\"7904580576\"","Wash Aborted");
        }
        if ( next_instr_rdy == 1)
        {
            Put_string();
            next_instr_rdy = 0;
            GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;
            GPIO_PORTB_DATA_R = 0x18;
            GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
            start_lcd_delay(0);
        }

        // 7seg display
        timer_min = state.time/60;
        timer_sec = state.time%60;
        if (state.time >0 && state.time < timer_n*0.3*60)
        {
            mode = 1;
            PWM1_0_CMPA_R = 25;
        }

        else if ( state.time > timer_n*0.3*60 && state.time < timer_n*0.8*60 )
        {
            mode = 2;
            PWM1_0_CMPA_R = 25;
        }
        else
        {
            mode = 3;
            PWM1_0_CMPA_R = 25;
        }

        switch(digits_place)
        {
            case 0: timer = timer_sec/10;
                    seg7Disp1(timer);
                    break;
            case 1: timer = timer_min%10;
                    seg7Disp10(timer);
                    break;
            case 2: timer = timer_min/10;
                    seg7Disp100(timer);
                    break;
//            case 3: timer = timer_min/10;
//                    seg7Disp1000(timer);
//                    break;
        }

        switch(state.mode)
        {
        case 0: LCD1[6] = '_';
                LCD1[7] = '_';
                LCD1[8] = '_';
                LCD1[9] = '_';
                LCD1[10] = '_';
                LCD1[11] = '_';
                break;
        case 1: LCD1[6] = 'L';
                LCD1[7] = 'i';
                LCD1[8] = 'g';
                LCD1[9] = 'h';
                LCD1[10] = 't';
                LCD1[11] = '_';
                break;
        case 2: LCD1[6] = 'N';
                LCD1[7] = 'o';
                LCD1[8] = 'r';
                LCD1[9] = 'm';
                LCD1[10] = 'a';
                LCD1[11] = 'l';
                break;
        case 3: LCD1[6] = 'H';
                LCD1[7] = 'e';
                LCD1[8] = 'a';
                LCD1[9] = 'v';
                LCD1[10] = 'Y';
                LCD1[11] = '_';
                break;
        }

        switch(state.door)
        {
        case 0: LCD1[18] = 'O';
                LCD1[19] = 'p';
                LCD1[20] = 'e';
                LCD1[21] = 'n';
                LCD1[22] = '_';
                break;
        case 1: LCD1[18] = 'C';
                LCD1[19] = 'l';
                LCD1[20] = 'o';
                LCD1[21] = 's';
                LCD1[22] = 'e';
                break;
        }
        switch(state.detergent)
        {
        case 0: LCD1[28] = '0';
                break;
        case 1: LCD1[28] = '1';
                break;
        }
        switch(state.run_state)
        {
        case 0: LCD2[7] = 'I';
                LCD2[8] = 'd';
                LCD2[9] = 'l';
                LCD2[10] = 'e';
                LCD2[11] = '_';
                LCD2[12] = '_';
                LCD2[13] = '_';
                LCD2[14] = '_';
                LCD2[15] = '_';
                break;
        case 1: LCD2[7] = 'R';
                LCD2[8] = 'u';
                LCD2[9] = 'n';
                LCD2[10] = 'n';
                LCD2[11] = 'i';
                LCD2[12] = 'n';
                LCD2[13] = 'g';
                LCD2[14] = '_';
                LCD2[15] = '_';
                break;
        case 2: LCD2[7] = 'P';
                LCD2[8] = 'a';
                LCD2[9] = 'u';
                LCD2[10] = 's';
                LCD2[11] = 'e';
                LCD2[12] = 'd';
                LCD2[13] = '_';
                LCD2[14] = '_';
                LCD2[15] = '_';
                break;

        }
        if (state.wash_complete == 1)
        {
                LCD2[7] = 'C';
                LCD2[8] = 'o';
                LCD2[9] = 'm';
                LCD2[10] = 'p';
                LCD2[11] = 'l';
                LCD2[12] = 'e';
                LCD2[13] = 't';
                LCD2[14] = 'e';
                LCD2[15] = '_';

        }
        switch(mode)
        {
        case 0: LCD2[21] = '_';
                LCD2[22] = '_';
                LCD2[23] = '_';
                LCD2[24] = '_';
                LCD2[25] = '_';
                LCD2[26] = '_';
                LCD2[27] = '_';
                break;
        case 1: LCD2[21] = 'S';
                LCD2[22] = 'p';
                LCD2[23] = 'i';
                LCD2[24] = 'n';
                LCD2[25] = '_';
                LCD2[26] = '_';
                LCD2[27] = '_';
                break;
        case 2: LCD2[21] = 'W';
                LCD2[22] = 'a';
                LCD2[23] = 's';
                LCD2[24] = 'h';
                LCD2[25] = '_';
                LCD2[26] = '_';
                LCD2[27] = '_';
                break;
        case 3: LCD2[21] = 'P';
                LCD2[22] = 'r';
                LCD2[23] = 'e';
                LCD2[24] = 'w';
                LCD2[25] = 'a';
                LCD2[26] = 's';
                LCD2[27] = 'h';
                break;
        }
        switch(error)
        {
        case 0: LCD1[33] = '0';
                break;
        case 1: LCD1[33] = '1';
                break;
        case 2: LCD1[33] = '2';
                break;
        case 3: LCD1[33] = '3';
                break;
        case 4: LCD1[33] = '4';
                break;
        case 5: LCD1[33] = '5';
                break;
        case 6: LCD1[33] = '6';
                break;
        case 7: LCD1[33] = '7';
                break;
        }
        if (change == 1)
        {
            Put_string();
            change = 0;
        }

        field1 = state.run_state + '0';
        field2 = state.mode + '0';
        field3 = mode + '0';

        d0 = state.time%10;
        d1 = (state.time/10)%10;
        d2 = (state.time/100)%10;
        d3 = state.time/1000;

        field4[0] = d3+'0';
        field4[1] = d2+'0';
        field4[2] = d1+'0';
        field4[3] = d0+'0';
        field4[4] = '\0';





    }

}

void send_command1(char* str)
{
    char arr[200];
    arr[0] = '\0';
    strcpy(arr,str);
    int i1 = 0;


    while(arr[i1] != '\0')
    {
        UART_write(5,&arr[i1]);
        //UART_write(0,&arr[i1]);
        i1++;
    }
    UART_write(5,&char_enter);
}

void state_reset(struct machine_state *state)
{
    state->power = 0;
    state->door = 0;
    state->time = 0;
    state->mode = 0;
    state->detergent = 0;
    state->run_state = 0;
    state->wash_complete = 0;
}

void UART_handler()
{
    char val;
    val = (UART0_DR_R & 0x000000FF);
    if ( val == 13 )
    {
        enter_pressed = 1;
    }
    else
    {
        strncat(str, &val, 1);
        UART_write(0,&val);
    }

    UART0_ICR_R = 0x10;
}

void Timer_main_handler()
{
    WTIMER0_ICR_R = 0x01;
    if ( state.time != 0 )
    {
        state.time = state.time - 1;
    }
    else if ( state.time == 0 && state.run_state == 1)
    {
        WTIMER0_CTL_R = 0x0;
        state.wash_complete = 1;
        state.run_state = 0;
        state.door = 1;
    }

}

void Timer_7seg_handler()
{
    switch( digits_place )
    {
        case 0: digits_place = 1;
                break;
        case 1: digits_place = 2;
                break;
        case 2: digits_place = 0;
                break;
        case 3: digits_place = 0;
                break;
    }
    TIMER1_ICR_R = 0x01;
}

void Timer_LCD_handler()
{
    next_instr_rdy = 1;
    TIMER2_ICR_R = 0x01;
}

void Timer_LED_handler()
{
    int status;
    if (blink == 1)
    {
        status = GPIO_PORTF_DATA_R & 0x0E;
        if (status == 0)
            {
                GPIO_PORTF_DATA_R = (GPIO_PORTF_DATA_R & ~0x0E) + 0x08;
            }
        else if ( status == 0x08 )
            {
                GPIO_PORTF_DATA_R = (GPIO_PORTF_DATA_R & ~0x0E) + 0x00;
                
            }
    }
    TIMER3_ICR_R = 0x01;
}
        

void Switch_handler()
{
    volatile int readback;
    unsigned int status;

    status = GPIO_PORTF_MIS_R & 0x11;
    GPIO_PORTF_ICR_R = 0x11;
    
    if ( status == 0x01 )
    {
        if ( sw_command == 0 )
            sw_command = 1;
        else if ( sw_command == 1 )
        {
            sw_command = 0;
            resume = 1;
        }
        change = 1;
    }
    else if ( status == 0x10 )
    {
        sw_command = 2;
        change = 1;
    }
    readback = GPIO_PORTF_ICR_R;
    readback = readback;
}

void LCD_init()
{
    TIMER1_CTL_R = 0x0;
    //GPIO_PORTA_DATA_R = 0x80;
    GPIO_PORTB_DATA_R = 0x3C;
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
    start_lcd_delay(1);
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;


    //set display off
    GPIO_PORTB_DATA_R = 0x08;
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
    start_lcd_delay(0);
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;


    //display clear
    GPIO_PORTB_DATA_R = 0x01;
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
    start_lcd_delay(1);
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 )+ 0x80;


    //entry mode set
    GPIO_PORTB_DATA_R = 0x06;
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
    start_lcd_delay(0);
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;

    //display on
    GPIO_PORTB_DATA_R = 0x0F;
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
    start_lcd_delay(0);
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;
    TIMER1_CTL_R = 0x1;
}
void Put_string()
{
    int finish;
    int fin1;
    int lno;
    int count;
    count = 0;
    lno = 0;
    finish = 0;
    fin1 = strlen(LCD1) + strlen(LCD2);
    TIMER3_CTL_R = 0x0;
    GPIO_PORTB_DATA_R = 0x80;
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
    start_lcd_delay(0);
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;
    while(finish != fin1)
    {
        if ( lno == 0 )
        {
            GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0xC0;
            GPIO_PORTB_DATA_R = LCD1[count];
            count = count + 1;
            finish = finish + 1;
            GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x40;
            start_lcd_delay(0);
            GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0xC0;
            if (count == strlen(LCD1))
            {
                lno = 1;
                count = 0;
            }

        }
        else
        {
            if ( count == 0 )
            {
                GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;
                GPIO_PORTB_DATA_R = 0xC0;
                GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
                start_lcd_delay(0);
                GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;

            }
            GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0xC0;
            GPIO_PORTB_DATA_R = LCD2[count];
            count = count + 1;
            finish = finish + 1;
            GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x40;
            start_lcd_delay(0);
            GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0xC0;
        }
    }
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;
    GPIO_PORTB_DATA_R = 0x80;
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x00;
    start_lcd_delay(0);
    GPIO_PORTA_DATA_R = (GPIO_PORTA_DATA_R & ~0xF0 ) + 0x80;

    TIMER3_CTL_R = 0x01;

}
void start_lcd_delay(int sel)
{
    TIMER0_CTL_R = 0x00;      /* disable timer for initialization */
    TIMER0_CFG_R = 0x4;       /* 16 bit timer mode */
    TIMER0_TAMR_R = 0x1;      /* oneshot mode */
    if (sel == 1)
        TIMER0_TAILR_R = CYCLES_LCD1 ;  /* Load and reload value for delay */
    else
        TIMER0_TAILR_R = CYCLES_LCD2 ;  /* Load and reload value for delay */
    TIMER0_CTL_R = (TIMER0_CTL_R & 0xFFFFFFFC) + 0x3; /* Timer enable */
    while ((TIMER0_RIS_R & 0x01) != 0x01)
            {

            }
    TIMER0_ICR_R = 0x01;
}

void Command(char* str)
{
    while(wait_for_command == 1)
    {

    }
    send_command(str);

}
void Command_dld(char* cmd)
{
    while(wait_for_dld != 2)
    {

    }
    send_command(cmd);
    wait_for_dld = 0;
}

void Command2(char*str)
{
    while(wait_for_command == 1)
    {

    }
    wait_for_command = 1;
    while(wait_for_command == 1)
    {

    }
    send_command(str);
}

void send_command(char* str)
{
    char arr[200];
    arr[0] = '\0';
    strcpy(arr,str);
    int i1 = 0;


    while(arr[i1] != '\0')
    {
        UART_write(5,&arr[i1]);
        //UART_write(0,&arr[i1]);
        i1++;
    }
    UART_write(5,&char_enter);
    //UART_write(0,&char_enter);
    wait_for_command = 1;

}


void send_msg(char* msg)
{
    char arr[100];
    arr[0] = '\0';
    strcpy(arr,msg);
    char ctrlz = 26;
    int i = 0;

        while(arr[i] != '\0')
            {
                UART_write(5,&arr[i]);
                i++;
            }
    UART_write(5,&ctrlz);
    wait_for_msg = 0;
}

void Command_msg(char* cmd, char* msg)
{
    send_command(cmd);
    while(wait_for_msg == 0)
    {
    }
    send_msg(msg);

}
void UART5_handler()
{
    char val;
    val = (UART5_DR_R & 0x000000FF);

    if (val == 'K')
    {
            wait_for_command = 0;


    }
    else if (val == 62)
    {
        wait_for_msg = 1;

    }
    else if (val == 46)
    {
        wait_for_command = 0;
    }
    else if (val == 'D')
    {

        if(wait_for_dld == 0)
            wait_for_dld = 1;
        else if (wait_for_dld == 1)
            wait_for_dld = 2;
    }
//    if (flag_for_d == 1 and i<)
//    {
//        strncat(dstr,&val,1);
//        i++:
//    }
    UART_write(0,&val);
    UART5_ICR_R = 0x10;
}

void init_gprs()
{
    Command("ATE1");
    Command("AT");
//    Command("AT+HTTPTERM");
//    Command("AT+CGATT=0");
    Command("AT+CGATT=1");
    Command("AT+SAPBR=3,1,\"Contype\",\"GPRS\"");
    Command("AT+SAPBR=3,1,\"APN\",\"internet\"");
    Command("AT+SAPBR=1,1");
    Command("AT+HTTPINIT");
    Command("AT+HTTPPARA=\"CID\",1");
    Command("AT+HTTPPARA=\"URL\",\"api.thingspeak.com/update\"");
    Command("AT");
    //Command("AT+SAPBR=2,1");
}

void Timer_10shandler()
{


    WTIMER2_ICR_R = 0x01;
    strcat(str_fin,str1);
    strcat(str_fin,"&field1=");
    strncat(str_fin,&field1,1);
    strcat(str_fin,"&field2=");
    strncat(str_fin,&field2,1);
    strcat(str_fin,"&field3=");
    strncat(str_fin,&field3,1);
    strcat(str_fin,"&field4=");
    strcat(str_fin,field4);
    if (state.run_state == 1 || state.run_state == 2)
    {
    Command("ATE0");
    Command("AT+HTTPDATA=70,2000");
    start_lcd_delay(1);
    Command_dld(str_fin);
    }
    str_fin[0] = '\0';

    TIMER4_CTL_R = 0x101;
}
void Timer_0_8shandler()
{
    TIMER4_ICR_R = 0x01;
    TIMER4_CTL_R = 0x00;

    //send_command1(str_fin);
    TIMER5_CTL_R = 0x101;
}

void Timer_1shandler()
{
    TIMER5_ICR_R = 0x01;
    TIMER5_CTL_R = 0x00;
    if (state.run_state == 1 || state.run_state == 2)
    {
        Command("ATE1");
        Command("AT+HTTPACTION=1");
    }


    WTIMER1_CTL_R = 0x01;
}
void Timer_1_2shandler()
{
    WTIMER1_ICR_R = 0x01;
    WTIMER1_CTL_R = 0x00;
    //Command("AT+HTTPTERM");

}
void delayMs(int n)

{

    int i, j;

    for(i = 0 ; i < n; i++)

        for(j = 0; j < 3180; j++) {}   /* do nothing for 1 ms */

}
