/*
 * UART_driver.h
 *
 *  Created on: 28-Feb-2022
 *      Author: surya
 */
#include <stdint.h>
#ifndef UART_DRIVER_H_
#define UART_DRIVER_H_

/* Initialises  UART no. iPort with default Baudrate = 115,200, 8bit data, 1 stop bit, no parity, no FIFO */
int UART_init(
    int iPort);


/* UART write function which writes a character from the character pointer pc to UART no. iPort */
int UART_write(
    int iPort,
    unsigned char *pc);


/* Receives a character from the given UART module and places the byte into address pointed by char pointer pc */
int UART_read(
    int iPort,
    unsigned char *pc);

int UART_interrupt_init(int iPort);  // enables receive interrupt for the given UART port
                                    // Please write handler and set nvic priority accordingly


/* Get the status of the UART module - intitialised or not,
                                       transmit idle or busy,
                                       receive idle or busy,
                                       uart idle or busy
 */
int UART_status(
        int iPort,
        int* init_status,
        int* tx_status,
        int* rx_status,
        int* uart_status);


/* Rx_status - gives 1 if Rx FIFO is full and ready for read */
int UART_rx_status(
        int iPort);

/* Function for checking if UART was initialised - returns 1 if initialised, 0 if not initialised */
int UART_init_status(
        int iPort);



#endif /* UART_DRIVER_H_ */
