/*
 * uart_driver.c
 *
 *  Created on: 28-Feb-2022
 *      Author: surya
 */
#include <./inc/tm4c123gh6pm.h>
#include <stdbool.h>
#include <stdint.h>
#include "UART_driver.h"

/* Initialises  UART no. iPort with default Baudrate = 115,200, 8bit data, 1 stop bit, no parity, no FIFO */
int UART_init(
	int iPort)
	// int iBaudRate,
	// int iParity_NOEMS)
{	
 switch( iPort )
 {
    case 0:  // PA0 AND PA1
		SYSCTL_RCGCUART_R |= 0x00000001;                    // Enable clock for UART0
		SYSCTL_RCGC2_R |= 0x00000001;                       // Set GPIO PORTA clock to 1 for UART0
		GPIO_PORTA_AFSEL_R = (GPIO_PORTA_AFSEL_R & 0xFFFFFFF0) + 0x00000003;                   // Set GPIO PORTA to Alternate select PA0 and PA1
		GPIO_PORTA_PCTL_R = 0x00000011; // Set GPIO PA0 and PA1 to function as UART
		
		
		GPIO_PORTA_DEN_R = (GPIO_PORTA_DEN_R & 0xFFFFFF00) + 0x00000003;                           // Set GPIO PORTA Digital enable for PA0 and PA1
		// GPIO_PORTA_AMSEL_R = 0x00000000;                   // Disable analog function for PORTA
		
		
		while((UART0_FR_R & 0x00000008) != 0x00 )
		{
		
		}
		UART0_CTL_R = (UART0_CTL_R & 0xFFFFF0FE) + 0x00000000;   // Disable UART0
		UART0_IBRD_R = 0x00000008;                                      // Set Baud rate Integer = 8, Fractional = 44 for 115,200 Baud
		UART0_FBRD_R = 0x0000002C;
		UART0_LCRH_R = 0x60;                                      // 8bit data, no parity bit, 1 stop bit
		UART0_CTL_R = 0x00000301;   // Set UART enable, Tx and Rx Enable

        break;
	
    case 1:  // PB0 AND PB1
        SYSCTL_RCGCUART_R |= 0x00000002;                    // Enable clock for UART1
		SYSCTL_RCGC2_R |= 0x00000002;                       // Set GPIO PORTB clock to 1 for UART1
		GPIO_PORTB_AFSEL_R = (GPIO_PORTB_AFSEL_R & 0xFFFFFFF0) + 0x00000003;                   // Set GPIO PORTB to Alternate select PB0 and PB1
		GPIO_PORTB_PCTL_R = 0x00000011; // Set GPIO PB0 and PB1 to function as UART
		
		
		GPIO_PORTB_DEN_R = 0x00000003;                           // Set GPIO PORTB Digital enable for PB0 and PB1
		// GPIO_PORTB_AMSEL_R = 0x00000000;                   // Disable analog function for PORTB
		
		
		while((UART1_FR_R & 0x00000008) != 0x00 )
		{
		
		}
		UART1_CTL_R = (UART1_CTL_R & 0xFFFFF0FE) + 0x00000000;   // Disable UART1
		UART1_IBRD_R = 0x00000008;                                      // Set Baud rate Integer = 8, Fractional = 44 for 115,200 Baud
		UART1_FBRD_R = 0x0000002C;
		UART1_LCRH_R = 0x60;                                      // 8bit data, no parity bit, 1 stop bit
		UART1_CTL_R = 0x00000301;   // Set UART enable, Tx and Rx Enable
        
        break;

    case 2: // PD6 AND PD7
        SYSCTL_RCGCUART_R |= 0x00000004;                    // Enable clock for UART2
		SYSCTL_RCGC2_R |= 0x00000008;                       // Set GPIO PORTD clock to 1 for UART2
        GPIO_PORTD_LOCK_R = 0x4C4F434B;                     // Remove lock for PD7
        GPIO_PORTD_CR_R = 0x0C0;
		GPIO_PORTD_AFSEL_R = (GPIO_PORTD_AFSEL_R & 0xFFFFFF0F) + 0x000000C0;                   // Set GPIO PORTD to Alternate select PD6 and PD7
		GPIO_PORTD_PCTL_R = 0x11000000; // Set GPIO PD6 and PD7 to function as UART
		
		
		GPIO_PORTD_DEN_R = 0x000000C0;                           // Set GPIO PORTD Digital enable for PD6 and PD7
		// GPIO_PORTD_AMSEL_R = 0x00000000;                   // Disable analog function for PORTD
		
		
		while((UART2_FR_R & 0x00000008) != 0x00 )
		{
		
		}
		UART2_CTL_R = (UART2_CTL_R & 0xFFFFF0FE) + 0x00000000;   // Disable UART2
		UART2_IBRD_R = 0x00000008;                                      // Set Baud rate Integer = 8, Fractional = 44 for 115,200 Baud
		UART2_FBRD_R = 0x0000002C;
		UART2_LCRH_R = 0x60;                                      // 8bit data, no parity bit, 1 stop bit
		UART2_CTL_R = 0x00000301;   // Set UART enable, Tx and Rx Enable
        
        break;

    case 3:  // PC6 AND PC7
        SYSCTL_RCGCUART_R |= 0x00000008;                    // Enable clock for UART3
		SYSCTL_RCGC2_R |= 0x00000004;                       // Set GPIO PORTC clock to 1 for UART3
		GPIO_PORTC_AFSEL_R = (GPIO_PORTC_AFSEL_R & 0xFFFFFF0F) + 0x000000C0;                   // Set GPIO PORTC to Alternate select PC6 and PC7
		GPIO_PORTC_PCTL_R = 0x11000000; // Set GPIO PC6 and PC7 to function as UART
		
		
		GPIO_PORTC_DEN_R = 0x000000C0;                           // Set GPIO PORTC Digital enable for PC6 and PC7
		// GPIO_PORTC_AMSEL_R = 0x00000000;                   // Disable analog function for PORTC
		
		
		while((UART3_FR_R & 0x00000008) != 0x00 )
		{
		
		}
		UART3_CTL_R = (UART3_CTL_R & 0xFFFFF0FE) + 0x00000000;   // Disable UART3
		UART3_IBRD_R = 0x00000008;                                      // Set Baud rate Integer = 8, Fractional = 44 for 115,200 Baud
		UART3_FBRD_R = 0x0000002C;
		UART3_LCRH_R = 0x60;                                      // 8bit data, no parity bit, 1 stop bit
		UART3_CTL_R = 0x00000301;   // Set UART enable, Tx and Rx Enable
        
        break;

    case 4: // PC4 AND PC5
        SYSCTL_RCGCUART_R |= 0x00000010;                    // Enable clock for UART4
		SYSCTL_RCGC2_R |= 0x00000004;                       // Set GPIO PORTC clock to 1 for UART4
		GPIO_PORTC_AFSEL_R = (GPIO_PORTC_AFSEL_R & 0xFFFFFF0F) + 0x00000030;                   // Set GPIO PORTC to Alternate select PC4 and PC5
		GPIO_PORTC_PCTL_R = 0x00110000; // Set GPIO PC4 and PC5 to function as UART
		
		
		GPIO_PORTC_DEN_R = 0x00000030;                           // Set GPIO PORTC Digital enable for PC4 and PC5
		// GPIO_PORTC_AMSEL_R = 0x00000000;                   // Disable analog function for PORTC
		
		
		while((UART4_FR_R & 0x00000008) != 0x00 )
		{
		
		}
		UART4_CTL_R = (UART4_CTL_R & 0xFFFFF0FE) + 0x00000000;   // Disable UART4
		UART4_IBRD_R = 0x00000008;                                      // Set Baud rate Integer = 8, Fractional = 44 for 115,200 Baud
		UART4_FBRD_R = 0x0000002C;
		UART4_LCRH_R = 0x60;                                      // 8bit data, no parity bit, 1 stop bit
		UART4_CTL_R = 0x00000301;   // Set UART enable, Tx and Rx Enable
        
        break;
    
    case 5: // PE4 AND PE5
        SYSCTL_RCGCUART_R |= 0x00000020;                    // Enable clock for UART5
		SYSCTL_RCGC2_R |= 0x00000010;                       // Set GPIO PORTE clock to 1 for UART5
		GPIO_PORTE_AFSEL_R = (GPIO_PORTE_AFSEL_R & 0xFFFFFF0F) + 0x00000030;                   // Set GPIO PORTE to Alternate select PE4 and PE5
		GPIO_PORTE_PCTL_R = 0x00110000; // Set GPIO PE4 and PE5 to function as UART
		
		
		GPIO_PORTE_DEN_R = 0x00000030;                           // Set GPIO PORTE Digital enable for PE4 and PE5
		// GPIO_PORTE_AMSEL_R = 0x00000000;                   // Disable analog function for PORTE
		
		
		while((UART5_FR_R & 0x00000008) != 0x00 )
		{
		
		}
		UART5_CTL_R = (UART5_CTL_R & 0xFFFFF0FE) + 0x00000000;   // Disable UART5
		UART5_IBRD_R = 0x00000008;                                      // Set Baud rate Integer = 8, Fractional = 44 for 115,200 Baud
		UART5_FBRD_R = 0x0000002C;
		UART5_LCRH_R = 0x60;                                      // 8bit data, no parity bit, 1 stop bit
		UART5_CTL_R = 0x00000301;   // Set UART enable, Tx and Rx Enable
        
        break;

    case 6: // PD4 AND PD5
        SYSCTL_RCGCUART_R |= 0x00000040;                    // Enable clock for UART6
		SYSCTL_RCGC2_R |= 0x00000008;                       // Set GPIO PORTD clock to 1 for UART6
		GPIO_PORTD_AFSEL_R = (GPIO_PORTD_AFSEL_R & 0xFFFFFF0F) + 0x00000030;                   // Set GPIO PORTD to Alternate select PD4 and PD5
		GPIO_PORTD_PCTL_R = 0x00110000; // Set GPIO PD4 and PD5 to function as UART
		
		
		GPIO_PORTD_DEN_R = 0x00000030;                           // Set GPIO PORTD Digital enable for PD4 and PD5
		// GPIO_PORTD_AMSEL_R = 0x00000000;                   // Disable analog function for PORTD
		
		
		while((UART6_FR_R & 0x00000008) != 0x00 )
		{
		
		}
		UART6_CTL_R = (UART6_CTL_R & 0xFFFFF0FE) + 0x00000000;   // Disable UART6
		UART6_IBRD_R = 0x00000008;                                      // Set Baud rate Integer = 8, Fractional = 44 for 115,200 Baud
		UART6_FBRD_R = 0x0000002C;
		UART6_LCRH_R = 0x60;                                      // 8bit data, no parity bit, 1 stop bit
		UART6_CTL_R = 0x00000301;   // Set UART enable, Tx and Rx Enable
        
        break;

    case 7: // PE0 AND PE1
        SYSCTL_RCGCUART_R |= 0x00000080;                    // Enable clock for UART7
		SYSCTL_RCGC2_R |= 0x00000010;                       // Set GPIO PORTE clock to 1 for UART7
		GPIO_PORTE_AFSEL_R = (GPIO_PORTE_AFSEL_R & 0xFFFFFF0F) + 0x00000003;                   // Set GPIO PORTE to Alternate select PE0 and PE1
		GPIO_PORTE_PCTL_R = 0x00000011; // Set GPIO PE0 and PE1 to function as UART
		
		
		GPIO_PORTE_DEN_R = 0x00000003;                           // Set GPIO PORTE Digital enable for PE0 and PE1
		// GPIO_PORTE_AMSEL_R = 0x00000000;                   // Disable analog function for PORTE
		
		
		while((UART7_FR_R & 0x00000008) != 0x00 )
		{
		
		}
		UART7_CTL_R = (UART7_CTL_R & 0xFFFFF0FE) + 0x00000000;   // Disable UART7
		UART7_IBRD_R = 0x00000008;                                      // Set Baud rate Integer = 8, Fractional = 44 for 115,200 Baud
		UART7_FBRD_R = 0x0000002C;
		UART7_LCRH_R = 0x60;                                      // 8bit data, no parity bit, 1 stop bit
		UART7_CTL_R = 0x00000301;   // Set UART enable, Tx and Rx Enable
        
        break;

    default:

    
        return 2;           // INVALID UART SELECTION
 }

 return 0;
 
}

int UART_interrupt_init(int iPort)  // enables receive interrupt for the given UART port
                                    // Please write handler and set nvic priority accordingly
{
    if ( UART_init_status(iPort) == 0 )
     {
         return 1;                // UART not initialised
     }
    switch(iPort)
    {
    case 0: UART0_IM_R = 0x10;    // UART receive interrupt mask set
            NVIC_PRI1_R = (NVIC_PRI1_R & 0xFFFF1FFF) | 0x0000A000; /*  priority 5 */
            NVIC_EN0_R = 0x00000020;        /*  Enable interrupt 5 in NVIC */
            break;
    case 5: UART5_IM_R = 0x10;
                NVIC_PRI15_R = (NVIC_PRI15_R & 0xFFFF1FFF) | 0x00006000;
                NVIC_EN1_R = (NVIC_EN1_R & ~20000000) | 0x20000000;
                break;
    default: UART0_IM_R = 0x10;
    }
    return 0;
}
/* UART write function which writes a character from the character pointer pc to UART no. iPort */
int UART_write( 
	int iPort,                // UART module no. 1-7
	unsigned char *pc)        // char pointer pointing to character to be sent
{
 unsigned int tx_state;      // variable to store tx-state - idle,busy
 tx_state = 0x20;

 if ( UART_init_status(iPort) == 0 )
 {
     return 1;                // UART not initialised
 }

 switch(iPort)
 {
    case 0:
        while( tx_state != 0x00 )   // wait until tx_fifo is empty
        {
           tx_state = UART0_FR_R & 0x0000020;       // get the value of tx_fifo_fe into tx_state
        }
        UART0_DR_R = (UART0_DR_R & 0xFFFFFF00) + *pc;     // set 8 bit value into transmit register's last byte
        break;

    case 1:
        while( tx_state != 0x00 )   // wait until tx_fifo is empty
        {
           tx_state = UART1_FR_R & 0x0000020;       // get the value of tx_fifo_fe into tx_state
        }
        UART1_DR_R = (UART1_DR_R & 0xFFFFFF00) + *pc;     // set 8 bit value into transmit register's last byte
        break;
    
    case 2:
        while( tx_state != 0x00 )   // wait until tx_fifo is empty
        {
           tx_state = UART2_FR_R & 0x0000020;       // get the value of tx_fifo_fe into tx_state
        }
        UART2_DR_R = (UART2_DR_R & 0xFFFFFF00) + *pc;     // set 8 bit value into transmit register's last byte
        break;

    case 3:
        while( tx_state != 0x00 )   // wait until tx_fifo is empty
        {
           tx_state = UART3_FR_R & 0x0000020;       // get the value of tx_fifo_fe into tx_state
        }
        UART3_DR_R = (UART3_DR_R & 0xFFFFFF00) + *pc;     // set 8 bit value into transmit register's last byte
        break;

    case 4:
        while( tx_state != 0x00 )   // wait until tx_fifo is empty
        {
           tx_state = UART4_FR_R & 0x0000020;       // get the value of tx_fifo_fe into tx_state
        }
        UART4_DR_R = (UART4_DR_R & 0xFFFFFF00) + *pc;     // set 8 bit value into transmit register's last byte
        break;

    case 5:
        while( tx_state != 0x00 )   // wait until tx_fifo is empty
        {
           tx_state = UART5_FR_R & 0x0000020;       // get the value of tx_fifo_fe into tx_state
        }
        UART5_DR_R = (UART5_DR_R & 0xFFFFFF00) + *pc;     // set 8 bit value into transmit register's last byte
        break;

    case 6:
        while( tx_state != 0x00 )   // wait until tx_fifo is empty
        {
           tx_state = UART6_FR_R & 0x0000020;       // get the value of tx_fifo_fe into tx_state
        }
        UART6_DR_R = (UART6_DR_R & 0xFFFFFF00) + *pc;     // set 8 bit value into transmit register's last byte
        break;

    case 7:
        while( tx_state != 0x00 )   // wait until tx_fifo is empty
        {
           tx_state = UART7_FR_R & 0x0000020;       // get the value of tx_fifo_fe into tx_state
        }
        UART7_DR_R = (UART7_DR_R & 0xFFFFFF00) + *pc;     // set 8 bit value into transmit register's last byte
        break;

    default:
        return 2;        // invalid UART selection
        
 }

return 0;

}


/* Receives a character from the given UART module and places the byte into address pointed by char pointer pc */
int UART_read( 
	int iPort,                // UART module no. 1-7
	unsigned char *pc)        // character pointer where received character to be saved
{
 unsigned int rx_state;       // var to store whether rx fifo full
 rx_state = 0x10;

 if ( UART_init_status(iPort) == 0)
 {
     return 1;                   // UART not initialised
 }

 //while( rx_state != 0x00 )    // wait until rx fifo is full
 //{
 //	  rx_state = UART0_FR_R & 0x00000010;     // get value of rx fifo full bit from flag register
 //}
 
 switch (iPort)
 {
    case 0:
        rx_state = UART0_FR_R & 0x00000010;
        if ( rx_state == 0x00 )
        {
            *pc = (UART0_DR_R & 0x000000FF);          // get last byte from receive register into the char pointer
            return 0;
        }
        break;

    case 1:
        rx_state = UART1_FR_R & 0x00000010;
        if ( rx_state == 0x00 )
        {
            *pc = (UART1_DR_R & 0x000000FF);          // get last byte from receive register into the char pointer
            return 0;
        }
        break;
    
    case 2:
        rx_state = UART2_FR_R & 0x00000010;
        if ( rx_state == 0x00 )
        {
            *pc = (UART2_DR_R & 0x000000FF);          // get last byte from receive register into the char pointer
            return 0;
        }
        break;

    case 3:
        rx_state = UART3_FR_R & 0x00000010;
        if ( rx_state == 0x00 )
        {
            *pc = (UART3_DR_R & 0x000000FF);          // get last byte from receive register into the char pointer
            return 0;
        }
        break;

    case 4:
        rx_state = UART4_FR_R & 0x00000010;
        if ( rx_state == 0x00 )
        {
            *pc = (UART4_DR_R & 0x000000FF);          // get last byte from receive register into the char pointer
            return 0;
        }
        break;

    case 5:
        rx_state = UART5_FR_R & 0x00000010;
        if ( rx_state == 0x00 )
        {
            *pc = (UART5_DR_R & 0x000000FF);          // get last byte from receive register into the char pointer
            return 0;
        }
        break;

    case 6:
        rx_state = UART6_FR_R & 0x00000010;
        if ( rx_state == 0x00 )
        {
            *pc = (UART6_DR_R & 0x000000FF);          // get last byte from receive register into the char pointer
            return 0;
        }
        break;

    case 7:
        rx_state = UART7_FR_R & 0x00000010;
        if ( rx_state == 0x00 )
        {
            *pc = (UART7_DR_R & 0x000000FF);          // get last byte from receive register into the char pointer
            return 0;
        }
        break;

    default:
        return 2;               // invalid UART selection
 }

 return 3;    // RX not full
}

/* Get the status of the UART module - intitialised or not,
                                       transmit idle or busy,
                                       receive idle or busy,
                                       uart idle or busy
 */
int UART_status(
        int iPort,             // UART module no.
        int* init_status,
        int* rx_status,
        int* tx_status,
        int* uart_status)
{
    if ( (SYSCTL_RCGCUART_R & 0x00000001) == 0x01 )
    {
        (*init_status) = 1;           // UART0 clock initialised
    }
    else
    {
        (*init_status) = 0;           // UART0 not initialised
    }

    if ( (UART0_CTL_R & 0x00000301) == 0x00000301)
    {
        (*uart_status) = 1;           // UART0 is enabled
    }
    else
    {
        (*uart_status) = 0;           // UART0 is not enabled
    }

    if ((UART0_FR_R & 0x08) == 0x08)
    {
        (*tx_status) = 1;           // tx is free
    }
    else
    {
        (*tx_status) = 0;           // tx is busy
    }

    if ( (UART0_FR_R & 0x010) == 0x00 )
    {
        (*rx_status) = 1;           //rx is full
    }
    else
    {
        (*rx_status) = 0;           //rx is empty
    }
    return 0;
}



/* Rx_status - gives 1 if Rx FIFO is full and ready for read */
int UART_rx_status(
        int iPort)
{
    unsigned int val;
    
    switch(iPort)                         // get Rx FE bit
    {
        case 0:
            val = UART0_FR_R & 0x010;
            break;

        case 1:
            val = UART1_FR_R & 0x010;
            break;

        case 2:
            val = UART2_FR_R & 0x010;
            break;

        case 3:
            val = UART3_FR_R & 0x010;
            break;

        case 4:
            val = UART4_FR_R & 0x010;
            break;

        case 5:
            val = UART5_FR_R & 0x010;
            break;

        case 6:
            val = UART6_FR_R & 0x010;
            break;

        case 7:
            val = UART7_FR_R & 0x010;
            break;

        default:
            return 2;          // invalid UART selection
    }
            
    if ( val == 0x00 )     //if Rx FE bit is low (0) then FIFO is full and ready for read
    {
        return 1;          //rx is full
    }
    else
    {
        return 0;           //rx is empty
    }

}


/* Function for checking if UART was initialised - returns 1 if initialised, 0 if not initialised */
int UART_init_status(
        int iPort)
{
    unsigned int val;

    switch (iPort)               // set val with clock bit of sysctl rcgc register
    {                            // and check if its set high
        case 0:
            val = SYSCTL_RCGCUART_R & 0x00000001;
            if (val == 0x01 )
            {
                return 1;
            }
            else
            {
                return 0;
            }
            break;

        case 1:
            val = SYSCTL_RCGCUART_R & 0x00000002;
            if (val == 0x02 )
            {
                return 1;
            }
            else
            {
                return 0;
            }
            break;

        case 2:
            val = SYSCTL_RCGCUART_R & 0x00000004;
            if (val == 0x04 )
            {
                return 1;
            }
            else
            {
                return 0;
            }
            break;

        case 3:
            val = SYSCTL_RCGCUART_R & 0x00000008;
            if (val == 0x08 )
            {
                return 1;
            }
            else
            {
                return 0;
            }
            break;

        case 4:
            val = SYSCTL_RCGCUART_R & 0x00000010;
            if (val == 0x10 )
            {
                return 1;
            }
            else
            {
                return 0;
            }
            break;

        case 5:
            val = SYSCTL_RCGCUART_R & 0x00000020;
            if (val == 0x20 )
            {
                return 1;
            }
            else
            {
                return 0;
            }
            break;

        case 6:
            val = SYSCTL_RCGCUART_R & 0x00000040;
            if (val == 0x40 )
            {
                return 1;
            }
            else
            {
                return 0;
            }
            break;

        case 7:
            val = SYSCTL_RCGCUART_R & 0x00000080;
            if (val == 0x80 )
            {
                return 1;
            }
            else
            {
                return 0;
            }
            break;
        default:
            return 2;              // invalid UART selection
    }
    return 0;

}
