/*
 * Peripheral_Init.h
 *
 *
 *      Author: surya
 */
#include <stdint.h>
#ifndef PERIPHERAL_INIT_H_
#define PERIPHERAL_INIT_H_

/* Contains functions which can be used to initialise given peripherals and hardware interfaces

*/

#define CYCLES_1SEC (0xF42400)
#define CYCLES_1MSEC (0x3E80)
#define CYCLES_LCD1 (0x6680)
#define CYCLES_LCD2 (0x280)
#define CYCLES_LCD3 (0xF42400)
#define CYCLES_LED (0x7A1200)

/* Main Timer - A 32 bit timer which can count max upto 268.43s
                1 sec count
                Uses the 32 bit timer Timer0
                Enable/Disable Timer in Main program
*/
void Timer_Main_init();


/* Timer to refresh 7seg display - A 16bit timer which can count max upto 4ms
                                   1ms count
                                   uses Timer A of Timer1
                                   Enable disable in Main Program
*/
void Timer_7seg_init();

/* Timer to wait for LCD delay - A 16 bit timer which can count upto 4ms
                                 2 delays 1.64ms and 40us
                                 uses Timer A of Timer2 in one shot mode
                                 Enable disable and set count in Main Program
*/
void Timer_LCD_init();


/* Timer for LED blinking delay - A 32 bit timer with delay of 0.5s
                                  uses Timer A of Timer3 in periodic mode
                                  Enable disable in Main Program
*/
void Timer_LED_init();

/* Timer for data logging  - A 24 bit timer with delay of 800ms
                                  uses Timer A of Timer4 in one shot mode
                                  Enable disable in Main Program
*/
void Timer_log_0_8s();
/* Timer for data logging  - A 24 bit timer with delay of 1s
                                  uses Timer A of Timer5 in one shot mode
                                  Enable disable in Main Program
*/
void Timer_log_1s();
void Timer_log_1_2s();
void Timer_log_10s();

/* Initialise LEDS on PF3-1 and SW's on PF4 and PF0
   Also arm voiderrupts for the switches
   Enable in NVIC in main program
*/
void LED_SW_init();

/* Enable PWM1_0 on pin PD0 */
void pwm_init();


/* Enable Pins PB7-0 and PA7-4 as output digital enable for 7 segment display
   and LCD
*/
void seg7_init();


/*  7 seg display functions */

// mapping from Integer to Hex for 7segment display
unsigned int DispMap(int n);

// Display 1's place
void seg7Disp1(int n);

//Display 10's place
void seg7Disp10(int n);

//Display 100's place
void seg7Disp100(int n);

// Display 1000's place
void seg7Disp1000(int n);

#endif /* PERIPHERAL_INIT_H_ */
